/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.AnalysisPreferences;
import com.python.pydev.analysis.builder.AnalysisBuilderVisitor;
import com.python.pydev.analysis.builder.AnalysisRunner;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.parser.ChangedParserInfoForObservers;
import org.python.pydev.core.parser.ErrorParserInfoForObservers;
import org.python.pydev.core.parser.IParserObserver;
import org.python.pydev.core.parser.IParserObserver3;
import org.python.pydev.core.parser.ISimpleNode;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.nature.PythonNature;

public class AnalysisParserObserver
implements IParserObserver,
IParserObserver3 {
    public static final String ANALYSIS_PARSER_OBSERVER_FORCE = "AnalysisParserObserver:force";

    public void parserChanged(ChangedParserInfoForObservers info) {
        int whenAnalyze;
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            System.out.println("AnalysisParserObserver: parserChanged");
        }
        SimpleNode root = (SimpleNode)info.root;
        if (info.file == null) {
            return;
        }
        IFile fileAdapter = null;
        if (info.file instanceof IFile) {
            fileAdapter = (IFile)info.file;
        }
        if (fileAdapter == null && (fileAdapter = (IFile)info.file.getAdapter(IFile.class)) == null) {
            return;
        }
        boolean force = false;
        if (info.argsToReparse != null && info.argsToReparse.length > 0 && info.argsToReparse[0] instanceof Tuple) {
            Tuple t = (Tuple)info.argsToReparse[0];
            if (t.o1 instanceof String && t.o2 instanceof Boolean && t.o1.equals(ANALYSIS_PARSER_OBSERVER_FORCE)) {
                force = (Boolean)t.o2;
            }
        }
        if ((whenAnalyze = AnalysisPreferences.getAnalysisPreferences().getWhenAnalyze()) == 2 || force) {
            PythonNature nature = PythonNature.getPythonNature((IResource)fileAdapter);
            if (nature == null) {
                return;
            }
            if (!nature.isOkToUse()) {
                AnalyzeLaterJob job = new AnalyzeLaterJob("Analyze later", info, root, fileAdapter, force, (IPythonNature)nature);
                job.schedule(100L);
                return;
            }
            this.analyze(info, root, fileAdapter, force, (IPythonNature)nature);
        }
    }

    private void analyze(ChangedParserInfoForObservers info, SimpleNode root, IFile fileAdapter, boolean force, IPythonNature nature) {
        IModule module;
        if (!nature.startRequests()) {
            return;
        }
        try {
            String moduleName = nature.resolveModuleOnlyInProjectSources((IResource)fileAdapter, true);
            if (moduleName == null) {
                AnalysisRunner.deleteMarkers((IResource)fileAdapter);
                return;
            }
            try {
                String file = fileAdapter.getRawLocation().toOSString();
                module = AbstractModule.createModule((SimpleNode)root, (File)new File(file), (String)moduleName);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return;
            }
        }
        finally {
            nature.endRequests();
        }
        AnalysisBuilderVisitor visitor = new AnalysisBuilderVisitor();
        visitor.memo = new HashMap();
        visitor.memo.put("IS_FULL_BUILD", false);
        visitor.memo.put("DOCUMENT_TIME", info.documentTime);
        visitor.visitingWillStart((IProgressMonitor)new NullProgressMonitor(), false, null);
        try {
            visitor.doVisitChangedResource(nature, (IResource)fileAdapter, info.doc, null, module, (IProgressMonitor)new NullProgressMonitor(), force, 2, info.documentTime);
        }
        finally {
            visitor.visitingEnded((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void parserChanged(ISimpleNode root, IAdaptable resource, IDocument doc) {
        throw new RuntimeException("As it uses IParserObserver2, this interface should not be asked for.");
    }

    public void parserError(Throwable error, IAdaptable file, IDocument doc) {
    }

    public void parserError(ErrorParserInfoForObservers info) {
    }

    private final class AnalyzeLaterJob
    extends Job {
        private final IPythonNature nature;
        private ChangedParserInfoForObservers info;
        private SimpleNode root;
        private IFile fileAdapter;
        private boolean force;
        private int rescheduleTimes;

        private AnalyzeLaterJob(String name, ChangedParserInfoForObservers info, SimpleNode root, IFile fileAdapter, boolean force, IPythonNature nature) {
            super(name);
            this.rescheduleTimes = 15;
            this.nature = nature;
            this.info = info;
            this.root = root;
            this.fileAdapter = fileAdapter;
            this.force = force;
        }

        protected IStatus run(IProgressMonitor monitor) {
            --this.rescheduleTimes;
            try {
                if (!this.nature.isOkToUse()) {
                    if (this.rescheduleTimes >= 0) {
                        this.schedule(200L);
                    }
                } else {
                    AnalysisParserObserver.this.analyze(this.info, this.root, this.fileAdapter, this.force, this.nature);
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

