/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.ui.wizards.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.callbacks.ICallback0;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DjangoSettingsPage
extends WizardPage {
    public static final String CPYTHON = "cpython";
    public static final String JYTHON = "jython";
    static final ArrayList<String> DJANGO_VERSIONS = new ArrayList<String>(){
        {
            this.add("1.2 or later");
            this.add("1.1");
            this.add("1.0");
            this.add("pre-1.0");
        }
    };
    static final Map<String, List<String>> DB_ENGINES = new HashMap<String, List<String>>(){
        {
            this.put(DjangoSettingsPage.CPYTHON, new ArrayList<String>(){
                {
                    this.add("sqlite3");
                    this.add("postgresql_psycopg2");
                    this.add("mysql");
                    this.add("oracle");
                    this.add("other (just type in combo)");
                }
            });
            this.put(DjangoSettingsPage.JYTHON, new ArrayList<String>(){
                {
                    this.add("doj.backends.zxjdbc.sqlite3");
                    this.add("doj.backends.zxjdbc.postgresql");
                    this.add("doj.backends.zxjdbc.mysql");
                    this.add("doj.backends.zxjdbc.oracle");
                    this.add("other (just type in combo)");
                }
            });
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private Combo djVersionCombo;
    private Combo engineCombo;
    private Text nameText;
    private Text hostText;
    private Text portText;
    private Text userText;
    private Text passText;
    private ICallback0<IWizardNewProjectNameAndLocationPage> projectPageCallback;
    private String previousProjectType = "";

    public DjangoSettingsPage(String pageName, ICallback0<IWizardNewProjectNameAndLocationPage> projectPage) {
        super(pageName);
        this.projectPageCallback = projectPage;
        this.setTitle("Django Settings");
        this.setDescription("Basic Django Settings");
    }

    private Label newLabel(Composite parent, String label) {
        Label l = new Label(parent, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(768));
        return l;
    }

    private Text newText(Composite parent) {
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 250;
        t.setLayoutData((Object)gd);
        return t;
    }

    public void setPreviousPage(IWizardPage page) {
        String projectType;
        super.setPreviousPage(page);
        IWizardNewProjectNameAndLocationPage projectPage = (IWizardNewProjectNameAndLocationPage)this.projectPageCallback.call();
        if (this.djVersionCombo.getItemCount() == 0) {
            this.djVersionCombo.removeAll();
            for (String version : DJANGO_VERSIONS) {
                this.djVersionCombo.add(version);
            }
            this.djVersionCombo.setText(DJANGO_VERSIONS.get(0));
        }
        if (!(projectType = projectPage.getProjectType()).equals(this.previousProjectType)) {
            this.previousProjectType = projectType;
            List<String> engines = DB_ENGINES.get(projectType.startsWith(JYTHON) ? JYTHON : CPYTHON);
            this.engineCombo.removeAll();
            for (String engine : engines) {
                this.engineCombo.add(engine);
            }
            this.engineCombo.setText(engines.get(0));
        }
        this.updateSqlitePathIfNeeded(projectPage);
    }

    public void createControl(Composite parent) {
        Composite topComp = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 1;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        topComp.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        topComp.setLayoutData((Object)gd);
        Group general_grp = new Group(topComp, 0);
        general_grp.setText("General");
        GridLayout general_layout = new GridLayout();
        general_layout.horizontalSpacing = 8;
        general_layout.numColumns = 2;
        general_grp.setLayout((Layout)general_layout);
        gd = new GridData(768);
        general_grp.setLayoutData((Object)gd);
        this.newLabel((Composite)general_grp, "Django version");
        this.djVersionCombo = new Combo((Composite)general_grp, 0);
        gd = new GridData(768);
        this.djVersionCombo.setLayoutData((Object)gd);
        Group group = new Group(topComp, 0);
        group.setText("Database settings");
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        group.setLayoutData((Object)gd);
        this.newLabel((Composite)group, "Database &Engine");
        this.engineCombo = new Combo((Composite)group, 0);
        final IWizardNewProjectNameAndLocationPage projectPage = (IWizardNewProjectNameAndLocationPage)this.projectPageCallback.call();
        this.engineCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DjangoSettingsPage.this.updateSqlitePathIfNeeded(projectPage);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        this.engineCombo.setLayoutData((Object)gd);
        this.newLabel((Composite)group, "Database &Name");
        this.nameText = this.newText((Composite)group);
        this.newLabel((Composite)group, "Database &Host");
        this.hostText = this.newText((Composite)group);
        this.newLabel((Composite)group, "Database P&ort");
        this.portText = this.newText((Composite)group);
        this.newLabel((Composite)group, "&Username");
        this.userText = this.newText((Composite)group);
        this.newLabel((Composite)group, "&Password");
        this.passText = this.newText((Composite)group);
        this.passText.setEchoChar('*');
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topComp);
    }

    public DjangoSettings getSettings() {
        DjangoSettings s = new DjangoSettings();
        s.djangoVersion = this.escapeSlashes(this.djVersionCombo.getText());
        s.databaseEngine = this.escapeSlashes(this.engineCombo.getText());
        s.databaseName = this.escapeSlashes(this.nameText.getText());
        s.databaseHost = this.escapeSlashes(this.hostText.getText());
        s.databasePort = this.escapeSlashes(this.portText.getText());
        s.databaseUser = this.escapeSlashes(this.userText.getText());
        s.databasePassword = this.escapeSlashes(this.passText.getText());
        return s;
    }

    public void updateSqlitePathIfNeeded(IWizardNewProjectNameAndLocationPage projectPage) {
        String selection = this.engineCombo.getText();
        if (selection.endsWith("sqlite3")) {
            String projectName = projectPage.getProjectName();
            IPath base = projectPage.getLocationPath().append(projectName);
            int sourceFolderConfigurationStyle = projectPage.getSourceFolderConfigurationStyle();
            switch (sourceFolderConfigurationStyle) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    base = base.append("src");
                }
            }
            this.nameText.setText(base.append("sqlite.db").toOSString());
        }
    }

    private String escapeSlashes(String text) {
        return StringUtils.replaceAll((String)text, (String)"\\", (String)"\\\\\\\\");
    }

    public static class DjangoSettings {
        public String djangoVersion;
        public String databaseEngine;
        public String databaseName;
        public String databaseHost;
        public String databasePort;
        public String databaseUser;
        public String databasePassword;
    }
}

