/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.concurrency;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.log.Log;

public class SingleJobRunningPool {
    private static Object jobsLock = new Object();
    private List<Job> runningJobs = new ArrayList<Job>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(Job job) {
        Object object = jobsLock;
        synchronized (object) {
            this.runningJobs.add(job);
            if (this.runningJobs.size() == 1) {
                job.schedule(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJob(Job job) {
        Object object = jobsLock;
        synchronized (object) {
            if (this.runningJobs.size() == 0) {
                Log.log("Something bad happened: trying to remove a job when no running job is available!! This should never happen.");
                return;
            }
            Job removed = this.runningJobs.remove(0);
            if (removed != job) {
                Log.log("Something bad happened: the removed one should always be in position 0!!! This should never happen.");
                this.runningJobs.clear();
                return;
            }
            if (this.runningJobs.size() > 0) {
                this.runningJobs.get(0).schedule(100L);
            }
        }
    }
}

