/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.tooltips.presenter;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.core.tooltips.presenter.IInformationPresenterAsTooltip;
import org.python.pydev.core.tooltips.presenter.IInformationPresenterControlManager;

public abstract class AbstractInformationPresenter
implements DefaultInformationControl.IInformationPresenter,
DefaultInformationControl.IInformationPresenterExtension,
IInformationPresenterAsTooltip {
    public static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    protected IInformationPresenterControlManager informationPresenterControlManager;
    protected Object data;

    public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
        return this.updatePresentation((Drawable)display, hoverInfo, presentation, maxWidth, maxHeight);
    }

    protected String correctLineDelimiters(String str) {
        FastStringBuffer buf = new FastStringBuffer();
        for (String s : StringUtils.splitInLines(str)) {
            boolean found = false;
            while (s.endsWith("\r") || s.endsWith("\n")) {
                found = true;
                s = s.substring(0, s.length() - 1);
            }
            buf.append(s);
            if (!found) continue;
            buf.append(LINE_DELIM);
        }
        str = buf.toString();
        return str;
    }

    public void setInformationPresenterControlManager(IInformationPresenterControlManager informationPresenterControlManager) {
        this.informationPresenterControlManager = informationPresenterControlManager;
    }

    public void hideInformationControl(boolean activateEditor, boolean restoreFocus) {
        if (this.informationPresenterControlManager != null) {
            this.informationPresenterControlManager.hideInformationControl(activateEditor, restoreFocus);
        }
    }

    public void setData(Object data) {
        this.data = data;
    }
}

