/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.__builtin__;

public class struct {
    public static PyString error = new PyString("struct.error");
    public static String __doc__ = "Functions to convert between Python values and C structs.\nPython strings are used to hold the data representing the C\nstruct and also as format strings to describe the layout of\ndata in the C struct.\n\nThe optional first format char indicates byte ordering and\nalignment:\n @: native w/native alignment(default)\n =: native w/standard alignment\n <: little-endian, std. alignment\n >: big-endian, std. alignment\n !: network, std (same as >)\n\nThe remaining chars indicate types of args and must match\nexactly; these can be preceded by a decimal repeat count:\n x: pad byte (no data); c:char; b:signed byte; B:unsigned byte;\n h:short; H:unsigned short; i:int; I:unsigned int;\n l:long; L:unsigned long; f:float; d:double.\nSpecial cases (preceding decimal count indicates length):\n s:string (array of char); p: pascal string (w. count byte).\nWhitespace between formats is ignored.\n\nThe variable struct.error is an exception raised on errors.";
    private static FormatDef[] lilendian_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new LEShortFormatDef().init('h', 2, 0), new LEUnsignedShortFormatDef().init('H', 2, 0), new LEIntFormatDef().init('i', 4, 0), new LEUnsignedIntFormatDef().init('I', 4, 0), new LEIntFormatDef().init('l', 4, 0), new LEUnsignedIntFormatDef().init('L', 4, 0), new LEFloatFormatDef().init('f', 4, 0), new LEDoubleFormatDef().init('d', 8, 0)};
    private static FormatDef[] bigendian_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new BEShortFormatDef().init('h', 2, 0), new BEUnsignedShortFormatDef().init('H', 2, 0), new BEIntFormatDef().init('i', 4, 0), new BEUnsignedIntFormatDef().init('I', 4, 0), new BEIntFormatDef().init('l', 4, 0), new BEUnsignedIntFormatDef().init('L', 4, 0), new BEFloatFormatDef().init('f', 4, 0), new BEDoubleFormatDef().init('d', 8, 0)};
    private static FormatDef[] native_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new BEShortFormatDef().init('h', 2, 2), new BEUnsignedShortFormatDef().init('H', 2, 2), new BEIntFormatDef().init('i', 4, 4), new BEUnsignedIntFormatDef().init('I', 4, 4), new BEIntFormatDef().init('l', 4, 4), new BEUnsignedIntFormatDef().init('L', 4, 4), new BEFloatFormatDef().init('f', 4, 4), new BEDoubleFormatDef().init('d', 8, 8)};

    private static final FormatDef[] whichtable(String pfmt) {
        char c = pfmt.charAt(0);
        switch (c) {
            case '<': {
                return lilendian_table;
            }
            case '!': 
            case '>': {
                return bigendian_table;
            }
            case '=': {
                return bigendian_table;
            }
        }
        return native_table;
    }

    private static final FormatDef getentry(char c, FormatDef[] f) {
        int i = 0;
        while (i < f.length) {
            if (f[i].name == c) {
                return f[i];
            }
            ++i;
        }
        throw struct.StructError("bad char in struct format");
    }

    private static final int align(int size, FormatDef e) {
        if (e.alignment != 0) {
            size = (size + e.alignment - 1) / e.alignment * e.alignment;
        }
        return size;
    }

    private static final int calcsize(String format, FormatDef[] f) {
        int size = 0;
        int len = format.length();
        int j = 0;
        while (j < len) {
            char c = format.charAt(j);
            if ((j != 0 || c != '@' && c != '<' && c != '>' && c != '=' && c != '!') && !Character.isWhitespace(c)) {
                int num = 1;
                if (Character.isDigit(c)) {
                    num = Character.digit(c, 10);
                    while (++j < len && Character.isDigit(c = format.charAt(j))) {
                        int x = num * 10 + Character.digit(c, 10);
                        if (x / 10 != num) {
                            throw struct.StructError("overflow in item count");
                        }
                        num = x;
                    }
                    if (j >= len) break;
                }
                FormatDef e = struct.getentry(c, f);
                int itemsize = e.size;
                size = struct.align(size, e);
                int x = num * itemsize;
                if (x / itemsize != num || (size += x) < 0) {
                    throw struct.StructError("total struct size too long");
                }
            }
            ++j;
        }
        return size;
    }

    public static int calcsize(String format) {
        FormatDef[] f = struct.whichtable(format);
        return struct.calcsize(format, f);
    }

    public static String pack(PyObject[] args) {
        if (args.length < 1) {
            Py.TypeError("illegal argument type for built-in operation");
        }
        String format = args[0].toString();
        FormatDef[] f = struct.whichtable(format);
        int size = struct.calcsize(format, f);
        ByteStream res = new ByteStream();
        int i = 1;
        int len = format.length();
        int j = 0;
        while (j < len) {
            char c = format.charAt(j);
            if ((j != 0 || c != '@' && c != '<' && c != '>' && c != '=' && c != '!') && !Character.isWhitespace(c)) {
                int num = 1;
                if (Character.isDigit(c)) {
                    num = Character.digit(c, 10);
                    while (++j < len && Character.isDigit(c = format.charAt(j))) {
                        num = num * 10 + Character.digit(c, 10);
                    }
                    if (j >= len) break;
                }
                FormatDef e = struct.getentry(c, f);
                int nres = struct.align(res.size(), e) - res.size();
                while (nres-- > 0) {
                    res.writeByte(0);
                }
                i += e.doPack(res, num, i, args);
            }
            ++j;
        }
        if (i < args.length) {
            throw struct.StructError("too many arguments for pack format");
        }
        return res.toString();
    }

    public static PyTuple unpack(String format, String string) {
        int len = string.length();
        FormatDef[] f = struct.whichtable(format);
        int size = struct.calcsize(format, f);
        if (size != len) {
            throw struct.StructError("unpack str size does not match format");
        }
        PyList res = new PyList();
        ByteStream str = new ByteStream(string);
        int flen = format.length();
        int j = 0;
        while (j < flen) {
            char c = format.charAt(j);
            if ((j != 0 || c != '@' && c != '<' && c != '>' && c != '=' && c != '!') && !Character.isWhitespace(c)) {
                int num = 1;
                if (Character.isDigit(c)) {
                    num = Character.digit(c, 10);
                    while (++j < flen && Character.isDigit(c = format.charAt(j))) {
                        num = num * 10 + Character.digit(c, 10);
                    }
                    if (j > flen) break;
                }
                FormatDef e = struct.getentry(c, f);
                str.skip(struct.align(str.size(), e) - str.size());
                e.doUnpack(str, num, res);
            }
            ++j;
        }
        return __builtin__.tuple(res);
    }

    private static final PyException StructError(String explanation) {
        return new PyException((PyObject)error, explanation);
    }

    static class FormatDef {
        char name;
        int size;
        int alignment;

        FormatDef init(char name, int size, int alignment) {
            this.name = name;
            this.size = size;
            this.alignment = alignment;
            return this;
        }

        void pack(ByteStream buf, PyObject value) {
        }

        Object unpack(ByteStream buf) {
            return null;
        }

        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            if (pos + count > args.length) {
                throw struct.StructError("insufficient arguments to pack");
            }
            int cnt = count;
            while (count-- > 0) {
                this.pack(buf, args[pos++]);
            }
            return cnt;
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            while (count-- > 0) {
                list.append(Py.java2py(this.unpack(buf)));
            }
        }

        int get_int(PyObject value) {
            try {
                return value.__int__().getValue();
            }
            catch (PyException ex) {
                throw struct.StructError("required argument is not an integer");
            }
        }

        long get_ulong(PyObject value) {
            if (value instanceof PyLong) {
                Object v = value.__tojava__(Long.TYPE);
                if (v == Py.NoConversion) {
                    throw Py.OverflowError("long int too long to convert");
                }
                return (Long)v;
            }
            return this.get_int(value);
        }

        double get_float(PyObject value) {
            if (!(value instanceof PyFloat)) {
                throw struct.StructError("required argument is not an float");
            }
            return value.__float__().getValue();
        }

        void BEwriteInt(ByteStream buf, int v) {
            buf.writeByte(v >>> 24 & 0xFF);
            buf.writeByte(v >>> 16 & 0xFF);
            buf.writeByte(v >>> 8 & 0xFF);
            buf.writeByte(v & 0xFF);
        }

        void LEwriteInt(ByteStream buf, int v) {
            buf.writeByte(v & 0xFF);
            buf.writeByte(v >>> 8 & 0xFF);
            buf.writeByte(v >>> 16 & 0xFF);
            buf.writeByte(v >>> 24 & 0xFF);
        }

        int BEreadInt(ByteStream buf) {
            int b1 = buf.readByte();
            int b2 = buf.readByte();
            int b3 = buf.readByte();
            int b4 = buf.readByte();
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
        }

        int LEreadInt(ByteStream buf) {
            int b1 = buf.readByte();
            int b2 = buf.readByte();
            int b3 = buf.readByte();
            int b4 = buf.readByte();
            return b1 + (b2 << 8) + (b3 << 16) + (b4 << 24);
        }

        FormatDef() {
        }
    }

    static class ByteStream {
        char[] data;
        int len;
        int pos;

        int readByte() {
            return this.data[this.pos++] & 0xFF;
        }

        void read(char[] buf, int pos, int len) {
            System.arraycopy(this.data, this.pos, buf, pos, len);
            this.pos += len;
        }

        String readString(int l) {
            char[] data = new char[l];
            this.read(data, 0, l);
            return new String(data);
        }

        private final void ensureCapacity(int l) {
            if (this.pos + l >= this.data.length) {
                char[] b = new char[this.data.length * 2];
                System.arraycopy(this.data, 0, b, 0, this.pos);
                this.data = b;
            }
        }

        void writeByte(int b) {
            this.ensureCapacity(1);
            this.data[this.pos++] = (char)(b & 0xFF);
        }

        void write(char[] buf, int pos, int len) {
            this.ensureCapacity(len);
            System.arraycopy(buf, pos, this.data, this.pos, len);
            this.pos += len;
        }

        void writeString(String s, int pos, int len) {
            char[] data = new char[len];
            s.getChars(pos, len, data, 0);
            this.write(data, 0, len);
        }

        int skip(int l) {
            this.pos += l;
            return this.pos;
        }

        int size() {
            return this.pos;
        }

        public String toString() {
            return new String(this.data, 0, this.pos);
        }

        ByteStream() {
            this.data = new char[10];
            this.len = 0;
            this.pos = 0;
        }

        ByteStream(String s) {
            int l = s.length();
            this.data = new char[l];
            s.getChars(0, l, this.data, 0);
            this.len = l;
            this.pos = 0;
        }
    }

    static class PadFormatDef
    extends FormatDef {
        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            while (count-- > 0) {
                buf.writeByte(0);
            }
            return 0;
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            while (count-- > 0) {
                buf.readByte();
            }
        }

        PadFormatDef() {
        }
    }

    static class StringFormatDef
    extends FormatDef {
        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            PyObject value = args[pos];
            if (!(value instanceof PyString)) {
                throw struct.StructError("argument for 's' must be a string");
            }
            String s = value.toString();
            int len = s.length();
            buf.writeString(s, 0, Math.min(count, len));
            if (len < count) {
                count -= len;
                int i = 0;
                while (i < count) {
                    buf.writeByte(0);
                    ++i;
                }
            }
            return 1;
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            list.append(Py.newString(buf.readString(count)));
        }

        StringFormatDef() {
        }
    }

    static class PascalStringFormatDef
    extends StringFormatDef {
        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            PyObject value = args[pos];
            if (!(value instanceof PyString)) {
                throw struct.StructError("argument for 'p' must be a string");
            }
            buf.writeByte(Math.min(value.toString().length(), count - 1));
            return super.doPack(buf, count - 1, pos, args);
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            int n = buf.readByte();
            if (n >= count) {
                n = count - 1;
            }
            super.doUnpack(buf, n, list);
            buf.skip(Math.max(count - n - 1, 0));
        }

        PascalStringFormatDef() {
        }
    }

    static class CharFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            if (!(value instanceof PyString) || value.__len__() != 1) {
                throw struct.StructError("char format require string of length 1");
            }
            buf.writeByte(value.toString().charAt(0));
        }

        Object unpack(ByteStream buf) {
            return Py.newString((char)buf.readByte());
        }

        CharFormatDef() {
        }
    }

    static class ByteFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            buf.writeByte(this.get_int(value));
        }

        Object unpack(ByteStream buf) {
            int b = buf.readByte();
            if (b > 127) {
                b -= 256;
            }
            return Py.newInteger(b);
        }

        ByteFormatDef() {
        }
    }

    static class UnsignedByteFormatDef
    extends ByteFormatDef {
        Object unpack(ByteStream buf) {
            return Py.newInteger(buf.readByte());
        }

        UnsignedByteFormatDef() {
        }
    }

    static class LEShortFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            int v = this.get_int(value);
            buf.writeByte(v & 0xFF);
            buf.writeByte(v >> 8 & 0xFF);
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() | buf.readByte() << 8;
            if (v > Short.MAX_VALUE) {
                v -= 65536;
            }
            return Py.newInteger(v);
        }

        LEShortFormatDef() {
        }
    }

    static class LEUnsignedShortFormatDef
    extends LEShortFormatDef {
        Object unpack(ByteStream buf) {
            int v = buf.readByte() | buf.readByte() << 8;
            return Py.newInteger(v);
        }

        LEUnsignedShortFormatDef() {
        }
    }

    static class BEShortFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            int v = this.get_int(value);
            buf.writeByte(v >> 8 & 0xFF);
            buf.writeByte(v & 0xFF);
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() << 8 | buf.readByte();
            if (v > Short.MAX_VALUE) {
                v -= 65536;
            }
            return Py.newInteger(v);
        }

        BEShortFormatDef() {
        }
    }

    static class BEUnsignedShortFormatDef
    extends BEShortFormatDef {
        Object unpack(ByteStream buf) {
            int v = buf.readByte() << 8 | buf.readByte();
            return Py.newInteger(v);
        }

        BEUnsignedShortFormatDef() {
        }
    }

    static class LEIntFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            this.LEwriteInt(buf, this.get_int(value));
        }

        Object unpack(ByteStream buf) {
            int v = this.LEreadInt(buf);
            return Py.newInteger(v);
        }

        LEIntFormatDef() {
        }
    }

    static class LEUnsignedIntFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            this.LEwriteInt(buf, (int)(this.get_ulong(value) & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream buf) {
            long v = this.LEreadInt(buf);
            if (v < 0L) {
                v += 0x100000000L;
            }
            return new PyLong(v);
        }

        LEUnsignedIntFormatDef() {
        }
    }

    static class BEIntFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            this.BEwriteInt(buf, this.get_int(value));
        }

        Object unpack(ByteStream buf) {
            return Py.newInteger(this.BEreadInt(buf));
        }

        BEIntFormatDef() {
        }
    }

    static class BEUnsignedIntFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            this.BEwriteInt(buf, (int)(this.get_ulong(value) & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream buf) {
            long v = this.BEreadInt(buf);
            if (v < 0L) {
                v += 0x100000000L;
            }
            return new PyLong(v);
        }

        BEUnsignedIntFormatDef() {
        }
    }

    static class LEFloatFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            int bits = Float.floatToIntBits((float)this.get_float(value));
            this.LEwriteInt(buf, bits);
        }

        Object unpack(ByteStream buf) {
            int v = this.LEreadInt(buf);
            return Py.newFloat(Float.intBitsToFloat(v));
        }

        LEFloatFormatDef() {
        }
    }

    static class LEDoubleFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            long bits = Double.doubleToLongBits(this.get_float(value));
            this.LEwriteInt(buf, (int)(bits & 0xFFFFFFFFFFFFFFFFL));
            this.LEwriteInt(buf, (int)(bits >>> 32));
        }

        Object unpack(ByteStream buf) {
            long bits = ((long)this.LEreadInt(buf) & 0xFFFFFFFFL) + ((long)this.LEreadInt(buf) << 32);
            return Py.newFloat(Double.longBitsToDouble(bits));
        }

        LEDoubleFormatDef() {
        }
    }

    static class BEFloatFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            int bits = Float.floatToIntBits((float)this.get_float(value));
            this.BEwriteInt(buf, bits);
        }

        Object unpack(ByteStream buf) {
            int v = this.BEreadInt(buf);
            return Py.newFloat(Float.intBitsToFloat(v));
        }

        BEFloatFormatDef() {
        }
    }

    static class BEDoubleFormatDef
    extends FormatDef {
        void pack(ByteStream buf, PyObject value) {
            long bits = Double.doubleToLongBits(this.get_float(value));
            this.BEwriteInt(buf, (int)(bits >>> 32));
            this.BEwriteInt(buf, (int)(bits & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream buf) {
            long bits = ((long)this.BEreadInt(buf) << 32) + ((long)this.BEreadInt(buf) & 0xFFFFFFFFL);
            return Py.newFloat(Double.longBitsToDouble(bits));
        }

        BEDoubleFormatDef() {
        }
    }
}

