/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import name.pachler.nio.file.ClosedWatchServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CloseableBlockingQueue<T>
implements BlockingQueue<T> {
    Queue<T> q = new LinkedList<T>();

    CloseableBlockingQueue() {
    }

    @Override
    public synchronized boolean add(T e) {
        try {
            this.put(e);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CloseableBlockingQueue.class.getName()).log(Level.SEVERE, null, ex);
        }
        return true;
    }

    @Override
    public synchronized int drainTo(Collection<? super T> clctn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized int drainTo(Collection<? super T> clctn, int maxNumElements) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized boolean offer(T e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized boolean offer(T e, long l, TimeUnit tu) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized T poll(long l, TimeUnit tu) throws InterruptedException {
        if (this.q == null) {
            throw new ClosedWatchServiceException();
        }
        T e = this.q.poll();
        if (e == null) {
            if (tu == null) {
                this.wait();
            } else {
                this.wait(TimeUnit.MILLISECONDS.convert(l, tu));
            }
            if (this.q == null) {
                throw new ClosedWatchServiceException();
            }
            e = this.q.poll();
        }
        return e;
    }

    @Override
    public synchronized void put(T e) throws InterruptedException {
        if (this.q == null) {
            throw new ClosedWatchServiceException();
        }
        boolean success = this.q.add(e);
        assert (success);
        if (success) {
            this.notify();
        }
    }

    @Override
    public synchronized int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public synchronized T take() throws InterruptedException {
        return this.poll(-1L, null);
    }

    public synchronized void close() {
        this.q = null;
        this.notifyAll();
    }

    @Override
    public synchronized T poll() {
        if (this.q == null) {
            throw new ClosedWatchServiceException();
        }
        return this.q.poll();
    }

    @Override
    public synchronized T remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized T peek() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized T element() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized int size() {
        return this.q.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized boolean contains(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized Iterator<T> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized Object[] toArray() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized <T> T[] toArray(T[] ts) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized boolean containsAll(Collection<?> clctn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> clctn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized boolean removeAll(Collection<?> clctn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized boolean retainAll(Collection<?> clctn) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public synchronized void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

