/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.env;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.NotConfiguredInterpreterException;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.newconsole.env.JythonEclipseInterpreterManager;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChooseProcessTypeDialog
extends Dialog {
    private Button checkboxForCurrentEditor;
    private Button checkboxPython;
    private Button checkboxJython;
    private Button checkboxIronpython;
    private Button checkboxJythonEclipse;
    private PyEdit activeEditor;
    private IInterpreterManager interpreterManager;
    private List<IPythonNature> natures = new ArrayList<IPythonNature>();

    ChooseProcessTypeDialog(Shell shell, PyEdit activeEditor) {
        super(shell);
        this.activeEditor = activeEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.checkboxForCurrentEditor = new Button(area, 16);
        this.checkboxForCurrentEditor.setToolTipText("Creates a console with the PYTHONPATH used by the current editor (and jython/python/iron python depending on the project type).");
        this.configureEditorButton();
        this.checkboxPython = new Button(area, 16);
        this.checkboxPython.setToolTipText("Creates a Python console with the PYTHONPATH containing all the python projects in the workspace.");
        this.configureButton(this.checkboxPython, "Python", PydevPlugin.getPythonInterpreterManager());
        this.checkboxJython = new Button(area, 16);
        this.checkboxJython.setToolTipText("Creates a Jython console with the PYTHONPATH containing all the python projects in the workspace.");
        this.configureButton(this.checkboxJython, "Jython", PydevPlugin.getJythonInterpreterManager());
        this.checkboxIronpython = new Button(area, 16);
        this.checkboxIronpython.setToolTipText("Creates an Iron Python console with the PYTHONPATH containing all the python projects in the workspace.");
        this.configureButton(this.checkboxIronpython, "Iron Python", PydevPlugin.getIronpythonInterpreterManager());
        this.checkboxJythonEclipse = new Button(area, 16);
        this.checkboxJythonEclipse.setToolTipText("Creates a Jython console using the running Eclipse environment (can potentially halt Eclipse depending on what's done).");
        this.configureButton(this.checkboxJythonEclipse, "Jython using VM running Eclipse", new JythonEclipseInterpreterManager());
        return area;
    }

    private void configureButton(Button checkBox, String python, IInterpreterManager interpreterManager) {
        String text;
        boolean enabled = false;
        try {
            if (interpreterManager.getDefaultInterpreterInfo(false) == null) {
                throw new NotConfiguredInterpreterException();
            }
            text = String.valueOf(python) + " console";
            enabled = true;
        }
        catch (MisconfigurationException misconfigurationException) {
            text = "Unable to create console for " + python + " (interpreter not configured)";
        }
        checkBox.setText(text);
        checkBox.setEnabled(enabled);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void configureEditorButton() {
        String text;
        boolean enabled = false;
        try {
            if (this.activeEditor != null) {
                IPythonNature nature = this.activeEditor.getPythonNature();
                if (nature != null) {
                    if (nature.getRelatedInterpreterManager().getDefaultInterpreterInfo(false) == null) throw new NotConfiguredInterpreterException();
                    text = "Console for currently active editor";
                    enabled = true;
                } else {
                    text = "No python nature configured for the current editor";
                }
            } else {
                text = "Unable to create console for current editor (no active editor)";
            }
        }
        catch (MisconfigurationException misconfigurationException) {
            text = "Unable to create console for current editor (interpreter not configured for the editor)";
        }
        this.checkboxForCurrentEditor.setText(text);
        this.checkboxForCurrentEditor.setEnabled(enabled);
    }

    protected void okPressed() {
        if (this.checkboxForCurrentEditor.isEnabled() && this.checkboxForCurrentEditor.getSelection()) {
            IInterpreterManager relatedInterpreterManager;
            IProject project = this.activeEditor.getProject();
            PythonNature nature = PythonNature.getPythonNature((IProject)project);
            this.natures.add((IPythonNature)nature);
            this.interpreterManager = relatedInterpreterManager = nature.getRelatedInterpreterManager();
        } else if (this.checkboxPython.isEnabled() && this.checkboxPython.getSelection()) {
            this.interpreterManager = PydevPlugin.getPythonInterpreterManager();
        } else if (this.checkboxJython.isEnabled() && this.checkboxJython.getSelection()) {
            this.interpreterManager = PydevPlugin.getJythonInterpreterManager();
        } else if (this.checkboxJythonEclipse.isEnabled() && this.checkboxJythonEclipse.getSelection()) {
            this.interpreterManager = new JythonEclipseInterpreterManager();
        } else if (this.checkboxIronpython.isEnabled() && this.checkboxIronpython.getSelection()) {
            this.interpreterManager = PydevPlugin.getIronpythonInterpreterManager();
        }
        super.okPressed();
    }

    public Tuple<Collection<String>, IPythonNature> getPythonpathAndNature(IInterpreterInfo interpreter) {
        if (this.interpreterManager != null) {
            if (this.natures.size() == 1) {
                IPythonNature nature = this.natures.get(0);
                return new Tuple(new ArrayList(nature.getPythonPathNature().getCompleteProjectPythonPath(interpreter, this.interpreterManager)), (Object)nature);
            }
            IWorkspace w = ResourcesPlugin.getWorkspace();
            HashSet pythonpath = new HashSet();
            IProject[] iProjectArray = w.getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                PythonNature nature = PythonNature.getPythonNature((IProject)p);
                try {
                    if (nature != null && nature.getRelatedInterpreterManager() == this.interpreterManager) {
                        this.natures.add((IPythonNature)nature);
                        List completeProjectPythonPath = nature.getPythonPathNature().getCompleteProjectPythonPath(interpreter, this.interpreterManager);
                        if (completeProjectPythonPath != null) {
                            pythonpath.addAll(completeProjectPythonPath);
                        } else {
                            Log.logInfo((String)("Unable to get pythonpath for project: " + nature.getProject() + " (initialization not finished)."));
                        }
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                ++n2;
            }
            return new Tuple(pythonpath, null);
        }
        return null;
    }

    public IInterpreterManager getInterpreterManager() {
        return this.interpreterManager;
    }

    public List<IPythonNature> getNatures() {
        return this.natures;
    }
}

