/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import org.eclipse.core.expressions.PropertyTester;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;

public class InterpreterTypeTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IInterpreterManager interpreterManager = null;
        String str = expectedValue.toString();
        if ("python".equals(str)) {
            interpreterManager = PydevPlugin.getPythonInterpreterManager();
        } else if ("jython".equals(str)) {
            interpreterManager = PydevPlugin.getJythonInterpreterManager();
        } else if ("ironpython".equals(str)) {
            interpreterManager = PydevPlugin.getIronpythonInterpreterManager();
        } else {
            Log.log((String)("Unable to check for: " + expectedValue));
        }
        if (interpreterManager != null) {
            try {
                String defaultInterpreter = interpreterManager.getDefaultInterpreterInfo(false).getExecutableOrJar();
                return defaultInterpreter != null;
            }
            catch (MisconfigurationException misconfigurationException) {
                return false;
            }
        }
        return false;
    }
}

