/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.math.BigInteger;
import java.util.List;
import org.python.pydev.parser.IGrammar;
import org.python.pydev.parser.grammarcommon.AbstractGrammarErrorHandlers;
import org.python.pydev.parser.grammarcommon.AbstractTokenManager;
import org.python.pydev.parser.grammarcommon.ITreeConstants;
import org.python.pydev.parser.grammarcommon.TokensIterator;
import org.python.pydev.parser.grammarcommon.WithNameInvalidException;
import org.python.pydev.parser.jython.FastCharStream;
import org.python.pydev.parser.jython.ISpecialStr;
import org.python.pydev.parser.jython.Node;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.commentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPythonGrammar
extends AbstractGrammarErrorHandlers
implements ITreeConstants,
IGrammar {
    public SimpleNode prev;
    public static final boolean DEFAULT_SEARCH_ON_LAST = false;
    protected Object temporaryToken;
    protected static WithNameInvalidException withNameInvalidException = new WithNameInvalidException("With cannot be used as identifier when future with_statement is available.");
    private ISpecialStr lastSpecial;
    private SimpleNode lastNodeWithSpecial;
    public static final int STRATEGY_ADD_AFTER_PREV = 0;
    public static final int STRATEGY_BEFORE_NEXT = 1;

    public abstract Token getToken(int var1);

    public abstract List<Object> getTokenSourceSpecialTokensList();

    protected abstract Token getJJLastPos();

    protected final void addToPeek(Object t, boolean after) throws ParseException {
        this.addToPeek(t, after, null);
    }

    protected final void addToPeekCallFunc(Object t, boolean after) {
        Call n = (Call)this.getJJTree().peekNode();
        this.addSpecial(n.func, t, after);
    }

    public final void addSpecialTokenToLastOpened(Object o) throws ParseException {
        if ((o = this.convertStringToSpecialStr(o)) != null) {
            SimpleNode lastOpened = this.getJJTree().getLastOpened();
            if (o instanceof ISpecialStr) {
                this.lastSpecial = (ISpecialStr)o;
                this.lastNodeWithSpecial = lastOpened;
            }
            lastOpened.getSpecialsBefore().add(o);
        }
    }

    private void addSpecial(SimpleNode node, Object special, boolean after) {
        if (special instanceof Token) {
            Token t = (Token)special;
            if (t.toString().trim().startsWith("#")) {
                commentType comment = new commentType(t.image.trim());
                comment.beginColumn = t.beginColumn;
                comment.beginLine = t.beginLine;
                special = comment;
                if (node.beginLine != comment.beginLine && this.lastSpecial != null && this.lastNodeWithSpecial != null && (comment.beginLine < this.lastSpecial.getBeginLine() || comment.beginLine == this.lastSpecial.getBeginLine() && comment.beginColumn < this.lastSpecial.getBeginCol())) {
                    List<Object> specialsBefore = this.lastNodeWithSpecial.getSpecialsBefore();
                    specialsBefore.add(specialsBefore.indexOf(this.lastSpecial), comment);
                    return;
                }
            } else {
                special = t.asSpecialStr();
            }
        }
        node.addSpecial(special, after);
    }

    protected final void addToPeek(Object t, boolean after, Class class_) throws ParseException {
        SimpleNode peeked = this.getJJTree().peekNode();
        this.addToPeek(peeked, t, after, class_);
    }

    protected final void addToPeek(SimpleNode peeked, Object t, boolean after, Class class_) throws ParseException {
        if (class_ != null && !peeked.getClass().equals(class_)) {
            throw new RuntimeException("Error, expecting class:" + class_ + " received class:" + peeked.getClass() + " Representation:" + peeked);
        }
        if ((t = this.convertStringToSpecialStr(t)) != null) {
            this.addSpecial(peeked, t, after);
        }
    }

    protected final void jjtreeOpenNodeScope(Node n) {
    }

    protected final void jjtreeCloseNodeScope(Node n) throws ParseException {
        SimpleNode peeked = this.getJJTree().peekNode();
        List<Object> specialTokens = this.getTokenSourceSpecialTokensList();
        boolean after = true;
        if (n instanceof SimpleNode) {
            if (specialTokens.size() > 0) {
                if (this.prev == null) {
                    after = false;
                    this.prev = peeked;
                }
                for (Object next : specialTokens) {
                    int strategy = 0;
                    if (next instanceof Object[]) {
                        strategy = (Integer)((Object[])next)[1];
                        next = ((Object[])next)[0];
                    }
                    if (strategy == 1) {
                        this.addToPeek(peeked, next, false, null);
                        continue;
                    }
                    if (next instanceof Token) {
                        this.addSpecial(this.findTokenToAdd((Token)next), next, after);
                        continue;
                    }
                    this.addSpecial(this.prev, next, after);
                }
                specialTokens.clear();
            }
            this.prev = peeked;
        }
    }

    private final SimpleNode findTokenToAdd(Token next) {
        SimpleNode curr = this.getJJTree().peekNode();
        if (curr != this.prev) {
            if (this.prev.beginLine == next.beginLine) {
                return this.prev;
            }
            if (curr.beginLine == next.beginLine) {
                return curr;
            }
            if (next.beginLine > this.prev.beginLine && next.beginLine > curr.beginLine) {
                return curr;
            }
        }
        return this.prev;
    }

    public final void addSpecialToken(Object o, int strategy) throws ParseException {
        ISpecialStr t = this.convertStringToSpecialStr(o);
        if (t != null) {
            this.getTokenSourceSpecialTokensList().add(new Object[]{t, strategy});
        }
    }

    private final ISpecialStr convertStringToSpecialStr(Object o) throws ParseException {
        if (o instanceof ISpecialStr) {
            return (ISpecialStr)o;
        }
        if (o instanceof Token) {
            return ((Token)o).asSpecialStr();
        }
        return this.createSpecialStr(((String)o).trim(), false, false);
    }

    public final void addSpecialToken(Object o) throws ParseException {
        if (!(o instanceof ISpecialStr)) {
            o = this.convertStringToSpecialStr(o);
        }
        this.getTokenSourceSpecialTokensList().add(new Object[]{o, 0});
    }

    public final ISpecialStr createSpecialStr(String token) throws ParseException {
        return this.createSpecialStr(token, false);
    }

    public final ISpecialStr createSpecialStr(String token, boolean searchOnLast) throws ParseException {
        return this.createSpecialStr(token, searchOnLast, true);
    }

    public final ISpecialStr createSpecialStr(String token, boolean searchOnLast, boolean throwException) throws ParseException {
        Token currentToken = this.getCurrentToken();
        Token firstTokenToIterate = searchOnLast ? this.getJJLastPos() : currentToken;
        Token foundToken = null;
        int foundAtPos = 0;
        TokensIterator iterTokens = this.getTokensIterator(firstTokenToIterate, 50, true);
        while (iterTokens.hasNext()) {
            ++foundAtPos;
            Token next = iterTokens.next();
            if (next.image == null || !next.image.equals(token)) continue;
            foundToken = next;
            break;
        }
        if (foundToken != null && (foundAtPos <= 2 || searchOnLast)) {
            return foundToken.asSpecialStr();
        }
        if (throwException) {
            ParseException e = this.createException(token, currentToken);
            if (foundToken != null) {
                this.addAndReport(e, "Found at wrong position: " + foundToken);
                Token beforeLastReturned = iterTokens.getBeforeLastReturned();
                this.setCurrentToken(beforeLastReturned);
                return foundToken.asSpecialStr();
            }
            if (currentToken != null) {
                AbstractTokenManager tokenManager = this.getTokenManager();
                FastCharStream inputStream = tokenManager.getInputStream();
                int created = tokenManager.addCustom(currentToken, token);
                if (created != AbstractTokenManager.CUSTOM_NOT_CREATED) {
                    if (created == AbstractTokenManager.CUSTOM_CREATED_WAS_PARENS) {
                        currentToken.next.next = null;
                        if (tokenManager.levelBeforeEof != -1) {
                            tokenManager.level = tokenManager.levelBeforeEof;
                            tokenManager.levelBeforeEof = -1;
                        }
                        inputStream.restoreLineColPos(currentToken.endLine, currentToken.endColumn);
                    }
                    this.addAndReport(e, "Created custom token: " + token);
                    return new SpecialStr(token, currentToken.beginLine, currentToken.beginColumn);
                }
            }
            throw e;
        }
        return null;
    }

    private ParseException createException(String token, Token currentToken) {
        ParseException e = currentToken != null ? new ParseException("Expected:" + token, currentToken) : (this.getJJLastPos() != null ? new ParseException("Expected:" + token, this.getJJLastPos()) : new ParseException("Expected:" + token));
        return e;
    }

    public final boolean findTokenAndAdd(String token) throws ParseException {
        return this.findTokenAndAdd(token, false);
    }

    public final boolean findTokenAndAdd(String token, boolean searchOnLast) throws ParseException {
        ISpecialStr s = this.createSpecialStr(token, searchOnLast);
        this.getTokenSourceSpecialTokensList().add(new Object[]{s, 0});
        return s instanceof ISpecialStr;
    }

    protected final void makeInt(String s, int radix, Token token, Num numberToFill) throws ParseException {
        long l;
        numberToFill.num = token.image;
        if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
            numberToFill.n = new BigInteger(s, radix);
            numberToFill.type = 2;
            return;
        }
        int ndigits = s.length();
        int i = 0;
        while (i < ndigits && s.charAt(i) == '0') {
            ++i;
        }
        if (ndigits - i > 11) {
            numberToFill.n = new BigInteger(s, radix);
            numberToFill.type = 2;
            return;
        }
        try {
            l = Long.valueOf(s, radix);
        }
        catch (NumberFormatException e) {
            this.handleNumberFormatException(token, e);
            l = 0L;
        }
        if (l > 0xFFFFFFFFL || radix == 10 && l > Integer.MAX_VALUE) {
            numberToFill.n = new BigInteger(s, radix);
            numberToFill.type = 2;
            return;
        }
        numberToFill.n = (int)l;
        numberToFill.type = 1;
    }

    protected final void makeFloat(Token t, Num numberToFill) throws ParseException {
        String s;
        numberToFill.num = s = t.image;
        try {
            numberToFill.n = Float.valueOf(s);
        }
        catch (NumberFormatException e) {
            this.handleNumberFormatException(t, e);
        }
        numberToFill.type = 3;
    }

    private void handleNumberFormatException(Token t, NumberFormatException e) throws ParseException {
        this.addAndReport(new ParseException("Unable to parse number: " + t.image, t), e.getMessage());
    }

    protected final void makeLong(Token t, Num numberToFill) throws ParseException {
        String s;
        numberToFill.num = s = t.image;
        try {
            numberToFill.n = Long.valueOf(s);
        }
        catch (NumberFormatException e) {
            this.handleNumberFormatException(t, e);
        }
        numberToFill.type = 2;
    }

    protected final void makeComplex(Token t, Num numberToFill) throws ParseException {
        String s = t.image;
        String compNumber = s.substring(0, s.length() - 1);
        numberToFill.num = s;
        try {
            numberToFill.n = Double.valueOf(compNumber);
        }
        catch (NumberFormatException e) {
            this.handleNumberFormatException(t, e);
        }
        numberToFill.type = 6;
    }

    protected final void makeString(String s, int quotes, Str strToFill) {
        char quoteChar = s.charAt(0);
        int start = 0;
        boolean ustring = false;
        boolean bstring = false;
        if (quoteChar == 'u' || quoteChar == 'U') {
            ustring = true;
            ++start;
        } else if (quoteChar == 'b' || quoteChar == 'B') {
            bstring = true;
            ++start;
        }
        quoteChar = s.charAt(start);
        if (quoteChar == 'r' || quoteChar == 'R') {
            String str = s.substring(quotes + start + 1, s.length() - quotes);
            strToFill.type = this.getType(s.charAt(start + 1), quotes);
            strToFill.s = str;
            strToFill.unicode = ustring;
            strToFill.raw = true;
            strToFill.binary = bstring;
        } else {
            int n = s.length() - quotes;
            int i = quotes + start;
            String str = s.substring(i, n);
            strToFill.type = this.getType(s.charAt(start), quotes);
            strToFill.s = str;
            strToFill.unicode = ustring;
            strToFill.raw = false;
            strToFill.binary = bstring;
        }
    }

    private final int getType(char c, int quotes) {
        switch (c) {
            case '\'': {
                return quotes == 1 ? 3 : 1;
            }
            case '\"': {
                return quotes == 1 ? 4 : 2;
            }
        }
        throw new RuntimeException("Unable to determine type. Char: " + c + " quotes:" + quotes);
    }
}

