/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.visitors.info;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.refactoring.ast.FQIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportVisitor
extends VisitorBase {
    private SortedMap<String, String> importedModules = new TreeMap<String, String>();
    private List<FQIdentifier> aliasToFQIdentifier = new ArrayList<FQIdentifier>();

    public void traverse(SimpleNode node) throws Exception {
    }

    public Object visitImport(Import node) throws Exception {
        this.visitImportModules(node.names);
        return null;
    }

    private void visitImportModules(aliasType[] names) {
        aliasType[] aliasTypeArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            aliasType alias = aliasTypeArray[n2];
            NameTok name = (NameTok)alias.name;
            NameTok asName = (NameTok)alias.asname;
            String realName = name.id;
            String aliasName = name.id;
            if (asName != null) {
                aliasName = asName.id;
            }
            this.addModuleImport(aliasName, realName);
            ++n2;
        }
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        NameTok moduleName = (NameTok)node.module;
        this.visitAlias(moduleName.id, node.names);
        return null;
    }

    private void visitAlias(String prefix, aliasType[] names) {
        if (names != null && names.length > 0) {
            aliasType[] aliasTypeArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                aliasType alias = aliasTypeArray[n2];
                NameTok name = (NameTok)alias.name;
                NameTok asName = (NameTok)alias.asname;
                String realName = name.id;
                String aliasName = name.id;
                if (asName != null) {
                    aliasName = asName.id;
                }
                this.aliasToFQIdentifier.add(new FQIdentifier(prefix, realName, aliasName));
                ++n2;
            }
        } else {
            this.importedModules.put(prefix, prefix);
        }
    }

    private void addModuleImport(String moduleAlias, String realName) {
        if (!this.importedModules.containsKey(moduleAlias)) {
            this.importedModules.put(moduleAlias, realName);
        }
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        return null;
    }

    public Object visitModule(Module node) throws Exception {
        node.traverse((VisitorIF)this);
        return null;
    }

    public List<FQIdentifier> getAliasToFQIdentifier() {
        return this.aliasToFQIdentifier;
    }

    public SortedMap<String, String> getImportedModules() {
        return this.importedModules;
    }
}

