/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.ui.console.IConsoleFactory;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyDebugTargetConsole;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.remote.ListenConnector;
import org.python.pydev.debug.model.remote.RemoteDebuggerConsole;
import org.python.pydev.debug.newconsole.PydevConsole;
import org.python.pydev.debug.newconsole.PydevConsoleCommunication;
import org.python.pydev.debug.newconsole.PydevConsoleInterpreter;
import org.python.pydev.debug.newconsole.PydevDebugConsole;
import org.python.pydev.debug.newconsole.PydevDebugConsoleCommunication;
import org.python.pydev.debug.newconsole.env.IProcessFactory;
import org.python.pydev.debug.newconsole.env.JythonEclipseProcess;
import org.python.pydev.debug.newconsole.env.UserCanceledException;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.ScriptConsoleManager;
import org.python.pydev.plugin.preferences.PydevPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevConsoleFactory
implements IConsoleFactory {
    public void openConsole() {
        this.createConsole(null);
    }

    public void createConsole(String additionalInitialComands) {
        try {
            PydevConsoleInterpreter interpreter = PydevConsoleFactory.createDefaultPydevInterpreter();
            if (interpreter == null) {
                return;
            }
            if (interpreter.getFrame() == null) {
                this.createConsole(interpreter, additionalInitialComands);
            } else {
                this.createDebugConsole(interpreter.getFrame(), additionalInitialComands);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void createConsole(final PydevConsoleInterpreter interpreter, final String additionalInitialComands) {
        Job job = new Job("Create Interactive Console"){

            /*
             * Unable to fully structure code
             */
            protected IStatus run(IProgressMonitor monitor) {
                block9: {
                    monitor.beginTask("Create Interactive Console", 10);
                    returnStatus = Status.OK_STATUS;
                    try {
                        manager = ScriptConsoleManager.getInstance();
                        if (interpreter.getFrame() != null) break block9;
                        monitor.worked(1);
                        console = new PydevConsole(interpreter, additionalInitialComands);
                        monitor.worked(1);
                        try {
                            PydevConsoleFactory.access$0(PydevConsoleFactory.this, interpreter, console, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                            ** GOTO lbl20
                        }
                        catch (UserCanceledException v0) {
                            var7_6 = Status.CANCEL_STATUS;
                            monitor.done();
                            return var7_6;
                        }
                        catch (Exception e) {
                            try {
                                returnStatus = PydevDebugPlugin.makeStatus(4, "Unable to connect debugger to Interactive Console\nThe interactive console will continue to operate without the additional debugger features", e);
lbl20:
                                // 2 sources

                                manager.add((ScriptConsole)console, true);
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                                returnStatus = PydevDebugPlugin.makeStatus(4, "Error initializing console.", e);
                            }
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
                return returnStatus;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void createDebugTarget(PydevConsoleInterpreter interpreter, PydevConsole console, IProgressMonitor monitor) throws IOException, CoreException, DebugException, UserCanceledException {
        block19: {
            monitor.beginTask("Connect Debug Target", 2);
            try {
                Process process = interpreter.getProcess();
                if (!InteractiveConsolePrefs.getConsoleConnectVariableView() || process instanceof JythonEclipseProcess) break block19;
                PydevConsoleCommunication consoleCommunication = (PydevConsoleCommunication)interpreter.getConsoleCommunication();
                try {
                    consoleCommunication.hello((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (Exception ex) {
                    try {
                        if (ex instanceof UserCanceledException) {
                            consoleCommunication.close();
                        }
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                    if (ex instanceof UserCanceledException) {
                        UserCanceledException userCancelled = (UserCanceledException)ex;
                        throw userCancelled;
                    }
                    String message = "Unexpected error setting up the debugger connection. ";
                    if (ex instanceof SocketTimeoutException) {
                        message = "Timed out after " + InteractiveConsolePrefs.getMaximumAttempts() + " attempts to connect to the console.";
                    }
                    throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, message, ex));
                }
                int acceptTimeout = PydevPrefs.getPreferences().getInt("CONNECT_TIMEOUT");
                PyDebugTargetConsole pyDebugTargetConsole = null;
                IProcess eclipseProcess = interpreter.getLaunch().getProcesses()[0];
                RemoteDebuggerConsole debugger = new RemoteDebuggerConsole();
                ListenConnector connector = new ListenConnector(acceptTimeout);
                debugger.startConnect(connector);
                pyDebugTargetConsole = new PyDebugTargetConsole(consoleCommunication, interpreter.getLaunch(), eclipseProcess, debugger);
                Socket socket = null;
                try {
                    consoleCommunication.connectToDebugger(connector.getLocalPort());
                    socket = debugger.waitForConnect(monitor, process, eclipseProcess);
                    if (socket == null) {
                        throw new UserCanceledException("Cancelled");
                    }
                }
                catch (Exception ex) {
                    try {
                        if (ex instanceof UserCanceledException) {
                            consoleCommunication.close();
                            debugger.dispose();
                        } else {
                            debugger.disposeConnector();
                        }
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                    if (ex instanceof UserCanceledException) {
                        UserCanceledException userCancelled = (UserCanceledException)ex;
                        throw userCancelled;
                    }
                    String message = "Unexpected error setting up the debugger";
                    if (ex instanceof SocketTimeoutException) {
                        message = "Timed out after " + Float.toString(acceptTimeout / 1000) + " seconds while waiting for python script to connect.";
                    }
                    throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, message, ex));
                }
                pyDebugTargetConsole.startTransmission(socket);
                pyDebugTargetConsole.initialize();
                consoleCommunication.setDebugTarget(pyDebugTargetConsole);
                interpreter.getLaunch().addDebugTarget((IDebugTarget)pyDebugTargetConsole);
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                launchManager.addLaunch(interpreter.getLaunch());
                pyDebugTargetConsole.setConsole(console);
                console.setProcess(pyDebugTargetConsole.getProcess());
                pyDebugTargetConsole.finishedInit = true;
            }
            finally {
                monitor.done();
            }
        }
    }

    public void createDebugConsole(PyStackFrame frame, String additionalInitialComands) throws Exception {
        IProcessFactory.PydevConsoleLaunchInfo launchAndProcess = new IProcessFactory.PydevConsoleLaunchInfo(null, null, 0, null, frame);
        PydevConsoleInterpreter interpreter = PydevConsoleFactory.createPydevDebugInterpreter(launchAndProcess);
        ScriptConsoleManager manager = ScriptConsoleManager.getInstance();
        PydevDebugConsole console = new PydevDebugConsole(interpreter, additionalInitialComands);
        manager.add((ScriptConsole)console, true);
    }

    public static PydevConsoleInterpreter createDefaultPydevInterpreter() throws Exception, UserCanceledException {
        IProcessFactory iprocessFactory = new IProcessFactory();
        IProcessFactory.PydevConsoleLaunchInfo launchAndProcess = iprocessFactory.createInteractiveLaunch();
        if (launchAndProcess == null) {
            return null;
        }
        if (launchAndProcess.interpreter != null) {
            return PydevConsoleFactory.createPydevInterpreter(launchAndProcess, iprocessFactory.getNaturesUsed());
        }
        return PydevConsoleFactory.createPydevDebugInterpreter(launchAndProcess);
    }

    public static PydevConsoleInterpreter createPydevInterpreter(IProcessFactory.PydevConsoleLaunchInfo info, List<IPythonNature> natures) throws Exception {
        Launch launch = info.launch;
        Process process = info.process;
        Integer clientPort = info.clientPort;
        IInterpreterInfo interpreterInfo = info.interpreter;
        if (launch == null) {
            return null;
        }
        PydevConsoleInterpreter consoleInterpreter = new PydevConsoleInterpreter();
        int port = Integer.parseInt(launch.getAttribute("INTERACTIVE_LAUNCH_PORT"));
        consoleInterpreter.setConsoleCommunication(new PydevConsoleCommunication(port, process, clientPort));
        consoleInterpreter.setNaturesUsed(natures);
        consoleInterpreter.setInterpreterInfo(interpreterInfo);
        consoleInterpreter.setLaunch((ILaunch)launch);
        consoleInterpreter.setProcess(process);
        PydevDebugPlugin.getDefault().addConsoleLaunch((ILaunch)launch);
        consoleInterpreter.addCloseOperation(new Runnable((ILaunch)launch){
            private final /* synthetic */ ILaunch val$launch;
            {
                this.val$launch = iLaunch;
            }

            public void run() {
                PydevDebugPlugin.getDefault().removeConsoleLaunch(this.val$launch);
            }
        });
        return consoleInterpreter;
    }

    public static PydevConsoleInterpreter createPydevDebugInterpreter(IProcessFactory.PydevConsoleLaunchInfo info) throws Exception {
        PyStackFrame frame = info.frame;
        PydevConsoleInterpreter consoleInterpreter = new PydevConsoleInterpreter();
        consoleInterpreter.setFrame(frame);
        consoleInterpreter.setConsoleCommunication(new PydevDebugConsoleCommunication());
        return consoleInterpreter;
    }

    static /* synthetic */ void access$0(PydevConsoleFactory pydevConsoleFactory, PydevConsoleInterpreter pydevConsoleInterpreter, PydevConsole pydevConsole, IProgressMonitor iProgressMonitor) throws IOException, CoreException, DebugException, UserCanceledException {
        pydevConsoleFactory.createDebugTarget(pydevConsoleInterpreter, pydevConsole, iProgressMonitor);
    }
}

