/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcNoSuchHandlerException;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.pyunit.IPyUnitLaunch;
import org.python.pydev.debug.pyunit.IPyUnitServer;
import org.python.pydev.debug.pyunit.IPyUnitServerListener;
import org.python.pydev.debug.pyunit.PyUnitLaunch;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.SocketUtil;

public class PyUnitServer
implements IPyUnitServer {
    protected WebServer webServer;
    protected int port;
    protected ILaunchConfiguration configuration;
    protected ILaunch launch;
    protected boolean disposed = false;
    protected List<IPyUnitServerListener> listeners = new ArrayList<IPyUnitServerListener>();
    private XmlRpcHandler handler = new XmlRpcHandler(){

        public Object execute(final XmlRpcRequest request) throws XmlRpcException {
            return this.execute(new IRequest(){

                public int getParameterCount() {
                    return request.getParameterCount();
                }

                public Object getParameter(int i) {
                    return request.getParameter(i);
                }

                public String getMethodName() {
                    return request.getMethodName();
                }
            });
        }

        public Object execute(IRequest request) throws XmlRpcException {
            try {
                String method = request.getMethodName();
                Dispatch actual = (Dispatch)PyUnitServer.this.dispatch.get(method);
                if (actual != null) {
                    actual.handle(request);
                } else {
                    Log.log((String)("Unhandled notification: " + method));
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
            return "OK";
        }
    };
    private final HashMap<String, Dispatch> dispatch = new HashMap();
    private ILaunchesListener2 launchListener = new ILaunchesListener2(){

        public void launchesRemoved(ILaunch[] launches) {
            if (!PyUnitServer.this.disposed) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch iLaunch = iLaunchArray[n2];
                    if (iLaunch == PyUnitServer.this.launch) {
                        PyUnitServer.this.dispose();
                    }
                    ++n2;
                }
            }
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesTerminated(ILaunch[] launches) {
            if (!PyUnitServer.this.disposed) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch iLaunch = iLaunchArray[n2];
                    if (iLaunch == PyUnitServer.this.launch) {
                        PyUnitServer.this.dispose();
                    }
                    ++n2;
                }
            }
        }
    };

    private void initializeDispatches() {
        this.dispatch.put("notifyTest", new Dispatch(6){

            public void dispatch(IRequest request) {
                String status = request.getParameter(0).toString();
                String capturedOutput = request.getParameter(1).toString();
                String errorContents = request.getParameter(2).toString();
                String location = request.getParameter(3).toString();
                String test = request.getParameter(4).toString();
                String time = request.getParameter(5).toString();
                for (IPyUnitServerListener listener : PyUnitServer.this.listeners) {
                    listener.notifyTest(status, location, test, capturedOutput, errorContents, time);
                }
            }
        });
        this.dispatch.put("notifyStartTest", new Dispatch(2){

            public void dispatch(IRequest request) {
                String location = request.getParameter(0).toString();
                String test = request.getParameter(1).toString();
                for (IPyUnitServerListener listener : PyUnitServer.this.listeners) {
                    listener.notifyStartTest(location, test);
                }
            }
        });
        this.dispatch.put("notifyTestsCollected", new Dispatch(1){

            public void dispatch(IRequest request) {
                String totalTestsCount = request.getParameter(0).toString();
                for (IPyUnitServerListener listener : PyUnitServer.this.listeners) {
                    listener.notifyTestsCollected(totalTestsCount);
                }
            }
        });
        this.dispatch.put("notifyConnected", new Dispatch(0){

            public void dispatch(IRequest request) {
            }
        });
        this.dispatch.put("notifyTestRunFinished", new Dispatch(1){

            public void dispatch(IRequest request) {
                for (IPyUnitServerListener listener : PyUnitServer.this.listeners) {
                    Object seconds = request.getParameter(0);
                    listener.notifyFinished(seconds.toString());
                }
            }
        });
        this.dispatch.put("notifyCommands", new Dispatch(1){

            public void dispatch(IRequest request) {
                Object requestParam = request.getParameter(0);
                if (!(requestParam instanceof Object[])) {
                    if (requestParam == null) {
                        Log.log((String)"Expected Object[]. Found: null");
                    } else {
                        Log.log((String)("Expected Object[]. Found: " + requestParam.getClass()));
                    }
                    return;
                }
                Object[] parameters = (Object[])requestParam;
                int i = 0;
                while (i < parameters.length) {
                    Object param = parameters[i];
                    if (!(param instanceof Object[])) {
                        if (param == null) {
                            Log.log((String)"Expected Object[]. Found: null");
                        } else {
                            Log.log((String)("Expected Object[]. Found: " + param.getClass()));
                        }
                        return;
                    }
                    Object[] methodAndParams = (Object[])param;
                    if (methodAndParams.length != 2) {
                        Log.log((String)("Expected Object[] of len == 2. Found len: " + methodAndParams.length));
                    } else if (!(methodAndParams[1] instanceof Object[])) {
                        Log.log((String)("Expected methodAndParams[1] to be Object[]. Found: " + methodAndParams[1].getClass()));
                    } else {
                        final String methodName = methodAndParams[0].toString();
                        final Object[] params = (Object[])methodAndParams[1];
                        Dispatch d = (Dispatch)PyUnitServer.this.dispatch.get(methodName);
                        if (d != null) {
                            d.handle(new IRequest(){

                                public int getParameterCount() {
                                    return params.length;
                                }

                                public Object getParameter(int i) {
                                    return params[i];
                                }

                                public String getMethodName() {
                                    return methodName;
                                }
                            });
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public PyUnitServer(PythonRunnerConfig config, ILaunch launch) throws IOException {
        this.initializeDispatches();
        this.port = SocketUtil.findUnusedLocalPorts((int)1)[0];
        SocketUtil.checkValidPort((int)this.port);
        this.webServer = new WebServer(this.port);
        XmlRpcStreamServer serverToHandleRawInput = this.webServer.getXmlRpcServer();
        serverToHandleRawInput.setHandlerMapping(new XmlRpcHandlerMapping(){

            public XmlRpcHandler getHandler(String handlerName) throws XmlRpcNoSuchHandlerException, XmlRpcException {
                return PyUnitServer.this.handler;
            }
        });
        this.webServer.start();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchesListener)this.launchListener);
        this.launch = launch;
        this.configuration = config.getLaunchConfiguration();
    }

    public void registerOnNotifyTest(IPyUnitServerListener listener) {
        if (!this.disposed) {
            this.listeners.add(listener);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            try {
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                launchManager.removeLaunchListener((ILaunchesListener)this.launchListener);
            }
            catch (Throwable e1) {
                Log.log((Throwable)e1);
            }
            if (this.webServer != null) {
                try {
                    this.webServer.shutdown();
                }
                catch (Throwable throwable) {}
                this.webServer = null;
            }
            for (IPyUnitServerListener listener : this.listeners) {
                listener.notifyDispose();
            }
            this.listeners.clear();
        }
    }

    public IPyUnitLaunch getPyUnitLaunch() {
        return new PyUnitLaunch(this.launch, this.configuration);
    }

    private static abstract class Dispatch {
        private final int expectedParameters;

        Dispatch(int expectedParameters) {
            this.expectedParameters = expectedParameters;
        }

        protected abstract void dispatch(IRequest var1);

        public void handle(IRequest request) {
            int parameterCount = request.getParameterCount();
            if (parameterCount != this.expectedParameters) {
                Log.log((String)("Error. Expected " + this.expectedParameters + " parameters in notifyTest. Received: " + parameterCount));
            } else {
                this.dispatch(request);
            }
        }
    }

    private static interface IRequest {
        public String getMethodName();

        public int getParameterCount();

        public Object getParameter(int var1);
    }
}

