/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.pyunit.IPyUnitLaunch;
import org.python.pydev.debug.pyunit.PyUnitTestResult;
import org.python.pydev.debug.pyunit.PyUnitTestStarted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyUnitTestRun {
    private final ArrayList<PyUnitTestResult> results;
    private final Map<Tuple<String, String>, PyUnitTestStarted> testsRunning;
    public final String name;
    private static int currentRun = 0;
    private static Object lock = new Object();
    private int numberOfErrors;
    private int numberOfFailures;
    private String totalNumberOfRuns = "0";
    private boolean finished;
    private IPyUnitLaunch pyUnitLaunch;
    private int nextIndex = 0;
    private String totalTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyUnitTestRun(IPyUnitLaunch server) {
        Object object = lock;
        synchronized (object) {
            this.name = "Test Run:" + currentRun;
            ++currentRun;
        }
        this.pyUnitLaunch = server;
        this.results = new ArrayList();
        this.testsRunning = new LinkedHashMap<Tuple<String, String>, PyUnitTestStarted>();
    }

    public Collection<PyUnitTestStarted> getTestsRunning() {
        return this.testsRunning.values();
    }

    public void setTotalNumberOfRuns(String totalNumberOfRuns) {
        this.totalNumberOfRuns = totalNumberOfRuns;
    }

    public synchronized void addResult(PyUnitTestResult result) {
        if (result.status.equals("fail")) {
            ++this.numberOfFailures;
        } else if (result.status.equals("error")) {
            ++this.numberOfErrors;
        } else if (!result.status.equals("ok")) {
            Log.log((String)("Unexpected status: " + result.status));
        }
        Tuple key = new Tuple((Object)result.location, (Object)result.test);
        this.testsRunning.remove(key);
        this.results.add(result);
    }

    public void addStartTest(PyUnitTestStarted result) {
        Tuple key = new Tuple((Object)result.location, (Object)result.test);
        this.testsRunning.put((Tuple<String, String>)key, result);
    }

    public List<PyUnitTestResult> getSharedResultsList() {
        return this.results;
    }

    public int getNumberOfRuns() {
        return this.results.size();
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public String getTotalNumberOfRuns() {
        return this.totalNumberOfRuns;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public boolean getFinished() {
        return this.finished;
    }

    public void stop() {
        IPyUnitLaunch s;
        if (this.pyUnitLaunch != null && (s = this.pyUnitLaunch) != null) {
            s.stop();
        }
    }

    public void relaunch() {
        IPyUnitLaunch s;
        if (this.pyUnitLaunch != null && (s = this.pyUnitLaunch) != null) {
            s.relaunch();
        }
    }

    public String toString() {
        return "PyUnitTestResult.\n    Finished: " + this.finished + "\n" + "    Number of runs: " + this.results.size() + "    Number of failures:" + this.numberOfFailures + "\n" + "    Number of errors: " + this.numberOfErrors + "\n";
    }

    public void relaunchOnlyErrors() {
        IPyUnitLaunch s = this.pyUnitLaunch;
        if (s != null) {
            ArrayList<PyUnitTestResult> arrayList = new ArrayList<PyUnitTestResult>(this.results.size());
            for (PyUnitTestResult pyUnitTestResult : this.results) {
                if (pyUnitTestResult.status.equals("ok")) continue;
                arrayList.add(pyUnitTestResult);
            }
            s.relaunchTestResults(arrayList);
        }
    }

    public void relaunch(List<PyUnitTestResult> resultsToRelaunch, String mode) {
        IPyUnitLaunch s = this.pyUnitLaunch;
        if (s != null) {
            s.relaunchTestResults(resultsToRelaunch, mode);
        }
    }

    public synchronized String getNextTestIndex() {
        return Integer.toString(++this.nextIndex);
    }

    public void setTotalTime(String totalTime) {
        this.totalTime = totalTime;
    }

    public String getTotalTime() {
        return this.totalTime;
    }
}

