/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.UIJob;
import org.python.pydev.core.callbacks.ICallback0;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.pyunit.IPyUnitLaunch;
import org.python.pydev.debug.pyunit.IPyUnitServer;
import org.python.pydev.debug.pyunit.IPyUnitServerListener;
import org.python.pydev.debug.pyunit.PyUnitTestResult;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitTestStarted;
import org.python.pydev.debug.pyunit.PyUnitView;

final class PyUnitViewServerListener
implements IPyUnitServerListener {
    private PyUnitView view;
    private Object lockView = new Object();
    private LinkedList<ICallback0<Object>> notifications = new LinkedList();
    private Job updateJob = new UIJob("Update unittest view"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            ArrayList arrayList;
            LinkedList linkedList = PyUnitViewServerListener.this.notifications;
            synchronized (linkedList) {
                arrayList = new ArrayList(PyUnitViewServerListener.this.notifications);
                PyUnitViewServerListener.this.notifications.clear();
            }
            for (ICallback0 iCallback0 : arrayList) {
                try {
                    iCallback0.call();
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }
    };
    private final PyUnitTestRun testRun;
    public static int TIMEOUT = 25;
    public static int JOBS_PRIORITY = 20;
    private boolean finishedNotified = false;

    public PyUnitViewServerListener(IPyUnitServer pyUnitServer, IPyUnitLaunch pyUnitLaunch) {
        this.testRun = new PyUnitTestRun(pyUnitLaunch);
        pyUnitServer.registerOnNotifyTest(this);
        this.updateJob.setPriority(JOBS_PRIORITY);
        this.updateJob.setSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTest(final String status, final String location, final String test, final String capturedOutput, final String errorContents, final String time) {
        LinkedList<ICallback0<Object>> linkedList = this.notifications;
        synchronized (linkedList) {
            this.notifications.add(new ICallback0<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() {
                    PyUnitTestResult result = new PyUnitTestResult(PyUnitViewServerListener.this.testRun, status, location, test, capturedOutput, errorContents, time);
                    PyUnitViewServerListener.this.testRun.addResult(result);
                    Object object = PyUnitViewServerListener.this.lockView;
                    synchronized (object) {
                        if (PyUnitViewServerListener.this.view != null) {
                            PyUnitViewServerListener.this.view.notifyTest(result);
                        }
                    }
                    return null;
                }
            });
        }
        this.updateJob.schedule((long)TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyStartTest(final String location, final String test) {
        LinkedList<ICallback0<Object>> linkedList = this.notifications;
        synchronized (linkedList) {
            this.notifications.add(new ICallback0<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() {
                    PyUnitTestStarted result = new PyUnitTestStarted(PyUnitViewServerListener.this.testRun, location, test);
                    PyUnitViewServerListener.this.testRun.addStartTest(result);
                    Object object = PyUnitViewServerListener.this.lockView;
                    synchronized (object) {
                        if (PyUnitViewServerListener.this.view != null) {
                            PyUnitViewServerListener.this.view.notifyTestStarted(result);
                        }
                    }
                    return null;
                }
            });
        }
        this.updateJob.schedule((long)TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyFinished(final String totalTime) {
        LinkedList<ICallback0<Object>> linkedList = this.notifications;
        synchronized (linkedList) {
            if (!this.finishedNotified) {
                this.finishedNotified = true;
                this.notifications.add(new ICallback0<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object call() {
                        PyUnitViewServerListener.this.testRun.setFinished(true);
                        if (totalTime != null) {
                            PyUnitViewServerListener.this.testRun.setTotalTime(totalTime);
                        }
                        Object object = PyUnitViewServerListener.this.lockView;
                        synchronized (object) {
                            if (PyUnitViewServerListener.this.view != null) {
                                PyUnitViewServerListener.this.view.notifyFinished(PyUnitViewServerListener.this.testRun);
                            }
                        }
                        return null;
                    }
                });
            }
        }
        this.updateJob.schedule((long)TIMEOUT);
    }

    public void notifyDispose() {
        this.notifyFinished(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setView(PyUnitView view) {
        Object object = this.lockView;
        synchronized (object) {
            this.view = view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PyUnitView getView() {
        Object object = this.lockView;
        synchronized (object) {
            return this.view;
        }
    }

    public PyUnitTestRun getTestRun() {
        return this.testRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTestsCollected(String totalTestsCount) {
        this.testRun.setTotalNumberOfRuns(totalTestsCount);
        Object object = this.lockView;
        synchronized (object) {
            if (this.view != null) {
                this.view.notifyTestsCollected(this.testRun);
            }
        }
    }
}

