/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.pyunit;

import java.lang.ref.WeakReference;
import org.eclipse.jface.action.Action;
import org.python.pydev.core.callbacks.ICallbackListener;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.pyunit.PinHistoryAction;
import org.python.pydev.debug.pyunit.PyUnitTestRun;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.debug.pyunit.SetCurrentRunAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestorePinHistoryAction
extends Action
implements ICallbackListener<PyUnitTestRun> {
    private WeakReference<PyUnitView> view;
    private PinHistoryAction pinHistory;
    private PyUnitTestRun testRun;

    public RestorePinHistoryAction(PyUnitView pyUnitView, PinHistoryAction pinHistory) {
        this.view = new WeakReference<PyUnitView>(pyUnitView);
        this.pinHistory = pinHistory;
        this.pinHistory.onRunSelected.registerListener((ICallbackListener)this);
        this.setEnabled(false);
        this.setImageDescriptor(PydevDebugPlugin.getImageCache().getDescriptor("icons/refresh.png"));
        this.setInitialTooltipText();
    }

    private void setInitialTooltipText() {
        this.setToolTipText("Click to restore pinned test run.");
    }

    public Object call(PyUnitTestRun obj) {
        if (obj != null) {
            this.setToolTipText("Click to restore test run: " + obj.name);
        } else {
            this.setInitialTooltipText();
        }
        this.setEnabled(obj != null);
        this.testRun = obj;
        return null;
    }

    public void run() {
        if (this.testRun != null) {
            SetCurrentRunAction setCurrentRunAction = new SetCurrentRunAction(this.view, this.testRun);
            setCurrentRunAction.run();
        }
    }
}

