/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.RetargetAction;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.python.pydev.debug.ui.actions.ISetNextTarget;

public class RetargetSetNextAction
extends RetargetAction {
    private DebugContextListener fContextListener = new DebugContextListener();
    private ISuspendResume fTargetElement = null;

    protected boolean canPerformAction(Object target, ISelection selection, IWorkbenchPart part) {
        return this.fTargetElement != null && ((ISetNextTarget)target).canSetNextToLine(part, selection, this.fTargetElement);
    }

    protected Class getAdapterClass() {
        return ISetNextTarget.class;
    }

    protected String getOperationUnavailableMessage() {
        return null;
    }

    protected void performAction(Object target, ISelection selection, IWorkbenchPart part) throws CoreException {
        boolean result = ((ISetNextTarget)target).setNextToLine(part, selection, this.fTargetElement);
        if (!result) {
            Status status = new Status(2, DebugUIPlugin.getUniqueIdentifier(), "Unable to set the next statement to this location. The next statement cannot be set to another function/loop.");
            DebugUIPlugin.errorDialog((Shell)DebugUIPlugin.getShell(), (String)DebugUIPlugin.removeAccelerators((String)"Set Next Statement"), (String)"Error", (IStatus)status);
        }
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.fWindow).removeDebugContextListener((IDebugContextListener)this.fContextListener);
        super.dispose();
    }

    public void init(IWorkbenchWindow window) {
        super.init(window);
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(window);
        service.addDebugContextListener((IDebugContextListener)this.fContextListener);
        ISelection activeContext = service.getActiveContext();
        this.fContextListener.contextActivated(activeContext);
    }

    class DebugContextListener
    implements IDebugContextListener {
        DebugContextListener() {
        }

        protected void contextActivated(ISelection selection) {
            IAction action;
            IStructuredSelection ss;
            RetargetSetNextAction.this.fTargetElement = null;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                RetargetSetNextAction.this.fTargetElement = (ISuspendResume)DebugPlugin.getAdapter((Object)ss.getFirstElement(), ISuspendResume.class);
            }
            if ((action = RetargetSetNextAction.this.getAction()) != null) {
                action.setEnabled(RetargetSetNextAction.this.fTargetElement != null && RetargetSetNextAction.this.hasTargetAdapter());
            }
        }

        public void debugContextChanged(DebugContextEvent event) {
            this.contextActivated(event.getContext());
        }
    }
}

