/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.ui.texteditor.IUpdate;
import org.python.pydev.bindingutils.KeyBindingHelper;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;

public class TerminateAllLaunchesAction
extends PyAction
implements IUpdate {
    public TerminateAllLaunchesAction() {
        KeySequence binding = KeyBindingHelper.getCommandKeyBinding((String)"org.python.pydev.debug.ui.actions.terminateAllLaunchesAction");
        String str = binding != null ? "(" + binding.format() + " when on Pydev editor)" : "(unbinded)";
        this.setImageDescriptor(PydevPlugin.getImageCache().getDescriptor("icons/terminate_all.gif"));
        this.setToolTipText("Terminate ALL." + str);
        this.update();
    }

    public void update() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        try {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch iLaunch = iLaunchArray[n2];
                if (!iLaunch.isTerminated()) {
                    this.setEnabled(true);
                    return;
                }
                ++n2;
            }
            this.setEnabled(false);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void run(IAction action) {
        Job job = new Job("Terminate all Launches"){

            protected IStatus run(IProgressMonitor monitor) {
                ILaunch[] launches;
                ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch iLaunch = iLaunchArray[n2];
                    try {
                        if (!iLaunch.isTerminated()) {
                            iLaunch.terminate();
                        }
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    public void run() {
        this.run((IAction)this);
    }

    public void dispose() {
    }
}

