/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.REF;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.launching.FileOrResource;

public abstract class LaunchConfigurationCreator {
    public static String getDefaultLocation(FileOrResource[] file, boolean makeRelative) {
        StringBuffer buffer = new StringBuffer();
        FileOrResource[] fileOrResourceArray = file;
        int n = file.length;
        int n2 = 0;
        while (n2 < n) {
            String loc;
            FileOrResource r = fileOrResourceArray[n2];
            if (buffer.length() > 0) {
                buffer.append('|');
            }
            if (r.resource != null) {
                if (makeRelative) {
                    IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
                    loc = LaunchConfigurationCreator.makeFileRelativeToWorkspace(r.resource, varManager);
                } else {
                    loc = r.resource.getLocation().toOSString();
                }
            } else {
                loc = REF.getFileAbsolutePath((String)r.file.getAbsolutePath());
            }
            buffer.append(loc);
            ++n2;
        }
        return buffer.toString();
    }

    public static ILaunchConfigurationWorkingCopy createDefaultLaunchConfiguration(FileOrResource[] resource, String launchConfigurationType, String location, IInterpreterManager pythonInterpreterManager, String projName) throws CoreException {
        return LaunchConfigurationCreator.createDefaultLaunchConfiguration(resource, launchConfigurationType, location, pythonInterpreterManager, projName, null, "", true);
    }

    private static ILaunchConfigurationWorkingCopy createDefaultLaunchConfiguration(FileOrResource[] resource, String launchConfigurationType, String location, IInterpreterManager pythonInterpreterManager, String projName, String vmargs, String programArguments, boolean captureOutput) throws CoreException {
        int resourceType;
        String moduleFile;
        String baseDirectory;
        String name;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(launchConfigurationType);
        if (type == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Python launch configuration not found", null));
        }
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        if (captureOutput) {
            StringBuffer buffer = new StringBuffer(projName);
            buffer.append(" ");
            StringBuffer resourceNames = new StringBuffer();
            FileOrResource[] fileOrResourceArray = resource;
            int n = resource.length;
            int n2 = 0;
            while (n2 < n) {
                FileOrResource r = fileOrResourceArray[n2];
                if (resourceNames.length() > 0) {
                    resourceNames.append(" - ");
                }
                if (r.resource != null) {
                    resourceNames.append(r.resource.getName());
                } else {
                    resourceNames.append(r.file.getName());
                }
                ++n2;
            }
            buffer.append(resourceNames);
            name = buffer.toString().trim();
            if (resource[0].resource != null) {
                baseDirectory = resource[0].resource.getFullPath().removeLastSegments(1).makeRelative().toString();
                baseDirectory = varManager.generateVariableExpression("workspace_loc", baseDirectory);
                moduleFile = LaunchConfigurationCreator.makeFileRelativeToWorkspace(resource, varManager);
                resourceType = resource[0].resource.getType();
            } else {
                baseDirectory = REF.getFileAbsolutePath((File)resource[0].file.getParentFile());
                moduleFile = REF.getFileAbsolutePath((File)resource[0].file);
                resourceType = 1;
            }
        } else {
            captureOutput = true;
            name = location;
            baseDirectory = new File(location).getParent();
            moduleFile = location;
            resourceType = 1;
        }
        name = manager.generateUniqueLaunchConfigurationNameFrom(name);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
        workingCopy.setAttribute("org.python.pydev.debug.ATTR_PROJECT", projName);
        workingCopy.setAttribute("org.python.pydev.debug.ATTR_RESOURCE_TYPE", resourceType);
        workingCopy.setAttribute("org.python.pydev.debug.ATTR_INTERPRETER", "__default");
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", moduleFile);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", baseDirectory);
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", programArguments);
        workingCopy.setAttribute("org.python.pydev.debug.vm.arguments", vmargs);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", captureOutput);
        workingCopy.setAttribute("org.eclipse.debug.core.capture_output", captureOutput);
        if (resource[0].resource != null) {
            workingCopy.setMappedResources(FileOrResource.createIResourceArray(resource));
        }
        return workingCopy;
    }

    private static String makeFileRelativeToWorkspace(FileOrResource[] resource, IStringVariableManager varManager) {
        FastStringBuffer moduleFile = new FastStringBuffer(80 * resource.length);
        FileOrResource[] fileOrResourceArray = resource;
        int n = resource.length;
        int n2 = 0;
        while (n2 < n) {
            FileOrResource r = fileOrResourceArray[n2];
            if (moduleFile.length() > 0) {
                moduleFile.append("|");
            }
            if (r.resource != null) {
                moduleFile.append(LaunchConfigurationCreator.makeFileRelativeToWorkspace(r.resource, varManager));
            } else {
                moduleFile.append(REF.getFileAbsolutePath((File)r.file));
            }
            ++n2;
        }
        return moduleFile.toString();
    }

    private static String makeFileRelativeToWorkspace(IResource r, IStringVariableManager varManager) {
        String m = r.getFullPath().makeRelative().toString();
        m = varManager.generateVariableExpression("workspace_loc", m);
        return m;
    }
}

