/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.visitors.MessagesManager;
import com.python.pydev.analysis.visitors.OccurrencesVisitor;
import com.python.pydev.analysis.visitors.Scope;
import java.util.HashMap;
import java.util.Map;
import org.python.pydev.core.IToken;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.visitors.NodeUtils;

public final class DuplicationChecker {
    private final FastStack<Map<String, String>> stack = new FastStack(10);
    private final Scope scope;
    private final MessagesManager messagesManager;

    public DuplicationChecker(OccurrencesVisitor visitor) {
        this.startScope("", null);
        this.scope = visitor.scope;
        this.messagesManager = visitor.messagesManager;
    }

    private void startScope(String name, SimpleNode node) {
        this.checkDuplication(name, node);
        HashMap item = new HashMap();
        this.stack.push(item);
    }

    private void endScope(String name) {
        this.stack.pop();
        ((Map)this.stack.peek()).put(name, name);
    }

    private void checkDuplication(String name, SimpleNode node) {
        String exists;
        if (this.stack.size() > 0 && !this.scope.getPrevScopeItems().getIsInSubSubScope() && (exists = (String)((Map)this.stack.peek()).get(name)) != null) {
            if (node instanceof FunctionDef) {
                FunctionDef functionDef = (FunctionDef)node;
                if (functionDef.decs != null && functionDef.decs.length > 0) {
                    decoratorsType[] decoratorsTypeArray = functionDef.decs;
                    int n = functionDef.decs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fullRepresentationString;
                        decoratorsType dec = decoratorsTypeArray[n2];
                        if (dec.func != null && (fullRepresentationString = NodeUtils.getFullRepresentationString((SimpleNode)dec.func)).startsWith(String.valueOf(name) + ".")) {
                            return;
                        }
                        ++n2;
                    }
                }
            }
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)node, (String)"");
            this.messagesManager.addMessage(4, (IToken)token, name);
        }
    }

    public void beforeClassDef(ClassDef node) {
        this.startScope(NodeUtils.getRepresentationString((SimpleNode)node), (SimpleNode)node);
    }

    public void afterClassDef(ClassDef node) {
        this.endScope(NodeUtils.getRepresentationString((SimpleNode)node));
    }

    public void beforeFunctionDef(FunctionDef node) {
        this.startScope(NodeUtils.getRepresentationString((SimpleNode)node), (SimpleNode)node);
    }

    public void afterFunctionDef(FunctionDef node) {
        this.endScope(NodeUtils.getRepresentationString((SimpleNode)node));
    }
}

