/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django_templates.editor;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SubPartitionScanner;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.django_templates.completions.DjContentAssistProcessor;
import org.python.pydev.django_templates.completions.templates.TemplateHelper;
import org.python.pydev.editor.PyCodeScanner;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.ColorAndStyleCache;

public abstract class DjSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    protected static final String SOURCE_DJ = "source.dj";
    protected static final String STRING_QUOTED_DOUBLE_DJ = "string.quoted.double.dj";
    protected static final String STRING_QUOTED_SINGLE_DJ = "string.quoted.single.dj";
    protected static final String COMMENT_DJ = "comment.dj";
    public static final String PREFIX = "__dj_";
    public static final String DEFAULT = "__dj__dftl_partition_content_type";
    public static final String STRING_SINGLE = "__dj_string_single";
    public static final String STRING_DOUBLE = "__dj_string_double";
    public static final String COMMENT = "__dj_comment";
    public static final String[] CONTENT_TYPES = new String[]{"__dj__dftl_partition_content_type", "__dj_string_single", "__dj_string_double", "__dj_comment"};
    protected static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.html.django_templates"}};
    protected IPredicateRule[] partitioningRules = new IPredicateRule[]{new SingleLineRule("\"", "\"", DjSourceConfiguration.getToken("__dj_string_double"), '\\'), new SingleLineRule("'", "'", DjSourceConfiguration.getToken("__dj_string_single"), '\\'), new SingleLineRule("{#", "#}", DjSourceConfiguration.getToken("__dj_comment"))};
    private String contentType;
    protected ColorAndStyleCache colorCache;

    public DjSourceConfiguration(String contentType) {
        this.contentType = contentType;
    }

    public String[] getContentTypes() {
        return CONTENT_TYPES;
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new SubPartitionScanner(this.partitioningRules, CONTENT_TYPES, DjSourceConfiguration.getToken(DEFAULT));
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return this.contentType;
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new DefaultDamagerRepairer(this.getSingleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_SINGLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_SINGLE);
        dr = new DefaultDamagerRepairer(this.getDoubleQuotedStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, STRING_DOUBLE);
        reconciler.setRepairer((IPresentationRepairer)dr, STRING_DOUBLE);
        dr = new DefaultDamagerRepairer(this.getCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, COMMENT);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        return new DjContentAssistProcessor(contentType, null);
    }

    public PyCodeScanner getCodeScanner() {
        PyCodeScanner codeScanner = new PyCodeScanner(this.getColorCache(), this.getKeywordsFromTemplates());
        return codeScanner;
    }

    public String[] getKeywordsFromTemplates() {
        Template[] templates = TemplateHelper.getTemplateStore().getTemplates("org.python.pydev.django_templates.tagsTemplatesContext");
        ArrayList<String> templateNames = new ArrayList<String>();
        Template[] templateArray = templates;
        int n = templates.length;
        int n2 = 0;
        while (n2 < n) {
            Template template = templateArray[n2];
            String name = template.getName();
            if (!StringUtils.containsWhitespace((String)name)) {
                templateNames.add(name);
            }
            ++n2;
        }
        String[] keywords = templateNames.toArray(new String[templateNames.size()]);
        return keywords;
    }

    protected ITokenScanner getSingleQuotedStringScanner() {
        RuleBasedScanner singleQuotedStringScanner = new RuleBasedScanner();
        singleQuotedStringScanner.setDefaultReturnToken(DjSourceConfiguration.getToken(STRING_QUOTED_SINGLE_DJ));
        return singleQuotedStringScanner;
    }

    protected ITokenScanner getCommentScanner() {
        RuleBasedScanner commentScanner = new RuleBasedScanner();
        commentScanner.setDefaultReturnToken(DjSourceConfiguration.getToken(COMMENT_DJ));
        return commentScanner;
    }

    protected ITokenScanner getDoubleQuotedStringScanner() {
        RuleBasedScanner doubleQuotedStringScanner = new RuleBasedScanner();
        doubleQuotedStringScanner.setDefaultReturnToken(DjSourceConfiguration.getToken(STRING_QUOTED_DOUBLE_DJ));
        return doubleQuotedStringScanner;
    }

    protected static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }

    public ColorAndStyleCache getColorCache() {
        if (this.colorCache == null) {
            IPreferenceStore prefStore = PydevPrefs.getChainedPrefStore();
            this.colorCache = new ColorAndStyleCache(prefStore);
            prefStore.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    String property = event.getProperty();
                    if (ColorAndStyleCache.isColorOrStyleProperty((String)property)) {
                        DjSourceConfiguration.this.colorCache.reloadNamedColor(property);
                        DjSourceConfiguration.this.updateSyntaxColorAndStyle();
                    }
                }
            });
        }
        return this.colorCache;
    }

    public void updateSyntaxColorAndStyle() {
        this.getCodeScanner().updateColors();
    }
}

