/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django_templates.outline;

import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.ParseNode;
import java.util.StringTokenizer;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.django_templates.DjPlugin;
import org.python.pydev.django_templates.comon.parsing.DjangoTemplatesNode;

public class DjOutlineLabelProvider {
    private IDocument fDocument;
    private static final int TRIM_TO_LENGTH = 20;

    public DjOutlineLabelProvider(IDocument document) {
        this.fDocument = document;
    }

    public Image getImage(Object element) {
        IParseNode node;
        if (element instanceof CommonOutlineItem && (node = ((CommonOutlineItem)element).getReferenceNode()) instanceof DjangoTemplatesNode) {
            return DjPlugin.getImageCache().get("icons/element.gif");
        }
        return null;
    }

    private String getDisplayText(DjangoTemplatesNode script) {
        StringBuilder text = new StringBuilder();
        text.append(script.getStartTag()).append(" ");
        String source = new String(this.fDocument.get());
        ParseNode node = script.getNode();
        source = source.substring(node.getStartingOffset(), node.getEndingOffset() + 1);
        StringTokenizer st = new StringTokenizer(source, "\n\r\f");
        source = st.nextToken();
        if (source.length() <= 20) {
            text.append(source);
        } else {
            text.append(source.substring(0, 19)).append("...");
        }
        text.append(" ").append(script.getEndTag());
        return text.toString();
    }

    public String getText(Object element) {
        IParseNode node;
        if (element instanceof CommonOutlineItem && (node = ((CommonOutlineItem)element).getReferenceNode()) instanceof DjangoTemplatesNode) {
            return this.getDisplayText((DjangoTemplatesNode)node);
        }
        return null;
    }
}

