/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.python.pydev.core.log.Log;

public class ExtensionHelper {
    public static Map<String, List<Object>> testingParticipants;
    private static Map<String, IExtension[]> extensionsCache;
    public static final String PYDEV_COMPLETION = "org.python.pydev.pydev_completion";
    public static final String PYDEV_BUILDER = "org.python.pydev.pydev_builder";
    public static final String PYDEV_MODULES_OBSERVER = "org.python.pydev.pydev_modules_observer";
    public static final String PYDEV_VIEW_CREATED_OBSERVER = "org.python.pydev.pydev_view_created_observer";
    public static final String PYDEV_INTERPRETER_OBSERVER = "org.python.pydev.pydev_interpreter_observer";
    public static final String PYDEV_INTERPRETER_NEW_CUSTOM_ENTRIES = "org.python.pydev.pydev_interpreter_new_custom_entries";
    public static final String PYDEV_MANAGER_OBSERVER = "org.python.pydev.pydev_manager_observer";
    public static final String PYDEV_PARSER_OBSERVER = "org.python.pydev.parser.pydev_parser_observer";
    public static final String PYDEV_CTRL_1 = "org.python.pydev.pydev_ctrl_1";
    public static final String PYDEV_SIMPLE_ASSIST = "org.python.pydev.pydev_simpleassist";
    public static final String PYDEV_ORGANIZE_IMPORTS = "org.python.pydev.pydev_organize_imports";
    public static final String PYDEV_REFACTORING = "org.python.pydev.pydev_refactoring";
    public static final String PYDEV_QUICK_OUTLINE = "org.python.pydev.pydev_quick_outline";
    public static final String PYDEV_PYEDIT_LISTENER = "org.python.pydev.pydev_pyedit_listener";
    public static final String PYDEV_PREFERENCES_PROVIDER = "org.python.pydev.pydev_preferences_provider";
    public static final String PYDEV_FORMATTER = "org.python.pydev.pydev_formatter";
    public static final String PYDEV_GLOBALS_BROWSER = "org.python.pydev.pydev_globals_browser";
    public static final String PYDEV_DEBUG_PREFERENCES_PAGE = "org.python.pydev.pydev_debug_preferences_page";
    public static final String PYDEV_HOVER = "org.python.pydev.pydev_hover";
    public static final String PYDEV_INTERPRETER_INFO_BUILDER = "org.python.pydev.pydev_interpreter_info_builder";
    public static final String PYDEV_DEBUG_CONSOLE_INPUT_LISTENER = "org.python.pydev.debug.pydev_debug_console_input_listener";

    static {
        extensionsCache = new HashMap<String, IExtension[]>();
    }

    public static IExtension[] getExtensions(String type) {
        IExtension[] extensions = extensionsCache.get(type);
        if (extensions == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (registry != null) {
                try {
                    IExtensionPoint extensionPoint = registry.getExtensionPoint(type);
                    extensions = extensionPoint.getExtensions();
                    extensionsCache.put(type, extensions);
                }
                catch (Exception e) {
                    Log.log(4, "Error getting extension for:" + type, e);
                    throw new RuntimeException(e);
                }
            } else {
                extensions = new IExtension[]{};
            }
        }
        return extensions;
    }

    public static Object getParticipant(String type, boolean allowOverride) {
        List participants = ExtensionHelper.getParticipants(type);
        if (participants.isEmpty()) {
            return null;
        }
        if (!allowOverride && participants.size() > 1) {
            throw new RuntimeException("More than one participant is registered for type:" + type);
        }
        return participants.get(participants.size() - 1);
    }

    public static List getParticipants(String type) {
        List<Object> list = null;
        if (testingParticipants != null) {
            list = testingParticipants.get(type);
            if (list == null) {
                list = new ArrayList();
            }
            return list;
        }
        list = new ArrayList();
        IExtension[] iExtensionArray = ExtensionHelper.getExtensions(type);
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    list.add(element.createExecutableExtension("class"));
                }
                catch (Exception e) {
                    Log.log(e);
                }
                ++n4;
            }
            ++n2;
        }
        return list;
    }
}

