/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyObject;

class MergeState {
    static final int MAX_MERGE_PENDING = 85;
    static final int MIN_GALLOP = 8;
    static final int MERGESTATE_TEMP_SIZE = 256;
    private PyObject[] a = new PyObject[256];
    private int[] base = new int[85];
    private int[] len = new int[85];
    private PyObject compare;
    private PyObject[] data;
    private int size;
    private int n;

    MergeState(PyObject[] data, int size, PyObject compare) {
        this.data = data;
        this.compare = compare;
        this.size = size;
        this.n = 0;
    }

    public void sort() {
        int localN;
        int nremaining = this.size;
        if (nremaining < 2) {
            return;
        }
        int lo = 0;
        int hi = nremaining;
        int minrun = this.merge_compute_minrun(nremaining);
        boolean[] descending = new boolean[1];
        do {
            localN = this.count_run(lo, hi, descending);
            if (descending[0]) {
                this.reverse_slice(lo, lo + localN);
            }
            if (localN < minrun) {
                int force = nremaining < minrun ? nremaining : minrun;
                this.binarysort(lo, lo + force, lo + localN);
                localN = force;
            }
            this.base[this.n] = lo;
            this.len[this.n] = localN;
            ++this.n;
            this.merge_collapse();
            lo += localN;
        } while ((nremaining -= localN) != 0);
        this.merge_force_collapse();
    }

    public void getmem(int need) {
        if (need <= this.a.length) {
            return;
        }
        this.a = new PyObject[need];
    }

    int count_run(int lo, int hi, boolean[] descending) {
        descending[0] = false;
        if (++lo == hi) {
            return 1;
        }
        int localN = 2;
        if (this.iflt(this.data[lo], this.data[lo - 1])) {
            descending[0] = true;
            ++lo;
            while (lo < hi) {
                if (this.iflt(this.data[lo], this.data[lo - 1])) {
                    ++lo;
                    ++localN;
                    continue;
                }
                break;
            }
        } else {
            ++lo;
            while (lo < hi) {
                if (!this.iflt(this.data[lo], this.data[lo - 1])) {
                    ++lo;
                    ++localN;
                    continue;
                }
                break;
            }
        }
        return localN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void merge_lo(int pa, int na, int pb, int nb) {
        this.getmem(na);
        System.arraycopy(this.data, pa, this.a, 0, na);
        int dest = pa;
        pa = 0;
        this.data[dest++] = this.data[pb++];
        if (--nb == 0) {
            if (na == 0) return;
            System.arraycopy(this.a, pa, this.data, dest, na);
            return;
        }
        if (na == 1) {
            System.arraycopy(this.data, pb, this.data, dest, nb);
            this.data[dest + nb] = this.a[pa];
            return;
        }
        try {
            while (true) {
                int k;
                int acount = 0;
                int bcount = 0;
                while (true) {
                    if ((k = this.iflt(this.data[pb], this.a[pa])) != 0) {
                        this.data[dest++] = this.data[pb++];
                        ++bcount;
                        acount = 0;
                        if (--nb == 0) {
                            return;
                        }
                        if (bcount < 8) continue;
                        break;
                    }
                    this.data[dest++] = this.a[pa++];
                    ++acount;
                    bcount = 0;
                    if (--na == 1) {
                        System.arraycopy(this.data, pb, this.data, dest, nb);
                        this.data[dest + nb] = this.a[pa];
                        na = 0;
                        return;
                    }
                    if (acount >= 8) break;
                }
                do {
                    acount = k = this.gallop_right(this.data[pb], this.a, pa, na, 0);
                    if (k != 0) {
                        System.arraycopy(this.a, pa, this.data, dest, k);
                        dest += k;
                        pa += k;
                        if ((na -= k) == 1) {
                            System.arraycopy(this.data, pb, this.data, dest, nb);
                            this.data[dest + nb] = this.a[pa];
                            na = 0;
                            return;
                        }
                        if (na == 0) {
                            return;
                        }
                    }
                    this.data[dest++] = this.data[pb++];
                    if (--nb == 0) {
                        return;
                    }
                    bcount = k = this.gallop_left(this.a[pa], this.data, pb, nb, 0);
                    if (k != 0) {
                        System.arraycopy(this.data, pb, this.data, dest, k);
                        dest += k;
                        pb += k;
                        if ((nb -= k) == 0) {
                            return;
                        }
                    }
                    this.data[dest++] = this.a[pa++];
                    if (--na != 1) continue;
                    System.arraycopy(this.data, pb, this.data, dest, nb);
                    this.data[dest + nb] = this.a[pa];
                    na = 0;
                    return;
                } while (acount >= 8 || bcount >= 8);
            }
        }
        finally {
            if (na != 0) {
                System.arraycopy(this.a, pa, this.data, dest, na);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void merge_hi(int pa, int na, int pb, int nb) {
        this.getmem(nb);
        int dest = pb + nb - 1;
        int basea = pa;
        System.arraycopy(this.data, pb, this.a, 0, nb);
        pb = nb - 1;
        pa += na - 1;
        this.data[dest--] = this.data[pa--];
        if (--na == 0) {
            if (nb == 0) return;
            System.arraycopy(this.a, 0, this.data, dest - (nb - 1), nb);
            return;
        }
        if (nb == 1) {
            System.arraycopy(this.data, (pa -= na) + 1, this.data, (dest -= na) + 1, na);
            this.data[dest] = this.a[pb];
            return;
        }
        try {
            while (true) {
                int k;
                int acount = 0;
                int bcount = 0;
                while (true) {
                    if ((k = this.iflt(this.a[pb], this.data[pa])) != 0) {
                        this.data[dest--] = this.data[pa--];
                        ++acount;
                        bcount = 0;
                        if (--na == 0) {
                            return;
                        }
                        if (acount < 8) continue;
                        break;
                    }
                    this.data[dest--] = this.a[pb--];
                    ++bcount;
                    acount = 0;
                    if (--nb == 1) {
                        System.arraycopy(this.data, (pa -= na) + 1, this.data, (dest -= na) + 1, na);
                        this.data[dest] = this.a[pb];
                        nb = 0;
                        return;
                    }
                    if (bcount >= 8) break;
                }
                do {
                    k = this.gallop_right(this.a[pb], this.data, basea, na, na - 1);
                    acount = k = na - k;
                    if (k != 0) {
                        System.arraycopy(this.data, (pa -= k) + 1, this.data, (dest -= k) + 1, k);
                        if ((na -= k) == 0) {
                            return;
                        }
                    }
                    this.data[dest--] = this.a[pb--];
                    if (--nb == 1) {
                        System.arraycopy(this.data, (pa -= na) + 1, this.data, (dest -= na) + 1, na);
                        this.data[dest] = this.a[pb];
                        nb = 0;
                        return;
                    }
                    k = this.gallop_left(this.data[pa], this.a, 0, nb, nb - 1);
                    bcount = k = nb - k;
                    if (k != 0) {
                        System.arraycopy(this.a, (pb -= k) + 1, this.data, (dest -= k) + 1, k);
                        if ((nb -= k) == 1) {
                            System.arraycopy(this.data, (pa -= na) + 1, this.data, (dest -= na) + 1, na);
                            this.data[dest] = this.a[pb];
                            nb = 0;
                            return;
                        }
                        if (nb == 0) {
                            return;
                        }
                    }
                    this.data[dest--] = this.data[pa--];
                    if (--na != 0) continue;
                    return;
                } while (acount >= 8 || bcount >= 8);
            }
        }
        finally {
            if (nb != 0) {
                System.arraycopy(this.a, 0, this.data, dest - (nb - 1), nb);
            }
        }
    }

    private int gallop_left(PyObject key, PyObject[] localData, int localA, int localN, int hint) {
        int maxofs;
        int ofs = 1;
        int lastofs = 0;
        if (this.iflt(localData[localA += hint], key)) {
            maxofs = localN - hint;
            while (ofs < maxofs) {
                if (!this.iflt(localData[localA + ofs], key)) break;
                lastofs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxofs;
            }
            if (ofs > maxofs) {
                ofs = maxofs;
            }
            lastofs += hint;
            ofs += hint;
        } else {
            maxofs = hint + 1;
            while (ofs < maxofs) {
                if (this.iflt(localData[localA - ofs], key)) break;
                lastofs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxofs;
            }
            if (ofs > maxofs) {
                ofs = maxofs;
            }
            int k = lastofs;
            lastofs = hint - ofs;
            ofs = hint - k;
        }
        localA -= hint;
        ++lastofs;
        while (lastofs < ofs) {
            int m = lastofs + (ofs - lastofs >> 1);
            if (this.iflt(localData[localA + m], key)) {
                lastofs = m + 1;
                continue;
            }
            ofs = m;
        }
        return ofs;
    }

    private int gallop_right(PyObject key, PyObject[] aData, int localA, int localN, int hint) {
        int maxofs;
        int lastofs = 0;
        int ofs = 1;
        if (this.iflt(key, aData[localA += hint])) {
            maxofs = hint + 1;
            while (ofs < maxofs) {
                if (!this.iflt(key, aData[localA - ofs])) break;
                lastofs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxofs;
            }
            if (ofs > maxofs) {
                ofs = maxofs;
            }
            int k = lastofs;
            lastofs = hint - ofs;
            ofs = hint - k;
        } else {
            maxofs = localN - hint;
            while (ofs < maxofs) {
                if (this.iflt(key, aData[localA + ofs])) break;
                lastofs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxofs;
            }
            if (ofs > maxofs) {
                ofs = maxofs;
            }
            lastofs += hint;
            ofs += hint;
        }
        localA -= hint;
        ++lastofs;
        while (lastofs < ofs) {
            int m = lastofs + (ofs - lastofs >> 1);
            if (this.iflt(key, aData[localA + m])) {
                ofs = m;
                continue;
            }
            lastofs = m + 1;
        }
        return ofs;
    }

    void merge_at(int i) {
        int pa = this.base[i];
        int pb = this.base[i + 1];
        int na = this.len[i];
        int nb = this.len[i + 1];
        if (i == this.n - 3) {
            this.len[i + 1] = this.len[i + 2];
            this.base[i + 1] = this.base[i + 2];
        }
        this.len[i] = na + nb;
        --this.n;
        int k = this.gallop_right(this.data[pb], this.data, pa, na, 0);
        pa += k;
        if ((na -= k) == 0) {
            return;
        }
        if ((nb = this.gallop_left(this.data[pa + na - 1], this.data, pb, nb, nb - 1)) == 0) {
            return;
        }
        if (na <= nb) {
            this.merge_lo(pa, na, pb, nb);
        } else {
            this.merge_hi(pa, na, pb, nb);
        }
    }

    void merge_collapse() {
        while (this.n > 1) {
            int localN = this.n - 2;
            if (localN > 0 && this.len[localN - 1] <= this.len[localN] + this.len[localN + 1]) {
                if (this.len[localN - 1] < this.len[localN + 1]) {
                    --localN;
                }
                this.merge_at(localN);
                continue;
            }
            if (this.len[localN] > this.len[localN + 1]) break;
            this.merge_at(localN);
        }
    }

    void merge_force_collapse() {
        while (this.n > 1) {
            int localN = this.n - 2;
            if (localN > 0 && this.len[localN - 1] < this.len[localN + 1]) {
                --localN;
            }
            this.merge_at(localN);
        }
    }

    int merge_compute_minrun(int localN) {
        int r = 0;
        while (localN >= 64) {
            r |= localN & 1;
            localN >>= 1;
        }
        return localN + r;
    }

    void assert_(boolean expr) {
        if (!expr) {
            throw new RuntimeException("assert");
        }
    }

    private boolean iflt(PyObject x, PyObject y) {
        if (this.compare == null) {
            return x._lt(y).__nonzero__();
        }
        PyObject ret = this.compare.__call__(x, y);
        if (ret instanceof PyInteger) {
            int v = ((PyInteger)ret).getValue();
            return v < 0;
        }
        throw Py.TypeError("comparision function must return int");
    }

    void reverse_slice(int lo, int hi) {
        --hi;
        while (lo < hi) {
            PyObject t = this.data[lo];
            this.data[lo] = this.data[hi];
            this.data[hi] = t;
            ++lo;
            --hi;
        }
    }

    void binarysort(int lo, int hi, int start) {
        if (lo == start) {
            ++start;
        }
        while (start < hi) {
            int p;
            int l = lo;
            int r = start;
            PyObject pivot = this.data[r];
            do {
                if (this.iflt(pivot, this.data[p = l + (r - l >> 1)])) {
                    r = p;
                    continue;
                }
                l = p + 1;
            } while (l < r);
            p = start;
            while (p > l) {
                this.data[p] = this.data[p - 1];
                --p;
            }
            this.data[l] = pivot;
            ++start;
        }
    }
}

