/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyException;
import org.python.core.PyFileDerived;
import org.python.core.PyGetSetDescr;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.PyUnicode;

public class PyFile
extends PyObject {
    public static final String exposed_name = "file";
    public static final Class exposed_base = PyObject.class;
    public String name;
    public String mode;
    public boolean softspace;
    public boolean closed;
    private FileWrapper file;
    private Closer closer;
    private static LinkedList closers = new LinkedList();

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new PyFileCloser());
        }
        catch (SecurityException securityException) {
            Py.writeDebug("PyFile", "Can't register file closer hook");
        }
    }

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        dict.__setitem__("mode", (PyObject)new PyGetSetDescr("mode", PyFile.class, "getMode", null, null));
        dict.__setitem__("name", (PyObject)new PyGetSetDescr("name", PyFile.class, "getName", null, null));
        dict.__setitem__("closed", (PyObject)new PyGetSetDescr("closed", PyFile.class, "getClosed", null, null));
        class Exposed___cmp__
        extends PyBuiltinMethodNarrow {
            Exposed___cmp__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___cmp__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                int ret = ((PyFile)this.self).file___cmp__(arg0);
                if (ret == -2) {
                    throw Py.TypeError("file.__cmp__(x,y) requires y to be 'file', not a '" + arg0.getType().fastGetName() + "'");
                }
                return Py.newInteger(ret);
            }
        }
        dict.__setitem__("__cmp__", (PyObject)new PyMethodDescr("__cmp__", PyFile.class, 1, 1, new Exposed___cmp__(null, null)));
        class Exposed___iter__
        extends PyBuiltinMethodNarrow {
            Exposed___iter__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___iter__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFile)this.self).file___iter__();
            }
        }
        dict.__setitem__("__iter__", (PyObject)new PyMethodDescr("__iter__", PyFile.class, 0, 0, new Exposed___iter__(null, null)));
        class Exposed___iternext__
        extends PyBuiltinMethodNarrow {
            Exposed___iternext__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___iternext__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFile)this.self).file___iternext__();
            }
        }
        dict.__setitem__("__iternext__", (PyObject)new PyMethodDescr("__iternext__", PyFile.class, 0, 0, new Exposed___iternext__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinMethodNarrow {
            Exposed___nonzero__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___nonzero__(self, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(((PyFile)this.self).file___nonzero__());
            }
        }
        dict.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyFile.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___repr__
        extends PyBuiltinMethodNarrow {
            Exposed___repr__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___repr__(self, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyFile)this.self).file_toString());
            }
        }
        dict.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyFile.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinMethodNarrow {
            Exposed___str__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___str__(self, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyFile)this.self).file_toString());
            }
        }
        dict.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyFile.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed_close
        extends PyBuiltinMethodNarrow {
            Exposed_close(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_close(self, this.info);
            }

            public PyObject __call__() {
                ((PyFile)this.self).file_close();
                return Py.None;
            }
        }
        dict.__setitem__("close", (PyObject)new PyMethodDescr("close", PyFile.class, 0, 0, new Exposed_close(null, null)));
        class Exposed_flush
        extends PyBuiltinMethodNarrow {
            Exposed_flush(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_flush(self, this.info);
            }

            public PyObject __call__() {
                ((PyFile)this.self).file_flush();
                return Py.None;
            }
        }
        dict.__setitem__("flush", (PyObject)new PyMethodDescr("flush", PyFile.class, 0, 0, new Exposed_flush(null, null)));
        class Exposed_read
        extends PyBuiltinMethodNarrow {
            Exposed_read(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_read(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                try {
                    return new PyString(((PyFile)this.self).file_read(arg0.asInt(0)));
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }

            public PyObject __call__() {
                return new PyString(((PyFile)this.self).file_read());
            }
        }
        dict.__setitem__("read", (PyObject)new PyMethodDescr("read", PyFile.class, 0, 1, new Exposed_read(null, null)));
        class Exposed_readline
        extends PyBuiltinMethodNarrow {
            Exposed_readline(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_readline(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                try {
                    return new PyString(((PyFile)this.self).file_readline(arg0.asInt(0)));
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }

            public PyObject __call__() {
                return new PyString(((PyFile)this.self).file_readline());
            }
        }
        dict.__setitem__("readline", (PyObject)new PyMethodDescr("readline", PyFile.class, 0, 1, new Exposed_readline(null, null)));
        class Exposed_readlines
        extends PyBuiltinMethodNarrow {
            Exposed_readlines(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_readlines(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                try {
                    return ((PyFile)this.self).file_readlines(arg0.asInt(0));
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }

            public PyObject __call__() {
                return ((PyFile)this.self).file_readlines();
            }
        }
        dict.__setitem__("readlines", (PyObject)new PyMethodDescr("readlines", PyFile.class, 0, 1, new Exposed_readlines(null, null)));
        class Exposed_seek
        extends PyBuiltinMethodNarrow {
            Exposed_seek(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_seek(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                try {
                    ((PyFile)this.self).file_seek(arg0.asLong(0), arg1.asInt(1));
                    return Py.None;
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected a long";
                            break;
                        }
                        case 1: {
                            msg = "expected an integer";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }

            public PyObject __call__(PyObject arg0) {
                try {
                    ((PyFile)this.self).file_seek(arg0.asLong(0));
                    return Py.None;
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected a long";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }
        }
        dict.__setitem__("seek", (PyObject)new PyMethodDescr("seek", PyFile.class, 1, 2, new Exposed_seek(null, null)));
        class Exposed_tell
        extends PyBuiltinMethodNarrow {
            Exposed_tell(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_tell(self, this.info);
            }

            public PyObject __call__() {
                return new PyLong(((PyFile)this.self).file_tell());
            }
        }
        dict.__setitem__("tell", (PyObject)new PyMethodDescr("tell", PyFile.class, 0, 0, new Exposed_tell(null, null)));
        class Exposed_next
        extends PyBuiltinMethodNarrow {
            Exposed_next(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_next(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFile)this.self).file_next();
            }
        }
        dict.__setitem__("next", (PyObject)new PyMethodDescr("next", PyFile.class, 0, 0, new Exposed_next(null, null)));
        class Exposed_truncate
        extends PyBuiltinMethodNarrow {
            Exposed_truncate(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_truncate(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                try {
                    ((PyFile)this.self).file_truncate(arg0.asLong(0));
                    return Py.None;
                }
                catch (PyObject.ConversionException e) {
                    String msg;
                    switch (e.index) {
                        case 0: {
                            msg = "expected a long";
                            break;
                        }
                        default: {
                            msg = "xxx";
                        }
                    }
                    throw Py.TypeError(msg);
                }
            }

            public PyObject __call__() {
                ((PyFile)this.self).file_truncate();
                return Py.None;
            }
        }
        dict.__setitem__("truncate", (PyObject)new PyMethodDescr("truncate", PyFile.class, 0, 1, new Exposed_truncate(null, null)));
        class Exposed_write
        extends PyBuiltinMethodNarrow {
            Exposed_write(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_write(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyFile)this.self).file_write(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("write", (PyObject)new PyMethodDescr("write", PyFile.class, 1, 1, new Exposed_write(null, null)));
        class Exposed_writelines
        extends PyBuiltinMethodNarrow {
            Exposed_writelines(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_writelines(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                ((PyFile)this.self).file_writelines(arg0);
                return Py.None;
            }
        }
        dict.__setitem__("writelines", (PyObject)new PyMethodDescr("writelines", PyFile.class, 1, 1, new Exposed_writelines(null, null)));
        class Exposed_xreadlines
        extends PyBuiltinMethodNarrow {
            Exposed_xreadlines(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_xreadlines(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFile)this.self).file_xreadlines();
            }
        }
        dict.__setitem__("xreadlines", (PyObject)new PyMethodDescr("xreadlines", PyFile.class, 0, 0, new Exposed_xreadlines(null, null)));
        class Exposed___init__
        extends PyBuiltinMethod {
            Exposed___init__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___init__(self, this.info);
            }

            public PyObject __call__(PyObject[] args) {
                return this.__call__(args, Py.NoKeywords);
            }

            public PyObject __call__(PyObject[] args, String[] keywords) {
                ((PyFile)this.self).file_init(args, keywords);
                return Py.None;
            }
        }
        dict.__setitem__("__init__", (PyObject)new PyMethodDescr("__init__", PyFile.class, -1, -1, new Exposed___init__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PyFile.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                PyFile newobj;
                if (this.for_type == subtype) {
                    newobj = null;
                    if (init) {
                        if (args.length == 0) {
                            newobj = new PyFile();
                            newobj.file_init(args, keywords);
                        } else if (args[0] instanceof PyString || args[0] instanceof PyJavaInstance && ((PyJavaInstance)args[0]).javaProxy == String.class) {
                            newobj = new PyFile();
                            newobj.file_init(args, keywords);
                            newobj.closer = new Closer(newobj.file);
                        } else {
                            PyJavaClass pjc = new PyJavaClass(PyFile.class);
                            newobj = (PyFile)pjc.__call__(args, keywords);
                        }
                    } else {
                        newobj = new PyFile();
                    }
                } else {
                    newobj = new PyFileDerived(subtype);
                }
                return newobj;
            }
        });
    }

    private static InputStream _pb(InputStream s, String mode) {
        if (mode.indexOf(98) < 0) {
            if (s instanceof PushbackInputStream) {
                return s;
            }
            return new PushbackInputStream(s);
        }
        return s;
    }

    final void file_init(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser(exposed_name, args, kwds, new String[]{"name", "mode", "bufsize"}, 1);
        String nameArg = ap.getString(0, null);
        String modeArg = ap.getString(1, "r");
        int buffArg = ap.getInt(2, 0);
        this.file_init(PyFile._setup(nameArg, modeArg, buffArg), nameArg, modeArg);
    }

    public PyFile() {
    }

    public PyFile(PyType subType) {
        super(subType);
    }

    public PyFile(FileWrapper file, String name, String mode) {
        this.file_init(file, name, mode);
    }

    private void file_init(FileWrapper file, String name, String mode) {
        file.setMode(mode);
        this.name = name;
        this.mode = mode;
        this.softspace = false;
        this.closed = false;
        this.file = mode.indexOf(98) < 0 ? new TextWrapper(file) : file;
    }

    public PyFile(InputStream istream, OutputStream ostream, String name, String mode) {
        this(new IOStreamWrapper(PyFile._pb(istream, mode), ostream), name, mode);
    }

    public PyFile(InputStream istream, OutputStream ostream, String name) {
        this(istream, ostream, name, "r+");
    }

    public PyFile(InputStream istream, OutputStream ostream) {
        this(istream, ostream, "<???>", "r+");
    }

    public PyFile(InputStream istream, String name, String mode) {
        this(new InputStreamWrapper(PyFile._pb(istream, mode)), name, mode);
    }

    public PyFile(InputStream istream, String name) {
        this(istream, name, "r");
    }

    public PyFile(InputStream istream) {
        this(istream, "<???>", "r");
    }

    public PyFile(OutputStream ostream, String name, String mode) {
        this(new OutputStreamWrapper(ostream), name, mode);
    }

    public PyFile(OutputStream ostream, String name) {
        this(ostream, name, "w");
    }

    public PyFile(OutputStream ostream) {
        this(ostream, "<???>", "w");
    }

    public PyFile(Writer ostream, String name, String mode) {
        this(new WriterWrapper(ostream), name, mode);
    }

    public PyFile(Writer ostream, String name) {
        this(ostream, name, "w");
    }

    public PyFile(Writer ostream) {
        this(ostream, "<???>", "w");
    }

    public PyFile(RandomAccessFile file, String name, String mode) {
        this(new RFileWrapper(file), name, mode);
    }

    public PyFile(RandomAccessFile file, String name) {
        this(file, name, "r+");
    }

    public PyFile(RandomAccessFile file) {
        this(file, "<???>", "r+");
    }

    public PyFile(String name, String mode, int bufsize) {
        this(PyFile._setup(name, mode, bufsize), name, mode);
    }

    public void __setattr__(String name, PyObject value) {
        if (name != "softspace") {
            if (name == "mode" || name == "closed" || name == "name") {
                throw Py.TypeError("readonly attribute: " + name);
            }
            throw Py.AttributeError(name);
        }
        this.softspace = value.__nonzero__();
    }

    public Object __tojava__(Class cls) {
        Object o = null;
        try {
            o = this.file.__tojava__(cls);
        }
        catch (IOException iOException) {}
        if (o == null) {
            o = super.__tojava__(cls);
        }
        return o;
    }

    private static FileWrapper _setup(String name, String mode, int bufsize) {
        int c1 = 32;
        int c2 = 32;
        int c3 = 32;
        int n = mode.length();
        int i = 0;
        while (i < n) {
            if ("awrtb+".indexOf(mode.charAt(i)) < 0) {
                throw Py.IOError("Unknown open mode:" + mode);
            }
            ++i;
        }
        if (n > 0) {
            c1 = mode.charAt(0);
            if (n > 1) {
                c2 = mode.charAt(1);
                if (n > 2) {
                    c3 = mode.charAt(2);
                }
            }
        }
        String jmode = "r";
        if (c1 == 114) {
            jmode = c2 == 43 || c3 == 43 ? "rw" : "r";
        } else if (c1 == 119 || c1 == 97) {
            jmode = "rw";
        }
        try {
            File f = new File(name);
            if (c1 == 114 && !f.exists()) {
                throw new IOException("No such file or directory: " + name);
            }
            if (c1 == 119) {
                FileOutputStream fo = new FileOutputStream(f);
                fo.close();
                fo = null;
            }
            RandomAccessFile rfile = new RandomAccessFile(f, jmode);
            RFileWrapper iofile = new RFileWrapper(rfile);
            if (c1 == 97) {
                iofile.seek(0L, 2);
            }
            return iofile;
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    final String file_read(int n) {
        if (this.closed) {
            this.err_closed();
        }
        StringBuffer data = new StringBuffer();
        try {
            while (n != 0) {
                String s = this.file.read(n);
                int len = s.length();
                if (len != 0) {
                    data.append(s);
                    if (n <= 0 || (n -= len) > 0) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
        return data.toString();
    }

    public String read(int n) {
        return this.file_read(n);
    }

    final String file_read() {
        return this.file_read(-1);
    }

    public String read() {
        return this.file_read();
    }

    final String file_readline(int max) {
        if (this.closed) {
            this.err_closed();
        }
        StringBuffer s = new StringBuffer();
        while (max < 0 || s.length() < max) {
            int c;
            try {
                c = this.file.read();
            }
            catch (IOException e) {
                throw Py.IOError(e);
            }
            if (c < 0) break;
            s.append((char)c);
            if ((char)c == '\n') break;
        }
        return s.toString();
    }

    public String readline(int max) {
        return this.file_readline(max);
    }

    public String readline() {
        return this.file_readline();
    }

    final String file_readline() {
        return this.file_readline(-1);
    }

    final PyObject file_readlines(int sizehint) {
        String s;
        int len;
        if (this.closed) {
            this.err_closed();
        }
        PyList list = new PyList();
        int bytesread = 0;
        while ((len = (s = this.readline()).length()) != 0) {
            list.append(new PyString(s));
            if (sizehint <= 0 || (bytesread += len) <= sizehint) continue;
        }
        return list;
    }

    public PyObject readlines(int sizehint) {
        return this.file_readlines(sizehint);
    }

    final PyObject file_readlines() {
        return this.file_readlines(0);
    }

    public PyObject readlines() {
        return this.file_readlines();
    }

    public PyObject __iter__() {
        return this.file___iter__();
    }

    final PyObject file___iter__() {
        return this;
    }

    public PyObject __iternext__() {
        return this.file___iternext__();
    }

    final PyObject file___iternext__() {
        PyString s = new PyString(this.readline());
        if (s.__len__() == 0) {
            return null;
        }
        return s;
    }

    final PyObject file_next() {
        PyObject ret = this.__iternext__();
        if (ret == null) {
            throw Py.StopIteration("");
        }
        return ret;
    }

    public PyObject next() {
        return this.file_next();
    }

    final PyObject file_xreadlines() {
        return this;
    }

    public PyObject xreadlines() {
        return this.file_xreadlines();
    }

    final void file_write(PyObject o) {
        if (o instanceof PyUnicode) {
            this.file_write(o.__str__().string);
        } else if (o instanceof PyString) {
            this.file_write(((PyString)o).string);
        } else {
            throw Py.TypeError("write requires a string as its argument");
        }
    }

    final void file_write(String s) {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.write(s);
            this.softspace = false;
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void write(String s) {
        this.file_write(s);
    }

    final void file_writelines(PyObject a) {
        PyObject iter = Py.iter(a, "writelines() requires an iterable argument");
        PyObject item = null;
        while ((item = iter.__iternext__()) != null) {
            if (!(item instanceof PyString)) {
                throw Py.TypeError("writelines() argument must be a sequence of strings");
            }
            this.write(item.toString());
        }
    }

    public void writelines(PyObject a) {
        this.file_writelines(a);
    }

    final long file_tell() {
        if (this.closed) {
            this.err_closed();
        }
        try {
            return this.file.tell();
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public long tell() {
        return this.file_tell();
    }

    final void file_seek(long pos, int how) {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.seek(pos, how);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void seek(long pos, int how) {
        this.file_seek(pos, how);
    }

    final void file_seek(long pos) {
        this.seek(pos, 0);
    }

    public void seek(long pos) {
        this.file_seek(pos);
    }

    final void file_flush() {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.flush();
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void flush() {
        this.file_flush();
    }

    final void file_close() {
        if (this.closer != null) {
            this.closer.close();
            this.closer = null;
        } else {
            try {
                this.file.close();
            }
            catch (IOException e) {
                throw Py.IOError(e);
            }
        }
        this.closed = true;
        this.file = new FileWrapper(null, null);
    }

    public void close() {
        this.file_close();
    }

    final void file_truncate() {
        try {
            this.file.truncate(this.file.tell());
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void truncate() {
        this.file_truncate();
    }

    final void file_truncate(long position) {
        try {
            this.file.truncate(position);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void truncate(long position) {
        this.file_truncate(position);
    }

    public PyObject fileno() {
        throw Py.IOError("fileno() is not supported in jython");
    }

    final String file_toString() {
        StringBuffer s = new StringBuffer("<");
        if (this.closed) {
            s.append("closed ");
        } else {
            s.append("open ");
        }
        s.append("file '");
        s.append(this.name);
        s.append("', mode '");
        s.append(this.mode);
        s.append("' ");
        s.append(Py.idstr(this));
        s.append(">");
        return s.toString();
    }

    public String toString() {
        return this.file_toString();
    }

    final int file___cmp__(PyObject o) {
        return super.__cmp__(o);
    }

    final boolean file___nonzero__() {
        return super.__nonzero__();
    }

    private void err_closed() {
        throw Py.ValueError("I/O operation on closed file");
    }

    public String getMode() {
        return this.mode;
    }

    public String getName() {
        return this.name;
    }

    public boolean getClosed() {
        return this.closed;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.closer != null) {
            this.closer.close();
        }
    }

    private static class Closer {
        private FileWrapper fw;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Closer(FileWrapper fw) {
            this.fw = fw;
            LinkedList linkedList = closers;
            synchronized (linkedList) {
                closers.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            LinkedList linkedList = closers;
            synchronized (linkedList) {
                if (!closers.remove(this)) {
                    return;
                }
            }
            this._close();
        }

        public void _close() {
            try {
                try {
                    this.fw.close();
                }
                catch (IOException e) {
                    throw Py.IOError(e);
                }
            }
            finally {
                this.fw = null;
            }
        }
    }

    private static class FileWrapper {
        protected boolean reading;
        protected boolean writing;
        protected boolean binary;

        private FileWrapper() {
        }

        void setMode(String mode) {
            this.reading = mode.indexOf(114) >= 0;
            this.writing = mode.indexOf(119) >= 0 || mode.indexOf("+") >= 0 || mode.indexOf(97) >= 0;
            this.binary = mode.indexOf(98) >= 0;
        }

        public String read(int n) throws IOException {
            throw new IOException("file not open for reading");
        }

        public int read() throws IOException {
            throw new IOException("file not open for reading");
        }

        public int available() throws IOException {
            throw new IOException("file not open for reading");
        }

        public void unread(int c) throws IOException {
            throw new IOException("file doesn't support unread");
        }

        public void write(String s) throws IOException {
            throw new IOException("file not open for writing");
        }

        public long tell() throws IOException {
            throw new IOException("file doesn't support tell/seek");
        }

        public void seek(long pos, int how) throws IOException {
            throw new IOException("file doesn't support tell/seek");
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void truncate(long position) throws IOException {
            throw new IOException("file doesn't support truncate");
        }

        public Object __tojava__(Class cls) throws IOException {
            return null;
        }

        /* synthetic */ FileWrapper(FileWrapper fileWrapper, FileWrapper fileWrapper2) {
            this();
        }
    }

    private static class IOStreamWrapper
    extends InputStreamWrapper {
        private OutputStream ostream;

        public IOStreamWrapper(InputStream istream, OutputStream ostream) {
            super(istream);
            this.ostream = ostream;
        }

        public void write(String s) throws IOException {
            this.ostream.write(PyString.to_bytes(s));
        }

        public void flush() throws IOException {
            this.ostream.flush();
        }

        public void close() throws IOException {
            this.ostream.close();
            this.istream.close();
        }

        public Object __tojava__(Class cls) throws IOException {
            if (OutputStream.class.isAssignableFrom(cls)) {
                return this.ostream;
            }
            return super.__tojava__(cls);
        }
    }

    private static class InputStreamWrapper
    extends FileWrapper {
        InputStream istream;

        public InputStreamWrapper(InputStream s) {
            this.istream = s;
        }

        public String read(int n) throws IOException {
            if (n == 0) {
                return "";
            }
            if (n < 0) {
                byte[] buf = new byte[1024];
                StringBuffer sbuf = new StringBuffer();
                int read = 0;
                while (read >= 0) {
                    sbuf.append(PyString.from_bytes(buf, 0, read));
                    read = this.istream.read(buf);
                }
                return sbuf.toString();
            }
            byte[] buf = new byte[n];
            int read = this.istream.read(buf);
            if (read < 0) {
                return "";
            }
            return PyString.from_bytes(buf, 0, read);
        }

        public int read() throws IOException {
            return this.istream.read();
        }

        public int available() throws IOException {
            return this.istream.available();
        }

        public void unread(int c) throws IOException {
            ((PushbackInputStream)this.istream).unread(c);
        }

        public void close() throws IOException {
            this.istream.close();
        }

        public Object __tojava__(Class cls) throws IOException {
            if (InputStream.class.isAssignableFrom(cls)) {
                return this.istream;
            }
            return null;
        }
    }

    private static class OutputStreamWrapper
    extends FileWrapper {
        private OutputStream ostream;
        private static final int MAX_WRITE = 30000;

        public OutputStreamWrapper(OutputStream s) {
            this.ostream = s;
        }

        public void write(String s) throws IOException {
            byte[] bytes = PyString.to_bytes(s);
            int n = bytes.length;
            int i = 0;
            while (i < n) {
                int sz = n - i;
                sz = sz > 30000 ? 30000 : sz;
                this.ostream.write(bytes, i, sz);
                i += sz;
            }
        }

        public void flush() throws IOException {
            this.ostream.flush();
        }

        public void close() throws IOException {
            this.ostream.close();
        }

        public Object __tojava__(Class cls) throws IOException {
            if (OutputStream.class.isAssignableFrom(cls)) {
                return this.ostream;
            }
            return null;
        }
    }

    private static class PyFileCloser
    extends Thread {
        public PyFileCloser() {
            super("Jython Shutdown File Closer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            LinkedList linkedList = closers;
            synchronized (linkedList) {
                while (true) {
                    if (closers.size() <= 0) {
                        return;
                    }
                    try {
                        ((Closer)closers.removeFirst())._close();
                    }
                    catch (PyException pyException) {}
                }
            }
        }
    }

    private static class RFileWrapper
    extends FileWrapper {
        protected static final int defaultBufferSize = 4096;
        protected RandomAccessFile file;
        protected long filePosition;
        protected byte[] buffer;
        protected long bufferStart;
        protected long dataEnd;
        protected int dataSize;
        protected boolean endOfFile;
        boolean bufferModified = false;

        public RFileWrapper(RandomAccessFile file) {
            this(file, 8092);
        }

        public RFileWrapper(RandomAccessFile file, int bufferSize) {
            this.file = file;
            this.bufferStart = 0L;
            this.dataEnd = 0L;
            this.dataSize = 0;
            this.filePosition = 0L;
            this.buffer = new byte[bufferSize];
            this.endOfFile = false;
        }

        public String read(int n) throws IOException {
            byte[] buf;
            if (n < 0 && (n = (int)(this.file.length() - this.filePosition)) < 0) {
                n = 0;
            }
            if ((n = this.readBytes(buf = new byte[n], 0, n)) < 0) {
                n = 0;
            }
            return PyString.from_bytes(buf, 0, n);
        }

        private int readBytes(byte[] b, int off, int len) throws IOException {
            if (this.endOfFile) {
                return -1;
            }
            int bytesAvailable = (int)(this.dataEnd - this.filePosition);
            if (bytesAvailable < 1) {
                this.seek(this.filePosition, 0);
                return this.readBytes(b, off, len);
            }
            int copyLength = bytesAvailable >= len ? len : bytesAvailable;
            System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), b, off, copyLength);
            this.filePosition += (long)copyLength;
            if (copyLength < len) {
                int extraCopy = len - copyLength;
                if (extraCopy > this.buffer.length) {
                    this.file.seek(this.filePosition);
                    extraCopy = this.file.read(b, off + copyLength, len - copyLength);
                } else {
                    this.seek(this.filePosition, 0);
                    if (!this.endOfFile) {
                        extraCopy = extraCopy > this.dataSize ? this.dataSize : extraCopy;
                        System.arraycopy(this.buffer, 0, b, off + copyLength, extraCopy);
                    } else {
                        extraCopy = -1;
                    }
                }
                if (extraCopy > 0) {
                    this.filePosition += (long)extraCopy;
                    return copyLength + extraCopy;
                }
            }
            return copyLength;
        }

        public int read() throws IOException {
            if (this.filePosition < this.dataEnd) {
                return this.buffer[(int)(this.filePosition++ - this.bufferStart)] & 0xFF;
            }
            if (this.endOfFile) {
                return -1;
            }
            this.seek(this.filePosition, 0);
            return this.read();
        }

        public int available() throws IOException {
            return 1;
        }

        public void unread(int c) throws IOException {
            --this.filePosition;
        }

        public void write(String s) throws IOException {
            byte[] b = PyString.to_bytes(s);
            int len = b.length;
            if (len < this.buffer.length) {
                long myDataEnd;
                int spaceInBuffer = 0;
                int copyLength = 0;
                if (this.filePosition >= this.bufferStart) {
                    spaceInBuffer = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
                }
                if (spaceInBuffer > 0) {
                    copyLength = spaceInBuffer > len ? len : spaceInBuffer;
                    System.arraycopy(b, 0, this.buffer, (int)(this.filePosition - this.bufferStart), copyLength);
                    this.bufferModified = true;
                    myDataEnd = this.filePosition + (long)copyLength;
                    this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)copyLength;
                }
                if (copyLength < len) {
                    this.seek(this.filePosition, 0);
                    System.arraycopy(b, copyLength, this.buffer, (int)(this.filePosition - this.bufferStart), len - copyLength);
                    this.bufferModified = true;
                    myDataEnd = this.filePosition + (long)(len - copyLength);
                    this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)(len - copyLength);
                }
            } else {
                if (this.bufferModified) {
                    this.flush();
                    this.dataSize = 0;
                    this.bufferStart = this.dataEnd = (long)0;
                }
                this.file.write(b, 0, len);
                this.filePosition += (long)len;
            }
        }

        public long tell() throws IOException {
            return this.filePosition;
        }

        public void seek(long pos, int how) throws IOException {
            if (how == 1) {
                pos += this.filePosition;
            } else if (how == 2) {
                pos += this.file.length();
            }
            if (pos < 0L) {
                pos = 0L;
            }
            if (pos >= this.bufferStart && pos < this.dataEnd) {
                this.filePosition = pos;
                this.endOfFile = false;
                return;
            }
            if (this.bufferModified) {
                this.flush();
            }
            this.file.seek(pos);
            this.bufferStart = this.filePosition = this.file.getFilePointer();
            this.dataSize = this.file.read(this.buffer);
            if (this.dataSize < 0) {
                this.dataSize = 0;
                this.endOfFile = true;
            } else {
                this.endOfFile = false;
            }
            this.dataEnd = this.bufferStart + (long)this.dataSize;
        }

        public void flush() throws IOException {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
            this.bufferModified = false;
            this.file.getFD().sync();
        }

        public void close() throws IOException {
            if (this.writing && this.bufferModified) {
                this.file.seek(this.bufferStart);
                this.file.write(this.buffer, 0, this.dataSize);
            }
            this.file.close();
        }

        public void truncate(long position) throws IOException {
            this.flush();
            try {
                Method m = this.file.getClass().getMethod("setLength", Long.TYPE);
                m.invoke((Object)this.file, new Long(position));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                super.truncate(position);
            }
            catch (SecurityException securityException) {
                super.truncate(position);
            }
            catch (IllegalAccessException illegalAccessException) {
                super.truncate(position);
            }
            catch (InvocationTargetException exc) {
                if (exc.getTargetException() instanceof IOException) {
                    throw (IOException)exc.getTargetException();
                }
                super.truncate(position);
            }
        }

        public Object __tojava__(Class cls) throws IOException {
            if (OutputStream.class.isAssignableFrom(cls) && this.writing) {
                return new FileOutputStream(this.file.getFD());
            }
            if (InputStream.class.isAssignableFrom(cls) && this.reading) {
                return new FileInputStream(this.file.getFD());
            }
            return super.__tojava__(cls);
        }
    }

    private static class TextWrapper
    extends FileWrapper {
        private FileWrapper file;
        private String sep;
        private boolean sep_is_nl;

        public TextWrapper(FileWrapper file) {
            this.file = file;
            this.sep = System.getProperty("line.separator");
            this.sep_is_nl = this.sep == "\n";
        }

        public String read(int n) throws IOException {
            int c;
            String s = this.file.read(n);
            int index = s.indexOf(13);
            if (index < 0) {
                return s;
            }
            StringBuffer buf = new StringBuffer();
            int start = 0;
            int end = s.length();
            do {
                buf.append(s.substring(start, index));
                buf.append('\n');
                start = index + 1;
                if (start >= end || s.charAt(start) != '\n') continue;
                ++start;
            } while ((index = s.indexOf(13, start)) >= 0);
            buf.append(s.substring(start));
            if (s.endsWith("\r") && this.file.available() > 0 && (c = this.file.read()) != -1 && c != 10) {
                this.file.unread(c);
            }
            return buf.toString();
        }

        public int read() throws IOException {
            int c = this.file.read();
            if (c != 13) {
                return c;
            }
            if (this.file.available() > 0 && (c = this.file.read()) != -1 && c != 10) {
                this.file.unread(c);
            }
            return 10;
        }

        public void write(String s) throws IOException {
            int index;
            if (!this.sep_is_nl && (index = s.indexOf(10)) >= 0) {
                StringBuffer buf = new StringBuffer();
                int start = 0;
                do {
                    buf.append(s.substring(start, index));
                    buf.append(this.sep);
                } while ((index = s.indexOf(10, start = index + 1)) >= 0);
                buf.append(s.substring(start));
                s = buf.toString();
            }
            this.file.write(s);
        }

        public long tell() throws IOException {
            return this.file.tell();
        }

        public void seek(long pos, int how) throws IOException {
            this.file.seek(pos, how);
        }

        public void flush() throws IOException {
            this.file.flush();
        }

        public void close() throws IOException {
            this.file.close();
        }

        public void truncate(long position) throws IOException {
            this.file.truncate(position);
        }

        public Object __tojava__(Class cls) throws IOException {
            return this.file.__tojava__(cls);
        }
    }

    private static class WriterWrapper
    extends FileWrapper {
        private Writer writer;

        public WriterWrapper(Writer s) {
            this.writer = s;
        }

        public void write(String s) throws IOException {
            this.writer.write(s);
        }

        public void flush() throws IOException {
            this.writer.flush();
        }

        public void close() throws IOException {
            this.writer.close();
        }
    }
}

