/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser;

import org.python.pydev.parser.ParsingThread;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.PyParserManager;

public class ParserScheduler {
    public volatile ParsingThread parsingThread;
    public static final int STATE_WAITING = 0;
    public static final int STATE_PARSE_LATER = 1;
    public static final int STATE_WAITING_FOR_ELAPSE = 2;
    public static final int STATE_DOING_PARSE = 3;
    volatile int state = 0;
    private volatile long timeParseLaterRequested = 0L;
    private volatile long timeLastParse = 0L;
    private volatile PyParser parser;

    public ParserScheduler(PyParser parser) {
        this.parser = parser;
    }

    public void parseNow() {
        this.parseNow(false, new Object[0]);
    }

    public boolean parseNow(boolean force, Object ... argsToReparse) {
        if (!force) {
            if (this.state != 2 && this.state != 3) {
                this.state = 2;
                this.timeLastParse = System.currentTimeMillis();
                this.checkCreateAndStartParsingThread();
            } else {
                boolean created = this.checkCreateAndStartParsingThread();
                if (!created) {
                    this.parsingThread.okToGo = false;
                }
            }
        } else {
            ParsingThread parserThreadLocal = this.parsingThread;
            if (this.state == 3) {
                return false;
            }
            if (parserThreadLocal == null) {
                this.parsingThread = parserThreadLocal = new ParsingThread(this, argsToReparse);
                parserThreadLocal.force = true;
                parserThreadLocal.setPriority(4);
                parserThreadLocal.start();
            } else {
                parserThreadLocal.force = true;
                parserThreadLocal.interrupt();
            }
        }
        return true;
    }

    private boolean checkCreateAndStartParsingThread() {
        ParsingThread p = this.parsingThread;
        if (p == null) {
            p = new ParsingThread(this, new Object[0]);
            p.setPriority(1);
            p.start();
            this.parsingThread = p;
            return true;
        }
        return false;
    }

    public void parseLater() {
        if (this.state != 2 && this.state != 1) {
            this.state = 1;
            this.timeParseLaterRequested = System.currentTimeMillis();
            Thread thread = new Thread(){

                public void run() {
                    try {
                        1.sleep(PyParserManager.getPyParserManager(null).getElapseMillisBeforeAnalysis());
                    }
                    catch (Exception exception) {}
                    if (ParserScheduler.this.state == 1 && ParserScheduler.this.timeLastParse < ParserScheduler.this.timeParseLaterRequested) {
                        ParserScheduler.this.parseNow();
                    }
                }
            };
            thread.setName("ParserScheduler");
            thread.start();
        }
    }

    public void reparseDocument(Object ... argsToReparse) {
        PyParser p = this.parser;
        if (p != null) {
            p.reparseDocument(argsToReparse);
        }
    }

    public void dispose() {
        ParsingThread p = this.parsingThread;
        if (p != null) {
            p.dispose();
        }
        this.parser = null;
    }
}

