/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.jython.ast;

import java.util.Arrays;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;

public final class FunctionDef
extends stmtType {
    public NameTokType name;
    public argumentsType args;
    public stmtType[] body;
    public decoratorsType[] decs;
    public exprType returns;

    public FunctionDef(NameTokType name, argumentsType args, stmtType[] body, decoratorsType[] decs, exprType returns) {
        this.name = name;
        this.args = args;
        this.body = body;
        this.decs = decs;
        this.returns = returns;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.args == null ? 0 : this.args.hashCode());
        result = 31 * result + Arrays.hashCode(this.body);
        result = 31 * result + Arrays.hashCode(this.decs);
        result = 31 * result + (this.returns == null ? 0 : this.returns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionDef other = (FunctionDef)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.args == null ? other.args != null : !this.args.equals(other.args)) {
            return false;
        }
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        if (!Arrays.equals(this.decs, other.decs)) {
            return false;
        }
        return !(this.returns == null ? other.returns != null : !this.returns.equals(other.returns));
    }

    public FunctionDef createCopy() {
        return this.createCopy(true);
    }

    public FunctionDef createCopy(boolean copyComments) {
        commentType commentType2;
        decoratorsType[] new1;
        stmtType[] new0;
        if (this.body != null) {
            new0 = new stmtType[this.body.length];
            int i = 0;
            while (i < this.body.length) {
                new0[i] = (stmtType)(this.body[i] != null ? this.body[i].createCopy(copyComments) : null);
                ++i;
            }
        } else {
            new0 = this.body;
        }
        if (this.decs != null) {
            new1 = new decoratorsType[this.decs.length];
            int i = 0;
            while (i < this.decs.length) {
                new1[i] = this.decs[i] != null ? this.decs[i].createCopy(copyComments) : null;
                ++i;
            }
        } else {
            new1 = this.decs;
        }
        FunctionDef temp = new FunctionDef(this.name != null ? (NameTokType)this.name.createCopy(copyComments) : null, this.args != null ? this.args.createCopy(copyComments) : null, new0, new1, this.returns != null ? (exprType)this.returns.createCopy(copyComments) : null);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsBefore().add(commentType2.createCopy(copyComments));
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (!(o instanceof commentType)) continue;
                commentType2 = (commentType)o;
                temp.getSpecialsAfter().add(commentType2.createCopy(copyComments));
            }
        }
        return temp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FunctionDef[");
        sb.append("name=");
        sb.append(this.dumpThis(this.name));
        sb.append(", ");
        sb.append("args=");
        sb.append(this.dumpThis(this.args));
        sb.append(", ");
        sb.append("body=");
        sb.append(this.dumpThis(this.body));
        sb.append(", ");
        sb.append("decs=");
        sb.append(this.dumpThis(this.decs));
        sb.append(", ");
        sb.append("returns=");
        sb.append(this.dumpThis(this.returns));
        sb.append("]");
        return sb.toString();
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitFunctionDef(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.name != null) {
            this.name.accept(visitor);
        }
        if (this.args != null) {
            this.args.accept(visitor);
        }
        if (this.body != null) {
            i = 0;
            while (i < this.body.length) {
                if (this.body[i] != null) {
                    this.body[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.decs != null) {
            i = 0;
            while (i < this.decs.length) {
                if (this.decs[i] != null) {
                    this.decs[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.returns != null) {
            this.returns.accept(visitor);
        }
    }
}

