/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.dltk.console.codegen;

import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.dltk.console.codegen.IScriptConsoleCodeGenerator;
import org.python.pydev.dltk.console.codegen.PythonSnippetUtils;

public class StructuredSelectionScriptConsoleCodeGenerator
implements IScriptConsoleCodeGenerator {
    private final IStructuredSelection selection;

    public StructuredSelectionScriptConsoleCodeGenerator(IStructuredSelection selection) {
        this.selection = selection;
    }

    private IScriptConsoleCodeGenerator getPyConsoleCodeGenerator(Object node) {
        return PythonSnippetUtils.getScriptConsoleCodeGeneratorAdapter(node);
    }

    private boolean hasPyCode(Object node) {
        IScriptConsoleCodeGenerator generator = this.getPyConsoleCodeGenerator(node);
        if (generator == null) {
            return false;
        }
        return generator.hasPyCode();
    }

    private String getPyCode(Object node) {
        IScriptConsoleCodeGenerator generator = this.getPyConsoleCodeGenerator(node);
        if (generator == null) {
            return null;
        }
        if (!generator.hasPyCode()) {
            return null;
        }
        return generator.getPyCode();
    }

    public String getPyCode() {
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = this.selection;
            if (iStructuredSelection.isEmpty()) {
                return null;
            }
            List list = iStructuredSelection.toList();
            if (list.size() == 1) {
                return this.getPyCode(list.get(0));
            }
            FastStringBuffer sb = new FastStringBuffer();
            sb.append("(");
            for (Object object : list) {
                String pyCode = this.getPyCode(object);
                if (pyCode == null || pyCode.length() == 0) {
                    return null;
                }
                sb.append(pyCode);
                sb.append(", ");
            }
            if (sb.endsWith(", ")) {
                sb.deleteLastChars(2);
            }
            sb.append(")");
            return sb.toString();
        }
        return null;
    }

    public boolean hasPyCode() {
        if (this.selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = this.selection;
            if (iStructuredSelection.isEmpty()) {
                return false;
            }
            List list = iStructuredSelection.toList();
            for (Object object : list) {
                if (this.hasPyCode(object)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

