/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.dltk.console.ui.internal;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.python.pydev.dltk.console.ui.ScriptConsole;
import org.python.pydev.dltk.console.ui.internal.IScriptConsoleContentHandler;
import org.python.pydev.dltk.console.ui.internal.ScriptConsoleMessages;
import org.python.pydev.dltk.console.ui.internal.ScriptConsoleViewer;
import org.python.pydev.dltk.console.ui.internal.actions.CloseScriptConsoleAction;
import org.python.pydev.dltk.console.ui.internal.actions.LinkWithDebugSelectionAction;
import org.python.pydev.dltk.console.ui.internal.actions.SaveConsoleSessionAction;

public class ScriptConsolePage
extends TextConsolePage
implements IScriptConsoleContentHandler {
    public static final String SCRIPT_GROUP = "scriptGroup";
    private SourceViewerConfiguration cfg;
    private ScriptConsoleViewer viewer;
    private TextViewerAction proposalsAction;
    private TextViewerAction quickAssistAction;
    private SaveConsoleSessionAction saveSessionAction;
    private CloseScriptConsoleAction closeConsoleAction;
    private LinkWithDebugSelectionAction linkWithDebugSelectionAction;

    protected void createActions() {
        super.createActions();
        this.proposalsAction = new ContentAssistProposalsAction((ITextViewer)this.getViewer());
        this.quickAssistAction = new QuickAssistProposalsAction((ITextViewer)this.getViewer());
        this.saveSessionAction = new SaveConsoleSessionAction((ScriptConsole)this.getConsole(), ScriptConsoleMessages.SaveSessionAction, ScriptConsoleMessages.SaveSessionTooltip);
        this.closeConsoleAction = new CloseScriptConsoleAction((ScriptConsole)this.getConsole(), ScriptConsoleMessages.TerminateConsoleAction, ScriptConsoleMessages.TerminateConsoleTooltip);
        IActionBars bars = this.getSite().getActionBars();
        IToolBarManager toolbarManager = bars.getToolBarManager();
        toolbarManager.prependToGroup("launchGroup", (IContributionItem)new GroupMarker(SCRIPT_GROUP));
        toolbarManager.appendToGroup(SCRIPT_GROUP, (IContributionItem)new Separator());
        toolbarManager.appendToGroup(SCRIPT_GROUP, (IAction)this.closeConsoleAction);
        toolbarManager.appendToGroup(SCRIPT_GROUP, (IAction)this.saveSessionAction);
        if (this.getConsole().getType().contains("PydevDebugConsole")) {
            this.linkWithDebugSelectionAction = new LinkWithDebugSelectionAction((ScriptConsole)this.getConsole(), ScriptConsoleMessages.LinkWithDebugAction, ScriptConsoleMessages.LinkWithDebugToolTip);
            toolbarManager.appendToGroup(SCRIPT_GROUP, (IAction)this.linkWithDebugSelectionAction);
        }
        bars.updateActionBars();
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        super.contextMenuAboutToShow(menuManager);
        menuManager.add((IContributionItem)new Separator(SCRIPT_GROUP));
        menuManager.appendToGroup(SCRIPT_GROUP, (IAction)this.saveSessionAction);
        menuManager.appendToGroup(SCRIPT_GROUP, (IAction)this.closeConsoleAction);
    }

    protected TextConsoleViewer createViewer(Composite parent) {
        ScriptConsole console = (ScriptConsole)this.getConsole();
        this.viewer = new ScriptConsoleViewer(parent, console, this, console.createStyleProvider(), console.getInitialCommands(), console.getFocusOnStart());
        this.viewer.configure(this.cfg);
        return this.viewer;
    }

    public ScriptConsolePage(ScriptConsole console, IConsoleView view, SourceViewerConfiguration cfg) {
        super((TextConsole)console, view);
        this.cfg = cfg;
    }

    public void clearConsolePage() {
        this.viewer.clear(false);
    }

    public void contentAssistRequired() {
        this.proposalsAction.run();
    }

    public void quickAssistRequired() {
        this.quickAssistAction.run();
    }

    protected class ContentAssistProposalsAction
    extends TextViewerAction {
        public ContentAssistProposalsAction(ITextViewer viewer) {
            super(viewer, 13);
        }
    }

    protected class QuickAssistProposalsAction
    extends TextViewerAction {
        public QuickAssistProposalsAction(ITextViewer viewer) {
            super(viewer, 22);
        }
    }
}

