/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.lang.ref.WeakReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.IPyEditListener;
import org.python.pydev.editor.IPyEditListener3;
import org.python.pydev.editor.IPyEditListener4;
import org.python.pydev.editor.PyEdit;

public class PyEditNotifier {
    private WeakReference<PyEdit> pyEdit;

    public PyEditNotifier(PyEdit edit) {
        this.pyEdit = new WeakReference<PyEdit>(edit);
    }

    public void notifyOnCreateActions(final PyEdit.MyResources resources) {
        final PyEdit edit = (PyEdit)this.pyEdit.get();
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                for (IPyEditListener listener : edit.getAllListeners()) {
                    try {
                        if (monitor.isCanceled()) continue;
                        listener.onCreateActions(resources, edit, monitor);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        };
        this.runIt(runnable);
    }

    public void notifyOnSave() {
        final PyEdit edit = (PyEdit)this.pyEdit.get();
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                for (IPyEditListener listener : edit.getAllListeners()) {
                    try {
                        if (monitor.isCanceled()) continue;
                        listener.onSave(edit, monitor);
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        };
        this.runIt(runnable);
    }

    private void runIt(final INotifierRunnable runnable) {
        Job job = new Job("PyEditNotifier"){

            protected IStatus run(IProgressMonitor monitor) {
                runnable.run(monitor);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
    }

    public void notifyOnDispose() {
        final PyEdit edit = (PyEdit)this.pyEdit.get();
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                for (IPyEditListener listener : edit.getAllListeners()) {
                    try {
                        if (monitor.isCanceled()) continue;
                        listener.onDispose(edit, monitor);
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        this.runIt(runnable);
    }

    public void notifyOnSetDocument(final IDocument document) {
        final PyEdit edit = (PyEdit)this.pyEdit.get();
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                for (IPyEditListener listener : edit.getAllListeners()) {
                    try {
                        if (monitor.isCanceled()) continue;
                        listener.onSetDocument(document, edit, monitor);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        };
        this.runIt(runnable);
    }

    public void notifyInputChanged(final IEditorInput oldInput, final IEditorInput input) {
        final PyEdit edit = (PyEdit)this.pyEdit.get();
        if (edit == null) {
            return;
        }
        INotifierRunnable runnable = new INotifierRunnable(){

            public void run(IProgressMonitor monitor) {
                for (IPyEditListener listener : edit.getAllListeners()) {
                    if (!(listener instanceof IPyEditListener3)) continue;
                    IPyEditListener3 pyEditListener3 = (IPyEditListener3)((Object)listener);
                    try {
                        if (monitor.isCanceled()) continue;
                        pyEditListener3.onInputChanged(edit, oldInput, input, monitor);
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
            }
        };
        this.runIt(runnable);
    }

    public void notifyEditorCreated() {
        PyEdit edit = (PyEdit)this.pyEdit.get();
        if (edit == null) {
            return;
        }
        for (IPyEditListener listener : edit.getAllListeners(false)) {
            if (!(listener instanceof IPyEditListener4)) continue;
            IPyEditListener4 pyEditListener4 = (IPyEditListener4)((Object)listener);
            try {
                pyEditListener4.onEditorCreated(edit);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    public static interface INotifierRunnable {
        public void run(IProgressMonitor var1);
    }
}

