/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PyAction
extends Action
implements IEditorActionDelegate {
    protected volatile IEditorPart targetEditor;

    protected PyAction() {
    }

    protected PyAction(String text, int style) {
        super(text, style);
    }

    public static Shell getShell() {
        IWorkbenchWindow activeWorkbenchWindow = PyAction.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            Log.log((String)"Error. Not currently with thread access (so, there is no activeWorkbenchWindow available)");
            return null;
        }
        return activeWorkbenchWindow.getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        return activeWorkbenchWindow;
    }

    public void setEditor(IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setEditor(targetEditor);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }

    public static String getDelimiter(IDocument doc) {
        return PySelection.getDelimiter((IDocument)doc);
    }

    protected ITextEditor getTextEditor() {
        if (this.targetEditor instanceof ITextEditor) {
            return (ITextEditor)this.targetEditor;
        }
        throw new RuntimeException("Expecting text editor. Found:" + this.targetEditor.getClass().getName());
    }

    protected PyEdit getPyEdit() {
        if (this.targetEditor instanceof PyEdit) {
            return (PyEdit)this.targetEditor;
        }
        throw new RuntimeException("Expecting PyEdit editor. Found:" + this.targetEditor.getClass().getName());
    }

    protected boolean canModifyEditor() {
        ITextEditor editor = this.getTextEditor();
        if (editor instanceof ITextEditorExtension2) {
            return ((ITextEditorExtension2)editor).isEditorInputModifiable();
        }
        if (editor instanceof ITextEditorExtension) {
            return !((ITextEditorExtension)editor).isEditorInputReadOnly();
        }
        if (editor != null) {
            return editor.isEditable();
        }
        return true;
    }

    protected void setCaretPosition(int pos) throws BadLocationException {
        this.getTextEditor().selectAndReveal(pos, 0);
    }

    protected void isInFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            IRegion region = doc.getLineInformationOfOffset(cursorOffset);
            int offset = region.getOffset();
            String src = doc.get(offset, region.getLength());
            if ("".equals(src)) {
                return;
            }
            int i = 0;
            while (i < src.length()) {
                if (!Character.isWhitespace(src.charAt(i))) break;
                ++i;
            }
            this.setCaretPosition(offset + i - 1);
        }
        catch (BadLocationException e) {
            PyAction.beep((Exception)((Object)e));
            return;
        }
    }

    protected int getLastCharPosition(IDocument doc, int cursorOffset) throws BadLocationException {
        IRegion region = doc.getLineInformationOfOffset(cursorOffset);
        int offset = region.getOffset();
        String src = doc.get(offset, region.getLength());
        int i = src.length();
        boolean breaked = false;
        while (i > 0) {
            if (Character.isWhitespace(src.charAt(--i)) || src.charAt(i) == '\t') continue;
            breaked = true;
            break;
        }
        if (!breaked) {
            --i;
        }
        return offset + i;
    }

    protected void gotoFirstChar(IDocument doc, int cursorOffset) {
        try {
            IRegion region = doc.getLineInformationOfOffset(cursorOffset);
            int offset = region.getOffset();
            this.setCaretPosition(offset);
        }
        catch (BadLocationException e) {
            PyAction.beep((Exception)((Object)e));
        }
    }

    protected void gotoFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            this.setCaretPosition(PySelection.getFirstCharPosition((IDocument)doc, (int)cursorOffset));
        }
        catch (BadLocationException e) {
            PyAction.beep((Exception)((Object)e));
        }
    }

    protected boolean isAtFirstVisibleChar(IDocument doc, int cursorOffset) {
        try {
            return PySelection.getFirstCharPosition((IDocument)doc, (int)cursorOffset) == cursorOffset;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected static void beep(Exception e) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().beep();
        }
        catch (IllegalStateException illegalStateException) {}
        Log.log((Throwable)e);
    }

    public static String getLineWithoutComments(String sel) {
        return sel.replaceAll("#.*", "");
    }

    public static String getLineWithoutComments(PySelection ps) {
        return PyAction.getLineWithoutComments(ps.getCursorLineContents());
    }

    public static int countChars(char c, String line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static int countChars(char c, StringBuffer line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static int countChars(char c, FastStringBuffer line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static String lowerChar(String s, int pos) {
        char[] ds = s.toCharArray();
        ds[pos] = Character.toLowerCase(ds[pos]);
        return new String(ds);
    }

    public static boolean stillInTok(String string, int j) {
        char c = string.charAt(j);
        return c != '\n' && c != '\r' && c != ' ' && c != '.' && c != '(' && c != ')' && c != ',' && c != ']' && c != '[' && c != '#';
    }

    protected void revealSelEndLine(PySelection ps) {
        int docLen = ps.getDoc().getLength() - 1;
        IRegion endLine = ps.getEndLine();
        if (endLine != null) {
            int curOffset = endLine.getOffset();
            this.getTextEditor().selectAndReveal(curOffset < docLen ? curOffset : docLen, 0);
        }
    }

    public static Set<IFile> getOpenFiles() {
        HashSet<IFile> ret = new HashSet<IFile>();
        IWorkbenchWindow activeWorkbenchWindow = PyAction.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return ret;
        }
        IWorkbenchPage[] pages = activeWorkbenchWindow.getPages();
        int i = 0;
        while (i < pages.length) {
            IEditorReference[] editorReferences = pages[i].getEditorReferences();
            int j = 0;
            while (j < editorReferences.length) {
                IEditorReference iEditorReference = editorReferences[j];
                if ("org.python.pydev.editor.PythonEditor".equals(iEditorReference.getId())) {
                    try {
                        IFile file;
                        IEditorInput editorInput = iEditorReference.getEditorInput();
                        if (editorInput != null && (file = (IFile)editorInput.getAdapter(IFile.class)) != null) {
                            ret.add(file);
                        }
                    }
                    catch (Exception e1) {
                        Log.log((Throwable)e1);
                    }
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

