/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.PyScopeSelection;

public class PyScopeDeselection
extends PyAction {
    public void run(IAction action) {
        try {
            PyEdit pyEdit = this.getPyEdit();
            FastStack<IRegion> stack = PyScopeSelection.getCache(pyEdit);
            ITextSelection selection = (ITextSelection)pyEdit.getSelectionProvider().getSelection();
            Region region = new Region(selection.getOffset(), selection.getLength());
            Iterator it = stack.topDownIterator();
            while (it.hasNext()) {
                IRegion iRegion = (IRegion)it.next();
                stack.pop();
                if (!iRegion.equals(region)) continue;
                if (stack.size() > 0) {
                    IRegion peek = (IRegion)stack.peek();
                    pyEdit.setSelection(peek.getOffset(), peek.getLength());
                }
                break;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }
}

