/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.visitors;

import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.editor.codecompletion.revisited.visitors.LocalScope;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.NodeUtils;

public class FindScopeVisitor
extends AbstractVisitor {
    protected FastStack<SimpleNode> stackScope = new FastStack(20);
    public ILocalScope scope = new LocalScope((FastStack<SimpleNode>)new FastStack(20));
    protected boolean found = false;
    private int line;
    private int col;

    protected FindScopeVisitor() {
    }

    public FindScopeVisitor(int line, int col) {
        this.line = line;
        this.col = col;
    }

    protected Object unhandled_node(SimpleNode node) throws Exception {
        if (!this.found && !(node instanceof Module)) {
            if (this.line <= node.beginLine) {
                this.found = true;
                int original = this.scope.getIfMainLine();
                this.scope = new LocalScope((FastStack<SimpleNode>)this.stackScope.createCopy());
                this.scope.setIfMainLine(original);
            }
        } else if (this.scope.getScopeEndLine() == -1 && this.line < node.beginLine && this.col >= node.beginColumn) {
            this.scope.setScopeEndLine(node.beginLine);
        }
        return node;
    }

    public void traverse(SimpleNode node) throws Exception {
        node.traverse((VisitorIF)this);
    }

    public Object visitIf(If node) throws Exception {
        this.checkIfMainNode(node);
        return super.visitIf(node);
    }

    protected void checkIfMainNode(If node) {
        boolean isIfMainNode = NodeUtils.isIfMAinNode((If)node);
        if (isIfMainNode) {
            this.scope.setIfMainLine(node.beginLine);
        }
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        if (!this.found) {
            this.stackScope.push((Object)node);
            node.traverse((VisitorIF)this);
            this.stackScope.pop();
        }
        return null;
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        if (!this.found) {
            this.stackScope.push((Object)node);
            node.traverse((VisitorIF)this);
            this.stackScope.pop();
        }
        return null;
    }

    public Object visitModule(Module node) throws Exception {
        this.stackScope.push((Object)node);
        return super.visitModule(node);
    }
}

