/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.preferences;

import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.RunInUiThread;
import org.python.pydev.editor.StyledTextForShowingCodeFactory;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.AbstractPydevPrefs;
import org.python.pydev.plugin.preferences.ColorEditor;
import org.python.pydev.plugin.preferences.IPydevPreferencesProvider;
import org.python.pydev.plugin.preferences.IPydevPreferencesProvider2;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.utils.LinkFieldEditor;

public class PydevEditorPrefs
extends AbstractPydevPrefs {
    private StyledText labelExample;
    private final IPreferenceStore localStore;
    private StyledTextForShowingCodeFactory formatAndStyleRangeHelper;
    private IPropertyChangeListener updateLabelExampleOnPrefsChanges;

    public PydevEditorPrefs() {
        this.setDescription("PyDev editor appearance settings:\nNote: Pydev ignores the 'Insert spaces for tabs' in the general settings.");
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = this.createOverlayStore();
        this.localStore = new PreferenceStore();
    }

    protected Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        this.addTextField(appearanceComposite, "Tab length:", "TAB_WIDTH", 3, 0, true);
        this.addCheckBox(appearanceComposite, "Replace tabs with spaces when typing?", "SUBSTITUTE_TABS", 0);
        this.addCheckBox(appearanceComposite, "Assume tab spacing when files contain tabs?", "GUESS_TAB_SUBSTITUTION", 0);
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_preferences_provider");
        boolean handledColorOptions = false;
        for (IPydevPreferencesProvider iPydevPreferencesProvider : participants) {
            if (!(iPydevPreferencesProvider instanceof IPydevPreferencesProvider2) || !((IPydevPreferencesProvider2)((Object)iPydevPreferencesProvider)).createColorOptions(appearanceComposite, this)) continue;
            handledColorOptions = true;
            break;
        }
        if (!handledColorOptions) {
            this.createColorOptions(appearanceComposite);
        }
        this.formatAndStyleRangeHelper = new StyledTextForShowingCodeFactory();
        this.labelExample = this.formatAndStyleRangeHelper.createStyledTextForCodePresentation(appearanceComposite);
        this.updateLabelExample(PyFormatStd.getFormat(), PydevPrefs.getChainedPrefStore());
        LinkFieldEditor colorsAndFontsLinkFieldEditor = new LinkFieldEditor("UNUSED", "Other settings:\n\n<a>Text Editors</a>: print margin, line numbers ...", appearanceComposite, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.eclipse.ui.preferencePages.GeneralTextEditor";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)PydevEditorPrefs.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        colorsAndFontsLinkFieldEditor.getLinkControl(appearanceComposite);
        colorsAndFontsLinkFieldEditor = new LinkFieldEditor("UNUSED", "<a>Colors and Fonts</a>: text font, content assist color ...", appearanceComposite, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.eclipse.ui.preferencePages.ColorsAndFonts";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)PydevEditorPrefs.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        colorsAndFontsLinkFieldEditor.getLinkControl(appearanceComposite);
        colorsAndFontsLinkFieldEditor = new LinkFieldEditor("UNUSED", "<a>Annotations</a>: occurrences, markers ...", appearanceComposite, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.eclipse.ui.editors.preferencePages.Annotations";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)PydevEditorPrefs.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        colorsAndFontsLinkFieldEditor.getLinkControl(appearanceComposite);
        return appearanceComposite;
    }

    private void createColorOptions(Composite appearanceComposite) {
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText("Appearance color options:");
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new org.eclipse.swt.widgets.List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText("Color:");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        SelectionListener colorDefaultSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean systemDefault = PydevEditorPrefs.this.fAppearanceColorDefault.getSelection();
                PydevEditorPrefs.this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
                int i = PydevEditorPrefs.this.fAppearanceColorList.getSelectionIndex();
                String key = PydevEditorPrefs.this.fAppearanceColorListModel[i][2];
                if (key != null) {
                    PydevEditorPrefs.this.fOverlayStore.setValue(key, systemDefault);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fAppearanceColorDefault = new Button(stylesComposite, 32);
        this.fAppearanceColorDefault.setText("System default");
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fAppearanceColorDefault.setLayoutData((Object)gd);
        this.fAppearanceColorDefault.setVisible(false);
        this.fAppearanceColorDefault.addSelectionListener(colorDefaultSelectionListener);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PydevEditorPrefs.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = PydevEditorPrefs.this.fAppearanceColorList.getSelectionIndex();
                String key = PydevEditorPrefs.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)PydevEditorPrefs.this.fOverlayStore, (String)key, (RGB)PydevEditorPrefs.this.fAppearanceColorEditor.getColorValue());
                PydevEditorPrefs.this.onAppearanceRelatedPreferenceChanged();
            }
        });
        this.fFontBoldCheckBox = this.addStyleCheckBox(stylesComposite, "Bold");
        this.fFontItalicCheckBox = this.addStyleCheckBox(stylesComposite, "Italic");
    }

    public void updateLabelExample(PyFormatStd.FormatStd formatStd, IPreferenceStore store) {
        if (this.labelExample != null && !this.labelExample.isDisposed()) {
            String str = "class Example(object):\n\n    backquotes = `backquotes`\n\n    @memoize(size=10)\n    def Call(self, param1=None):\n        '''docstring'''\n        return param1 + 10 * 10\n\n    def Call2(self):\n        #Comment\n        return self.Call(param1=10)";
            Tuple<String, StyleRange[]> result = this.formatAndStyleRangeHelper.formatAndGetStyleRanges(formatStd, str, store, false);
            this.labelExample.setText((String)result.o1);
            this.labelExample.setStyleRanges((StyleRange[])result.o2);
        }
    }

    protected void onAppearanceRelatedPreferenceChanged() {
        this.localStore.setValue("KEYWORD_COLOR", this.fOverlayStore.getString("KEYWORD_COLOR"));
        this.localStore.setValue("SELF_COLOR", this.fOverlayStore.getString("SELF_COLOR"));
        this.localStore.setValue("CODE_COLOR", this.fOverlayStore.getString("CODE_COLOR"));
        this.localStore.setValue("DECORATOR_COLOR", this.fOverlayStore.getString("DECORATOR_COLOR"));
        this.localStore.setValue("NUMBER_COLOR", this.fOverlayStore.getString("NUMBER_COLOR"));
        this.localStore.setValue("FUNC_NAME_COLOR", this.fOverlayStore.getString("FUNC_NAME_COLOR"));
        this.localStore.setValue("CLASS_NAME_COLOR", this.fOverlayStore.getString("CLASS_NAME_COLOR"));
        this.localStore.setValue("STRING_COLOR", this.fOverlayStore.getString("STRING_COLOR"));
        this.localStore.setValue("COMMENT_COLOR", this.fOverlayStore.getString("COMMENT_COLOR"));
        this.localStore.setValue("BACKQUOTES_COLOR", this.fOverlayStore.getString("BACKQUOTES_COLOR"));
        this.localStore.setValue("PARENS_COLOR", this.fOverlayStore.getString("PARENS_COLOR"));
        this.localStore.setValue("OPERATORS_COLOR", this.fOverlayStore.getString("OPERATORS_COLOR"));
        this.localStore.setValue("KEYWORD_STYLE", this.fOverlayStore.getInt("KEYWORD_STYLE"));
        this.localStore.setValue("SELF_STYLE", this.fOverlayStore.getInt("SELF_STYLE"));
        this.localStore.setValue("CODE_STYLE", this.fOverlayStore.getInt("CODE_STYLE"));
        this.localStore.setValue("DECORATOR_STYLE", this.fOverlayStore.getInt("DECORATOR_STYLE"));
        this.localStore.setValue("NUMBER_STYLE", this.fOverlayStore.getInt("NUMBER_STYLE"));
        this.localStore.setValue("FUNC_NAME_STYLE", this.fOverlayStore.getInt("FUNC_NAME_STYLE"));
        this.localStore.setValue("CLASS_NAME_STYLE", this.fOverlayStore.getInt("CLASS_NAME_STYLE"));
        this.localStore.setValue("STRING_STYLE", this.fOverlayStore.getInt("STRING_STYLE"));
        this.localStore.setValue("COMMENT_STYLE", this.fOverlayStore.getInt("COMMENT_STYLE"));
        this.localStore.setValue("BACKQUOTES_STYLE", this.fOverlayStore.getInt("BACKQUOTES_STYLE"));
        this.localStore.setValue("PARENS_STYLE", this.fOverlayStore.getInt("PARENS_STYLE"));
        this.localStore.setValue("OPERATORS_STYLE", this.fOverlayStore.getInt("OPERATORS_STYLE"));
        this.updateLabelExample(PyFormatStd.getFormat(), this.localStore);
    }

    public void dispose() {
        super.dispose();
        if (this.formatAndStyleRangeHelper != null) {
            this.formatAndStyleRangeHelper.dispose();
            this.formatAndStyleRangeHelper = null;
        }
        if (this.updateLabelExampleOnPrefsChanges != null) {
            PydevPrefs.getChainedPrefStore().removePropertyChangeListener(this.updateLabelExampleOnPrefsChanges);
            this.updateLabelExampleOnPrefsChanges = null;
        }
        if (this.labelExample != null) {
            try {
                this.labelExample.dispose();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            this.labelExample = null;
        }
    }

    public void setUpdateLabelExampleOnPrefsChanges() {
        this.updateLabelExampleOnPrefsChanges = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                RunInUiThread.async((Runnable)new Runnable(){

                    public void run() {
                        PydevEditorPrefs.this.updateLabelExample(PyFormatStd.getFormat(), PydevPrefs.getChainedPrefStore());
                    }
                });
            }
        };
        PydevPrefs.getChainedPrefStore().addPropertyChangeListener(this.updateLabelExampleOnPrefsChanges);
    }
}

