/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.core.log.Log;

public abstract class ColorCache {
    private Map<RGB, Color> fColorTable = new HashMap<RGB, Color>();
    private Map<String, Color> fNamedColorTable = new HashMap<String, Color>();
    protected IPreferenceStore preferences;

    public ColorCache(IPreferenceStore prefs) {
        this.preferences = prefs;
    }

    public void dispose() {
        Iterator<Color> it = this.fColorTable.values().iterator();
        while (it.hasNext()) {
            it.next().dispose();
        }
        it = this.fNamedColorTable.values().iterator();
        while (it.hasNext()) {
            it.next().dispose();
        }
        this.fColorTable.clear();
        this.fNamedColorTable.clear();
    }

    public Color getColor(String name) {
        return this.getNamedColor(name);
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    protected Color getNamedColor(String name) {
        Color color = this.fNamedColorTable.get(name);
        if (color == null) {
            String colorCode = this.preferences.getString(name);
            if (colorCode.length() == 0) {
                if (name.equals("RED")) {
                    color = this.getColor(new RGB(255, 0, 0));
                } else if (name.equals("BLACK")) {
                    color = this.getColor(new RGB(0, 0, 0));
                } else if (name.equals("WHITE")) {
                    color = this.getColor(new RGB(255, 255, 255));
                } else {
                    Log.log((String)("Unknown color:" + name));
                    color = this.getColor(new RGB(255, 0, 0));
                }
            } else {
                try {
                    RGB rgb = StringConverter.asRGB((String)colorCode);
                    color = new Color((Device)Display.getCurrent(), rgb);
                    this.fNamedColorTable.put(name, color);
                }
                catch (DataFormatException e) {
                    Log.log((Throwable)e);
                    color = new Color((Device)Display.getCurrent(), new RGB(255, 50, 0));
                }
            }
        }
        return color;
    }

    public void reloadNamedColor(String name) {
        if (this.fNamedColorTable.containsKey(name)) {
            this.fNamedColorTable.get(name).dispose();
            this.fNamedColorTable.remove(name);
        }
    }

    public void setPreferences(IPreferenceStore prefs) {
        this.dispose();
        this.preferences = prefs;
    }
}

