/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.interpreters;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.runners.SimpleIronpythonRunner;
import org.python.pydev.ui.interpreters.AbstractInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IronpythonInterpreterManager
extends AbstractInterpreterManager {
    public IronpythonInterpreterManager(IPreferenceStore prefs) {
        super(prefs);
    }

    @Override
    protected String getPreferenceName() {
        return "IRONPYTHON_INTERPRETER_PATH";
    }

    @Override
    public String getInterpreterUIName() {
        return "IronPython.";
    }

    @Override
    public Tuple<InterpreterInfo, String> internalCreateInterpreterInfo(String executable, IProgressMonitor monitor, boolean askUser) throws CoreException {
        return IronpythonInterpreterManager.doCreateInterpreterInfo(executable, monitor, askUser);
    }

    @Override
    protected String getPreferencesPageId() {
        return "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPageIronpython";
    }

    public static Tuple<InterpreterInfo, String> doCreateInterpreterInfo(String executable, IProgressMonitor monitor, boolean askUser) throws CoreException {
        boolean isJythonExecutable = InterpreterInfo.isJythonExecutable(executable);
        if (isJythonExecutable) {
            throw new RuntimeException("A jar cannot be used in order to get the info for the iron python interpreter.");
        }
        File script = IronpythonInterpreterManager.getInterpreterInfoPy();
        Tuple<String, String> outTup = new SimpleIronpythonRunner().runAndGetOutputWithInterpreter(executable, REF.getFileAbsolutePath((File)script), null, null, null, monitor, "utf-8");
        InterpreterInfo info = IronpythonInterpreterManager.createInfoFromOutput(monitor, outTup, askUser);
        if (info == null) {
            return null;
        }
        info.restoreCompiledLibs(monitor);
        return new Tuple((Object)info, (Object)((String)outTup.o1));
    }

    public int getInterpreterType() {
        return 2;
    }

    public String getManagerRelatedName() {
        return "ironpython";
    }
}

