/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.remote;

import com.python.pydev.debug.DebugPluginPrefsInitializer;
import com.python.pydev.debug.model.ProcessServer;
import com.python.pydev.debug.model.PyDebugTargetServer;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.PySourceLocator;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;

public class RemoteDebuggerServer
extends AbstractRemoteDebugger
implements Runnable {
    private static final int TIMEOUT = 0;
    private static volatile ServerSocket serverSocket;
    private volatile ILaunch launch;
    private volatile boolean terminated = true;
    private volatile ProcessServer serverProcess;
    private volatile IProcess iProcess;
    private volatile boolean inDispose = false;
    private volatile boolean inStopListening = false;
    private static volatile RemoteDebuggerServer remoteServer;
    private static volatile Thread remoteServerThread;
    private static final Object lock;

    static {
        lock = new Object();
    }

    private RemoteDebuggerServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteDebuggerServer getInstance() {
        Object object = lock;
        synchronized (object) {
            if (remoteServer == null) {
                remoteServer = new RemoteDebuggerServer();
            }
            return remoteServer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() {
        Object object = lock;
        synchronized (object) {
            this.stopListening();
            if (serverSocket == null) {
                try {
                    serverSocket = new ServerSocket(DebugPluginPrefsInitializer.getRemoteDebuggerPort());
                    serverSocket.setReuseAddress(true);
                    serverSocket.setSoTimeout(0);
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
            }
            if (remoteServerThread == null) {
                remoteServerThread = new Thread(remoteServer);
                remoteServerThread.start();
            }
        }
    }

    public void run() {
        try {
            while (true) {
                this.startDebugging(serverSocket.accept());
            }
        }
        catch (SocketException socketException) {
            remoteServerThread = null;
        }
        catch (Exception e) {
            try {
                Log.log((Throwable)e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                remoteServerThread = null;
            }
        }
    }

    private void startDebugging(Socket socket) throws InterruptedException {
        try {
            Thread.sleep(1000L);
            if (this.launch != null) {
                this.launch.setSourceLocator((ISourceLocator)new PySourceLocator());
            }
            PyDebugTargetServer target = new PyDebugTargetServer(this.launch, null, this);
            target.startTransmission(socket);
            target.initialize();
            this.addTarget(target);
        }
        catch (IOException e) {
            Log.log((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() {
        Object object = lock;
        synchronized (object) {
            if (this.terminated || this.inStopListening) {
                return;
            }
            this.inStopListening = true;
            try {
                block12: {
                    this.terminated = true;
                    try {
                        if (this.launch != null && this.launch.canTerminate()) {
                            this.launch.terminate();
                        }
                        remoteServer.dispose();
                        if (serverSocket == null) break block12;
                        try {
                            serverSocket.close();
                        }
                        catch (Throwable e) {
                            Log.log((Throwable)e);
                        }
                        serverSocket = null;
                    }
                    catch (Exception e) {
                        Log.log((Throwable)e);
                    }
                }
                this.launch = null;
            }
            finally {
                this.inStopListening = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = lock;
        synchronized (object) {
            if (this.inDispose) {
                return;
            }
            this.inDispose = true;
            try {
                this.stopListening();
                if (this.launch != null) {
                    for (AbstractDebugTarget target : this.targets) {
                        this.launch.removeDebugTarget((IDebugTarget)target);
                        target.terminate();
                    }
                }
                this.targets.clear();
            }
            finally {
                this.inDispose = false;
            }
        }
    }

    public void disconnect() throws DebugException {
        this.stopListening();
    }

    public void setLaunch(ILaunch launch, ProcessServer p, IProcess pro) {
        if (this.launch != null) {
            this.stopListening();
        }
        this.terminated = false;
        this.serverProcess = p;
        this.launch = launch;
        this.iProcess = pro;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public IProcess getIProcess() {
        return this.iProcess;
    }

    public ProcessServer getServerProcess() {
        return this.serverProcess;
    }
}

