/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.builder.AnalysisBuilderRunnableFactory;
import com.python.pydev.analysis.builder.IAnalysisBuilderRunnable;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.concurrency.IRunnableWithMonitor;
import org.python.pydev.core.concurrency.RunnableAsJobsPoolThread;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.parser.fastparser.FastDefinitionsParser;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.callbacks.ICallback0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisBuilderVisitor
extends PyDevBuilderVisitor {
    protected int getPriority() {
        return 6;
    }

    public void visitChangedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        this.visitChangedResource(resource, document, monitor, false);
    }

    public void visitChangedResource(final IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor, boolean forceAnalysis) {
        SourceModule module;
        String moduleName;
        IDocument doc;
        PythonNature nature = this.getPythonNature(resource);
        if (nature == null) {
            return;
        }
        try {
            doc = (IDocument)document.call();
            if (doc == null) {
                return;
            }
            moduleName = this.getModuleName(resource, (IPythonNature)nature);
            module = this.getSourceModule(resource, doc, (IPythonNature)nature);
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            return;
        }
        ICallback<IModule, Integer> moduleCallback = new ICallback<IModule, Integer>(){

            public IModule call(Integer arg) {
                if (arg == 1) {
                    if (module != null) {
                        return module;
                    }
                    try {
                        return AnalysisBuilderVisitor.this.createSoureModule(resource, doc, moduleName);
                    }
                    catch (MisconfigurationException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (arg == 2) {
                    if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                        Log.toLogFile((Object)this, (String)"PyDevBuilderPrefPage.getAnalyzeOnlyActiveEditor()");
                    }
                    IFile f = (IFile)resource;
                    String file = f.getRawLocation().toOSString();
                    return new SourceModule(moduleName, new File(file), FastDefinitionsParser.parse((String)doc.get(), (String)moduleName), null);
                }
                throw new RuntimeException("Unexpected parameter: " + arg);
            }
        };
        long documentTime = this.getDocumentTime();
        if (documentTime == -1L) {
            Log.log((String)"Warning: The document time in the visitor is -1. Changing for current time.");
            documentTime = System.currentTimeMillis();
        }
        this.doVisitChangedResource((IPythonNature)nature, resource, doc, moduleCallback, null, monitor, forceAnalysis, 1, documentTime);
    }

    public void doVisitChangedResource(IPythonNature nature, IResource resource, IDocument document, ICallback<IModule, Integer> moduleCallback, final IModule module, IProgressMonitor monitor, boolean forceAnalysis, int analysisCause, long documentTime) {
        String moduleName;
        if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
            if (analysisCause == 1) {
                System.out.println("doVisitChangedResource: BUILDER -- " + documentTime);
            } else {
                System.out.println("doVisitChangedResource: PARSER -- " + documentTime);
            }
        }
        if (module != null) {
            if (moduleCallback != null) {
                Log.log((String)("Only the module or the moduleCallback must be specified for: " + resource));
                return;
            }
            this.setModuleInCache(resource, module);
            moduleCallback = new ICallback<IModule, Integer>(){

                public IModule call(Integer arg) {
                    return module;
                }
            };
        } else if (moduleCallback == null) {
            Log.log((String)("Either the module or the moduleCallback must be specified for: " + resource));
            return;
        }
        try {
            moduleName = this.getModuleName(resource, nature);
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
            return;
        }
        IAnalysisBuilderRunnable runnable = AnalysisBuilderRunnableFactory.createRunnable(document, resource, moduleCallback, this.isFullBuild(), moduleName, forceAnalysis, analysisCause, nature, documentTime, resource.getModificationStamp());
        if (runnable == null) {
            return;
        }
        this.execRunnable(moduleName, runnable);
    }

    private void execRunnable(String moduleName, IAnalysisBuilderRunnable runnable) {
        if (this.isFullBuild()) {
            runnable.run();
        } else {
            RunnableAsJobsPoolThread.getSingleton().scheduleToRun((IRunnableWithMonitor)runnable, "PyDev: Code Analysis:" + moduleName);
        }
    }

    public void visitRemovedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        PythonNature nature = this.getPythonNature(resource);
        if (nature == null) {
            return;
        }
        if (resource.getType() == 2) {
            return;
        }
        if (!this.isFullBuild()) {
            String moduleName;
            try {
                moduleName = this.getModuleName(resource, (IPythonNature)nature);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                return;
            }
            long documentTime = this.getDocumentTime();
            if (documentTime == -1L) {
                Log.log((String)("Warning: The document time in the visitor for remove is -1. Changing for current time. Resource: " + resource + ". Module name: " + moduleName));
                documentTime = System.currentTimeMillis();
            }
            long resourceModificationStamp = resource.getModificationStamp();
            IAnalysisBuilderRunnable runnable = AnalysisBuilderRunnableFactory.createRunnable(moduleName, (IPythonNature)nature, this.isFullBuild(), false, 1, documentTime, resourceModificationStamp);
            if (runnable == null) {
                return;
            }
            this.execRunnable(moduleName, runnable);
        }
    }

    public void visitingWillStart(IProgressMonitor monitor, boolean isFullBuild, IPythonNature nature) {
        if (isFullBuild) {
            AbstractAdditionalDependencyInfo info;
            try {
                info = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject(nature);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                return;
            }
            info.clearAllInfo();
        }
    }
}

