/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.outline;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ListResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.shared_ui.editor.IPyEditListener2;
import org.python.pydev.shared_ui.outline.AbstractOutlineFilterAction;
import org.python.pydev.shared_ui.outline.BaseOutlinePage;
import org.python.pydev.shared_ui.outline.IOutlineModel;
import org.python.pydev.shared_ui.outline.IParsedItem;

public class OutlineLinkWithEditorAction
extends AbstractOutlineFilterAction
implements IPyEditListener,
IPyEditListener2 {
    private WeakReference<BaseEditor> pyEdit;
    private final UpdateSelection updateSelection = new UpdateSelection();

    public OutlineLinkWithEditorAction(BaseOutlinePage page, ImageCache imageCache, String pluginId) {
        super("Link With Editor", page, imageCache, String.valueOf(pluginId) + ".PREF_LINK_WITH_EDITOR", "icons/sync_ed.gif");
        this.pyEdit = new WeakReference<BaseEditor>(page.getEditor());
        this.relink();
    }

    public void unlink() {
        BaseEditor edit = (BaseEditor)((Object)this.pyEdit.get());
        if (edit != null) {
            edit.removePyeditListener(this);
        }
    }

    public void relink() {
        BaseEditor edit = (BaseEditor)((Object)this.pyEdit.get());
        if (edit != null) {
            edit.addPyeditListener(this);
        }
    }

    public void dispose() {
        this.unlink();
    }

    protected ViewerFilter createFilter() {
        throw new RuntimeException("Not implemented: as setActionEnabled is overriden, this action is not needed (as this is not a filter action).");
    }

    protected void setActionEnabled(boolean enableAction) {
        BaseOutlinePage p = (BaseOutlinePage)((Object)this.page.get());
        if (p != null) {
            BaseEditor edit;
            p.getStore().setValue(this.preference, enableAction);
            if (enableAction && this.pyEdit != null && (edit = (BaseEditor)((Object)this.pyEdit.get())) != null) {
                this.handleCursorPositionChanged(edit, EditorUtils.createTextSelectionUtils((ITextEditor)edit));
            }
        }
    }

    public void onCreateActions(ListResourceBundle resources, BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onDispose(BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onSave(BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onSetDocument(IDocument document, BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void handleCursorPositionChanged(BaseEditor edit, TextSelectionUtils ps) {
        BaseOutlinePage p = (BaseOutlinePage)((Object)this.page.get());
        if (p != null && edit != null && this.isChecked()) {
            this.doLinkOutlinePosition(edit, p, ps);
        }
    }

    protected void doLinkOutlinePosition(BaseEditor edit, BaseOutlinePage p, TextSelectionUtils ps) {
        IOutlineModel outlineModel = p.getOutlineModel();
        if (outlineModel != null) {
            this.updateSelection.setOutline(outlineModel, p, ps.getTextSelection());
            this.updateSelection.schedule(50L);
        }
    }

    private static class UpdateSelection
    extends UIJob {
        private WeakReference<IOutlineModel> outlineModel;
        private final Object lock = new Object();
        private WeakReference<BaseOutlinePage> outlinePage;
        private ITextSelection ts;

        public UpdateSelection() {
            super("Link outline selection");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            block12: {
                ITextSelection localTextSelection;
                BaseOutlinePage p;
                IParsedItem parsedItem;
                block11: {
                    IOutlineModel model = null;
                    parsedItem = null;
                    p = null;
                    localTextSelection = this.ts;
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.outlineModel != null) {
                            model = (IOutlineModel)this.outlineModel.get();
                        }
                        if (model != null) {
                            parsedItem = model.getRoot();
                        }
                        p = (BaseOutlinePage)((Object)this.outlinePage.get());
                    }
                    if (parsedItem != null && p != null && localTextSelection != null) break block11;
                    return null;
                }
                try {
                    StructuredSelection sel = this.getSelectionPosition(parsedItem, localTextSelection);
                    if (sel == null) break block12;
                    p.unlinkAll();
                    try {
                        p.setSelection((ISelection)sel);
                    }
                    finally {
                        p.relinkAll();
                    }
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOutline(IOutlineModel outlineModel, BaseOutlinePage p, ITextSelection ts) {
            Object object = this.lock;
            synchronized (object) {
                this.outlinePage = new WeakReference<BaseOutlinePage>(p);
                this.ts = ts;
                this.outlineModel = new WeakReference<IOutlineModel>(outlineModel);
            }
        }

        private StructuredSelection getSelectionPosition(IParsedItem r, ITextSelection t) {
            try {
                ArrayList<IParsedItem> sel = new ArrayList<IParsedItem>();
                if (r != null) {
                    IParsedItem item;
                    do {
                        if ((item = this.findSel(r, t.getStartLine() + 1)) == null) continue;
                        sel.add(item);
                    } while ((r = item) != null);
                }
                TreePath treePath = null;
                if (sel != null && sel.size() > 0) {
                    treePath = new TreePath(sel.toArray());
                }
                if (treePath != null) {
                    return new TreeSelection(treePath);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            return null;
        }

        private IParsedItem findSel(IParsedItem r, int startLine) {
            IParsedItem prev = null;
            IParsedItem[] children = r.getChildren();
            if (children != null) {
                IParsedItem[] iParsedItemArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IParsedItem i = iParsedItemArray[n2];
                    int beginLine = i.getBeginLine();
                    if (beginLine >= 0) {
                        if (beginLine == startLine) {
                            prev = i;
                            break;
                        }
                        if (beginLine > startLine) break;
                    }
                    prev = i;
                    ++n2;
                }
            }
            return prev;
        }
    }
}

