/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.ui.search;

import com.python.pydev.ui.search.ReplaceAction2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public class PySearchPage
extends DialogPage
implements ISearchPage {
    private static final int HISTORY_SIZE = 12;
    public static final String EXTENSION_POINT_ID = "com.python.pydev.ui.search.pySearchPage";
    private static final String PAGE_NAME = "PydevSearchPage";
    private static final String STORE_IS_REG_EX_SEARCH = "REG_EX_SEARCH";
    private static final String STORE_CASE_SENSITIVE = "com.python.pydev.ui.search.pySearchPageCASE_SENSITIVE";
    private static final String STORE_SEARCH_DERIVED = "com.python.pydev.ui.search.pySearchPageSEARCH_DERIVED";
    private static final String STORE_HISTORY = "com.python.pydev.ui.search.pySearchPageHISTORY";
    private static final String STORE_HISTORY_SIZE = "com.python.pydev.ui.search.pySearchPageHISTORY_SIZE";
    private List<SearchPatternData> fPreviousSearchPatterns = new ArrayList<SearchPatternData>(20);
    private boolean fFirstTime = true;
    private boolean fIsCaseSensitive;
    private boolean fIsRegExSearch;
    private boolean fSearchDerived;
    private Combo fPattern;
    private Button fIsCaseSensitiveCheckbox;
    private Button fIsRegExCheckbox;
    private CLabel fStatusLabel;
    private ISearchPageContainer fContainer;

    private ISearchQuery newQuery() throws CoreException {
        SearchPatternData data = this.getPatternData();
        TextSearchPageInput input = new TextSearchPageInput(data.textPattern, data.isCaseSensitive, data.isRegExSearch, this.createTextSearchScope());
        return TextSearchQueryProvider.getPreferred().createQuery((TextSearchQueryProvider.TextSearchInput)input);
    }

    public boolean performAction() {
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)this.newQuery());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_searchproblems_message, (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    public boolean performReplace() {
        IStatus status;
        block4: {
            try {
                status = NewSearchUI.runQueryInForeground((IRunnableContext)this.getContainer().getRunnableContext(), (ISearchQuery)this.newQuery());
                if (!status.matches(8)) break block4;
                return false;
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_querycreationproblem_message, (IStatus)e.getStatus());
                return false;
            }
        }
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)SearchMessages.TextSearchPage_replace_searchproblems_title, (String)SearchMessages.TextSearchPage_replace_runproblem_message, (IStatus)status);
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                ISearchResultPage page;
                ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                if (view != null && (page = view.getActivePage()) instanceof FileSearchPage) {
                    FileSearchPage filePage = (FileSearchPage)page;
                    Object[] elements = filePage.getInput().getElements();
                    IFile[] files = new IFile[elements.length];
                    System.arraycopy(elements, 0, files, 0, files.length);
                    new ReplaceAction2(filePage, files).run();
                }
            }
        });
        return true;
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    public FileTextSearchScope createTextSearchScope() {
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
            }
            case 1: {
                return this.getSelectedResourcesScope();
            }
            case 3: {
                return this.getEnclosingProjectScope();
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                return FileTextSearchScope.newSearchScope((IWorkingSet[])workingSets, (String[])this.getExtensions(), (boolean)this.fSearchDerived);
            }
        }
        return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
    }

    private FileTextSearchScope getSelectedResourcesScope() {
        HashSet<IResource> resources = new HashSet<IResource>();
        ISelection sel = this.getContainer().getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            for (Object curr : (IStructuredSelection)sel) {
                IResource resource;
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IResource resource2 = (IResource)elements[i].getAdapter(IResource.class);
                        if (resource2 != null && resource2.isAccessible()) {
                            resources.add(resource2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable) || (resource = (IResource)((IAdaptable)curr).getAdapter(IResource.class)) == null || !resource.isAccessible()) continue;
                resources.add(resource);
            }
        }
        IResource[] arr = resources.toArray(new IResource[resources.size()]);
        return FileTextSearchScope.newSearchScope((IResource[])arr, (String[])this.getExtensions(), (boolean)this.fSearchDerived);
    }

    private FileTextSearchScope getEnclosingProjectScope() {
        String[] enclosingProjectName = this.getContainer().getSelectedProjectNames();
        if (enclosingProjectName == null) {
            return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] res = new IResource[enclosingProjectName.length];
        int i = 0;
        while (i < res.length) {
            res[i] = root.getProject(enclosingProjectName[i]);
            ++i;
        }
        return FileTextSearchScope.newSearchScope((IResource[])res, (String[])this.getExtensions(), (boolean)this.fSearchDerived);
    }

    private SearchPatternData findInPrevious(String pattern) {
        for (SearchPatternData element : this.fPreviousSearchPatterns) {
            if (!pattern.equals(element.textPattern)) continue;
            return element;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        SearchPatternData match = this.findInPrevious(this.fPattern.getText());
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getPattern(), this.isCaseSensitive(), this.fIsRegExCheckbox.getSelection(), this.getExtensions(), this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    private String[] getPreviousSearchPatterns() {
        int size = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = this.fPreviousSearchPatterns.get((int)i).textPattern;
            ++i;
        }
        return patterns;
    }

    private String[] getExtensions() {
        String[] dottedValidSourceFiles;
        ArrayList<String> exts = new ArrayList<String>();
        String[] stringArray = dottedValidSourceFiles = FileTypesPreferencesPage.getDottedValidSourceFiles();
        int n = dottedValidSourceFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceFile = stringArray[n2];
            exts.add(String.valueOf('*') + sourceFile);
            ++n2;
        }
        return exts.toArray(new String[0]);
    }

    private boolean isCaseSensitive() {
        return this.fIsCaseSensitiveCheckbox.getSelection();
    }

    public void setVisible(boolean visible) {
        if (visible && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
                if (!this.initializePatternControl()) {
                    this.fPattern.select(0);
                    this.handleWidgetSelected();
                }
            }
            this.fPattern.setFocus();
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    final void updateOKStatus() {
        boolean regexStatus = this.validateRegex();
        boolean hasFilePattern = true;
        this.getContainer().setPerformActionEnabled(regexStatus && hasFilePattern);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        result.setFont(parent.getFont());
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        this.addTextPatternControls(result);
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.addFileNameControls(result);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
    }

    /*
     * Unable to fully structure code
     */
    private boolean validateRegex() {
        if (this.fIsRegExCheckbox.getSelection()) {
            block5: {
                try {
                    Pattern.compile(this.fPattern.getText());
                    break block5;
                }
                catch (PatternSyntaxException e) {
                    locMessage = e.getLocalizedMessage();
                    i = 0;
                    ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    continue;
                }
lbl12:
                // 1 sources

                this.statusMessage(true, locMessage.substring(0, i));
                return false;
            }
            this.statusMessage(false, "");
        } else {
            this.statusMessage(false, "*= any string, ?= any char, \\= escape for literals:*?\\");
        }
        return true;
    }

    private void addTextPatternControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText("C&ontaining Text");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.fPattern = new Combo(group, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PySearchPage.this.handleWidgetSelected();
                PySearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PySearchPage.this.updateOKStatus();
            }
        });
        this.fPattern.setFont(group.getFont());
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)data);
        this.fIsCaseSensitiveCheckbox = new Button(group, 32);
        this.fIsCaseSensitiveCheckbox.setText("Case Sensi&tive");
        this.fIsCaseSensitiveCheckbox.setSelection(!this.fIsCaseSensitive);
        this.fIsCaseSensitiveCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PySearchPage.this.fIsCaseSensitive = PySearchPage.this.fIsCaseSensitiveCheckbox.getSelection();
            }
        });
        this.fIsCaseSensitiveCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsCaseSensitiveCheckbox.setFont(group.getFont());
        this.fStatusLabel = new CLabel(group, 16384);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fStatusLabel.setFont(group.getFont());
        this.fStatusLabel.setAlignment(16384);
        this.fStatusLabel.setText("");
        this.fIsRegExCheckbox = new Button(group, 32);
        this.fIsRegExCheckbox.setText("&Regular Expression");
        this.fIsRegExCheckbox.setSelection(this.fIsRegExSearch);
        this.fIsRegExCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.fIsRegExCheckbox.setFont(group.getFont());
    }

    private void handleWidgetSelected() {
        int selectionIndex = this.fPattern.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData patternData = this.fPreviousSearchPatterns.get(selectionIndex);
        if (!this.fPattern.getText().equals(patternData.textPattern)) {
            return;
        }
        this.fIsCaseSensitiveCheckbox.setSelection(patternData.isCaseSensitive);
        this.fIsRegExCheckbox.setSelection(patternData.isRegExSearch);
        this.fPattern.setText(patternData.textPattern);
        if (patternData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(patternData.workingSets);
        } else {
            this.getContainer().setSelectedScope(patternData.scope);
        }
    }

    private boolean initializePatternControl() {
        String text;
        ISelection selection = this.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && (text = ((ITextSelection)selection).getText()) != null) {
            this.fPattern.setText(this.insertEscapeChars(text));
            return true;
        }
        return false;
    }

    private String insertEscapeChars(String text) {
        if (text == null || text.equals("")) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new StringReader(text));
        int lengthOfFirstLine = 0;
        try {
            String firstLine = reader.readLine();
            if (firstLine != null) {
                lengthOfFirstLine = firstLine.length();
            }
        }
        catch (IOException iOException) {
            return "";
        }
        FastStringBuffer sbOut = new FastStringBuffer(lengthOfFirstLine + 5);
        int i = 0;
        while (i < lengthOfFirstLine) {
            char ch = text.charAt(i);
            if (ch == '*' || ch == '?' || ch == '\\') {
                sbOut.append("\\");
            }
            sbOut.append(ch);
            ++i;
        }
        return sbOut.toString();
    }

    public static IWorkbenchPage getActivePage() {
        return PySearchPage.getActiveWorkbenchWindow().getActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow window = PydevPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            final WindowRef windowRef = new WindowRef();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    PySearchPage.setActiveWorkbenchWindow(windowRef);
                }
            });
            return windowRef.window;
        }
        return window;
    }

    private static void setActiveWorkbenchWindow(WindowRef windowRef) {
        windowRef.window = null;
        Display display = Display.getCurrent();
        if (display == null) {
            return;
        }
        Shell shell = display.getActiveShell();
        while (shell != null) {
            Object data = shell.getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            shell = shell.getParent();
        }
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            Object data = shells[i].getData();
            if (data instanceof IWorkbenchWindow) {
                windowRef.window = (IWorkbenchWindow)data;
                return;
            }
            ++i;
        }
    }

    private void addFileNameControls(Composite group) {
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private ISelection getSelection() {
        return this.fContainer.getSelection();
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private IDialogSettings getDialogSettings() {
        return this.getDialogSettingsSection(PAGE_NAME);
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = PydevPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fIsCaseSensitive = s.getBoolean(STORE_CASE_SENSITIVE);
        this.fIsRegExSearch = s.getBoolean(STORE_IS_REG_EX_SEARCH);
        this.fSearchDerived = s.getBoolean(STORE_SEARCH_DERIVED);
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put(STORE_CASE_SENSITIVE, this.fIsCaseSensitive);
        s.put(STORE_IS_REG_EX_SEARCH, this.fIsRegExSearch);
        s.put(STORE_SEARCH_DERIVED, this.fSearchDerived);
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
    }

    private static class SearchPatternData {
        public final boolean isCaseSensitive;
        public final boolean isRegExSearch;
        public final String textPattern;
        public final String[] fileNamePatterns;
        public final int scope;
        public final IWorkingSet[] workingSets;

        public SearchPatternData(String textPattern, boolean isCaseSensitive, boolean isRegExSearch, String[] fileNamePatterns, int scope, IWorkingSet[] workingSets) {
            Assert.isNotNull((Object)fileNamePatterns);
            this.isCaseSensitive = isCaseSensitive;
            this.isRegExSearch = isRegExSearch;
            this.textPattern = textPattern;
            this.fileNamePatterns = fileNamePatterns;
            this.scope = scope;
            this.workingSets = workingSets;
        }

        public void store(IDialogSettings settings) {
            settings.put("ignoreCase", !this.isCaseSensitive);
            settings.put("isRegExSearch", this.isRegExSearch);
            settings.put("textPattern", this.textPattern);
            settings.put("fileNamePatterns", this.fileNamePatterns);
            settings.put("scope", this.scope);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getLabel();
                    ++i;
                }
                settings.put("workingSets", wsIds);
            } else {
                settings.put("workingSets", new String[0]);
            }
        }

        public static SearchPatternData create(IDialogSettings settings) {
            String[] fileNamePatterns;
            String textPattern = settings.get("textPattern");
            String[] wsIds = settings.getArray("workingSets");
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            if ((fileNamePatterns = settings.getArray("fileNamePatterns")) == null) {
                fileNamePatterns = new String[]{};
            }
            try {
                int scope = settings.getInt("scope");
                boolean isRegExSearch = settings.getBoolean("isRegExSearch");
                boolean ignoreCase = settings.getBoolean("ignoreCase");
                return new SearchPatternData(textPattern, !ignoreCase, isRegExSearch, fileNamePatterns, scope, workingSets);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public String getPattern() {
            return this.textPattern;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public boolean isRegExSearch() {
            return this.isRegExSearch;
        }

        public boolean isStringMatcherPattern() {
            return !this.isRegExSearch;
        }
    }

    private static class TextSearchPageInput
    extends TextSearchQueryProvider.TextSearchInput {
        private final String fSearchText;
        private final boolean fIsCaseSensitive;
        private final boolean fIsRegEx;
        private final FileTextSearchScope fScope;

        public TextSearchPageInput(String searchText, boolean isCaseSensitive, boolean isRegEx, FileTextSearchScope scope) {
            this.fSearchText = searchText;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fIsRegEx = isRegEx;
            this.fScope = scope;
        }

        public String getSearchText() {
            return this.fSearchText;
        }

        public boolean isCaseSensitiveSearch() {
            return this.fIsCaseSensitive;
        }

        public boolean isRegExSearch() {
            return this.fIsRegEx;
        }

        public FileTextSearchScope getScope() {
            return this.fScope;
        }
    }

    private static class WindowRef {
        public IWorkbenchWindow window;

        private WindowRef() {
        }
    }
}

