/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search;

import com.python.pydev.refactoring.refactorer.search.PythonFileSearchResult;
import com.python.pydev.refactoring.refactorer.search.copied.PatternConstructor;
import com.python.pydev.refactoring.refactorer.search.copied.SearchResultUpdater;
import com.python.pydev.ui.search.FileMatch;
import com.python.pydev.ui.search.LineElement;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;

public abstract class AbstractPythonSearchQuery
implements ISearchQuery {
    private final FileTextSearchScope fScope;
    private final String fSearchText;
    private final boolean fIsRegEx;
    private final boolean fIsCaseSensitive;
    private PythonFileSearchResult fResult;

    public AbstractPythonSearchQuery(String searchText) {
        this(searchText, false, true, null);
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public String getLabel() {
        return "Python Search";
    }

    protected boolean isScopeAllFileTypes() {
        return false;
    }

    public abstract String getResultLabel(int var1);

    public AbstractPythonSearchQuery(String searchText, boolean isRegEx, boolean isCaseSensitive, FileTextSearchScope scope) {
        this.fSearchText = searchText;
        this.fIsRegEx = isRegEx;
        this.fIsCaseSensitive = isCaseSensitive;
        this.fScope = scope;
    }

    public FileTextSearchScope getSearchScope() {
        return this.fScope;
    }

    public IStatus run(IProgressMonitor monitor) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        Pattern searchPattern = this.getSearchPattern();
        boolean searchInBinaries = !this.isScopeAllFileTypes();
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, this.isFileNameSearch(), searchInBinaries);
        return TextSearchEngine.create().search((TextSearchScope)this.fScope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    public String getSearchString() {
        return this.fSearchText;
    }

    public IStatus searchInFile(AbstractTextSearchResult result, IProgressMonitor monitor, IFile file) {
        FileTextSearchScope scope = FileTextSearchScope.newSearchScope((IResource[])new IResource[]{file}, (String[])new String[]{"*"}, (boolean)true);
        Pattern searchPattern = this.getSearchPattern();
        TextSearchResultCollector collector = new TextSearchResultCollector(result, this.isFileNameSearch(), true);
        return TextSearchEngine.create().search((TextSearchScope)scope, (TextSearchRequestor)collector, searchPattern, monitor);
    }

    protected Pattern getSearchPattern() {
        return PatternConstructor.createPattern(this.fSearchText, this.fIsCaseSensitive, this.fIsRegEx);
    }

    public boolean isFileNameSearch() {
        return this.fSearchText.length() == 0;
    }

    public boolean isRegexSearch() {
        return this.fIsRegEx;
    }

    public boolean isCaseSensitive() {
        return this.fIsCaseSensitive;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new PythonFileSearchResult(this);
            new SearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    private static final class TextSearchResultCollector
    extends TextSearchRequestor {
        private final AbstractTextSearchResult fResult;
        private final boolean fIsFileSearchOnly;
        private final boolean fSearchInBinaries;
        private ArrayList fCachedMatches;

        private TextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly, boolean searchInBinaries) {
            this.fResult = result;
            this.fIsFileSearchOnly = isFileSearchOnly;
            this.fSearchInBinaries = searchInBinaries;
        }

        public boolean acceptFile(IFile file) throws CoreException {
            if (this.fIsFileSearchOnly) {
                this.fResult.addMatch((Match)new FileMatch(file));
            }
            this.flushMatches();
            return true;
        }

        public boolean reportBinaryFile(IFile file) {
            return this.fSearchInBinaries;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
            int matchOffset = matchRequestor.getMatchOffset();
            LineElement lineElement = this.getLineElement(matchOffset, matchRequestor);
            if (lineElement != null) {
                FileMatch fileMatch = new FileMatch(matchRequestor.getFile(), matchOffset, matchRequestor.getMatchLength(), lineElement);
                this.fCachedMatches.add(fileMatch);
            }
            return true;
        }

        private LineElement getLineElement(int offset, TextSearchMatchAccess matchRequestor) {
            int lineNumber = 1;
            int lineStart = 0;
            if (!this.fCachedMatches.isEmpty()) {
                FileMatch last = (FileMatch)this.fCachedMatches.get(this.fCachedMatches.size() - 1);
                LineElement lineElement = last.getLineElement();
                if (lineElement.contains(offset)) {
                    return lineElement;
                }
                lineStart = lineElement.getOffset() + lineElement.getLength();
                lineNumber = lineElement.getLine() + 1;
            }
            if (offset < lineStart) {
                return null;
            }
            int i = lineStart;
            int contentLength = matchRequestor.getFileContentLength();
            while (i < contentLength) {
                char ch;
                if ((ch = matchRequestor.getFileContentChar(i++)) != '\n' && ch != '\r') continue;
                if (ch == '\r' && i < contentLength && matchRequestor.getFileContentChar(i) == '\n') {
                    ++i;
                }
                if (offset < i) {
                    String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                    return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
                }
                ++lineNumber;
                lineStart = i;
            }
            if (offset < i) {
                String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
            }
            return null;
        }

        private static String getContents(TextSearchMatchAccess matchRequestor, int start, int end) {
            StringBuffer buf = new StringBuffer();
            int i = start;
            while (i < end) {
                char ch = matchRequestor.getFileContentChar(i);
                if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                    buf.append(' ');
                } else {
                    buf.append(ch);
                }
                ++i;
            }
            return buf.toString();
        }

        public void beginReporting() {
            this.fCachedMatches = new ArrayList();
        }

        public void endReporting() {
            this.flushMatches();
            this.fCachedMatches = null;
        }

        private void flushMatches() {
            if (!this.fCachedMatches.isEmpty()) {
                this.fResult.addMatches(this.fCachedMatches.toArray(new Match[this.fCachedMatches.size()]));
                this.fCachedMatches.clear();
            }
        }
    }
}

