/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.python.compiler.Code;

class Label {
    int position;
    int[] offsets;
    int[] positions;
    int[] sizes;
    int noffsets;
    Code code;
    int stack;

    public Label(Code code) {
        this.code = code;
        this.position = -1;
        this.noffsets = 0;
        this.offsets = new int[4];
        this.positions = new int[4];
        this.sizes = new int[4];
        this.stack = -1;
    }

    public void fix(byte[] data) throws IOException {
        ByteArrayOutputStream array = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(array);
        if (this.noffsets > 0 && this.position == -1) {
            throw new InternalError("position never set for label");
        }
        int i = 0;
        while (i < this.noffsets) {
            int off = this.position - this.offsets[i];
            int p = this.positions[i];
            if (this.sizes[i] == 2) {
                stream.writeShort(off);
            } else {
                stream.writeInt(off);
            }
            System.arraycopy(array.toByteArray(), 0, data, p, this.sizes[i]);
            array.reset();
            ++i;
        }
    }

    public void setStack(int stack) {
        if (this.stack == -1) {
            this.stack = stack;
        } else if (this.stack != stack) {
            throw new InternalError("stack sizes don't agree: " + this.stack + ", " + stack);
        }
    }

    public int getPosition() {
        if (this.position == -1) {
            throw new InternalError("position never set for label");
        }
        return this.position;
    }

    public void setPosition() {
        this.position = this.code.size();
    }

    public void setBranch(int offset, int size) throws IOException {
        if (this.noffsets >= this.offsets.length) {
            int[] new_offsets = new int[this.offsets.length * 2];
            System.arraycopy(this.offsets, 0, new_offsets, 0, this.noffsets);
            this.offsets = new_offsets;
            int[] new_positions = new int[this.positions.length * 2];
            System.arraycopy(this.positions, 0, new_positions, 0, this.noffsets);
            this.positions = new_positions;
            int[] new_sizes = new int[this.sizes.length * 2];
            System.arraycopy(this.sizes, 0, new_sizes, 0, this.noffsets);
            this.sizes = new_sizes;
        }
        this.positions[this.noffsets] = this.code.size();
        this.offsets[this.noffsets] = offset;
        this.sizes[this.noffsets] = size;
        ++this.noffsets;
        if (size == 2) {
            this.code.code.writeShort(0);
        } else {
            this.code.code.writeInt(0);
        }
    }
}

