/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.IllegalCharsetNameException;
import java.util.zip.ZipFile;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtilsFileBuffer {
    public static char[] INVALID_FILESYSTEM_CHARS = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '[', ']', '{', '}', '=', '+', '.', ' ', '`', '~', '\'', '\"', ',', ';'};
    public static boolean IN_TESTS = false;

    public static String getValidProjectName(IProject project) {
        String name = project.getName();
        char[] cArray = INVALID_FILESYSTEM_CHARS;
        int n = INVALID_FILESYSTEM_CHARS.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            name = name.replace(c, '_');
            ++n2;
        }
        return name;
    }

    public static IDocument getDocFromFile(File f) throws IOException {
        return FileUtilsFileBuffer.getDocFromFile(f, true);
    }

    public static String getStringFromZip(File f, String pathInZip) throws Exception {
        return (String)FileUtilsFileBuffer.getCustomReturnFromZip(f, pathInZip, String.class);
    }

    public static IDocument getDocFromZip(File f, String pathInZip) throws Exception {
        return (IDocument)FileUtilsFileBuffer.getCustomReturnFromZip(f, pathInZip, IDocument.class);
    }

    public static Object getCustomReturnFromZip(File f, String pathInZip, Class<? extends Object> returnType) throws Exception {
        ZipFile zipFile = new ZipFile(f, 1);
        try {
            Object object;
            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(pathInZip));
            try {
                object = FileUtils.getStreamContents((InputStream)inputStream, null, null, returnType);
            }
            catch (Throwable throwable) {
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return object;
        }
        finally {
            zipFile.close();
        }
    }

    public static String getStringFromFile(File f, boolean loadIfNotInWorkspace) throws IOException {
        return (String)FileUtilsFileBuffer.getCustomReturnFromFile(f, loadIfNotInWorkspace, String.class);
    }

    public static IDocument getDocFromFile(File f, boolean loadIfNotInWorkspace) throws IOException {
        return (IDocument)FileUtilsFileBuffer.getCustomReturnFromFile(f, loadIfNotInWorkspace, IDocument.class);
    }

    public static Object getCustomReturnFromFile(File f, boolean loadIfNotInWorkspace, Class<? extends Object> returnType) throws IOException {
        IPath path = Path.fromOSString((String)FileUtils.getFileAbsolutePath((File)f));
        IDocument doc = FileUtilsFileBuffer.getDocFromPath(path);
        if (doc != null) {
            if (returnType == null || returnType == IDocument.class) {
                return doc;
            }
            if (returnType == String.class) {
                return doc.get();
            }
            if (returnType == FastStringBuffer.class) {
                return new FastStringBuffer(doc.get(), 16);
            }
            throw new RuntimeException("Don't know how to treat requested return type: " + returnType);
        }
        if (doc == null && loadIfNotInWorkspace) {
            FileInputStream stream = new FileInputStream(f);
            try {
                String encoding = FileUtils.getPythonFileEncoding((File)f);
                Object object = FileUtils.getStreamContents((InputStream)stream, (String)encoding, null, returnType);
                return object;
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        }
        return doc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ITextFileBuffer getBufferFromPath(IPath path) {
        try {
            ITextFileBuffer textFileBuffer;
            ITextFileBufferManager textFileBufferManager = ITextFileBufferManager.DEFAULT;
            if (textFileBufferManager == null || (textFileBuffer = textFileBufferManager.getTextFileBuffer(path, LocationKind.LOCATION)) == null) return null;
            return textFileBuffer;
        }
        catch (Throwable e) {
            try {
                ITextFileBuffer textFileBuffer;
                if (!(e instanceof ClassNotFoundException) && !(e instanceof LinkageError) && !(e instanceof NoSuchMethodException) && !(e instanceof NoSuchMethodError) && !(e instanceof NoClassDefFoundError)) throw e;
                ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
                if (textFileBufferManager == null || (textFileBuffer = textFileBufferManager.getTextFileBuffer(path)) == null) return null;
                return textFileBuffer;
            }
            catch (Throwable throwable) {
                if (IN_TESTS) return null;
                Log.log("Unable to get doc from text file buffer");
                return null;
            }
        }
    }

    public static IDocument getDocFromPath(IPath path) {
        ITextFileBuffer buffer = FileUtilsFileBuffer.getBufferFromPath(path);
        if (buffer != null) {
            return buffer.getDocument();
        }
        return null;
    }

    public static ICallback0<IDocument> getDocOnCallbackFromResource(final IResource resource) {
        return new ICallback0<IDocument>(){
            private IDocument cache;
            private boolean calledOnce = false;

            public IDocument call() {
                if (!this.calledOnce) {
                    this.calledOnce = true;
                    this.cache = FileUtilsFileBuffer.getDocFromResource(resource);
                }
                return this.cache;
            }
        };
    }

    public static IDocument getDocFromResource(IResource resource) {
        IProject project = resource.getProject();
        if (project != null && resource instanceof IFile && resource.exists()) {
            IFile file = (IFile)resource;
            try {
                IPath path;
                IDocument doc;
                if (!file.isSynchronized(0)) {
                    file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                }
                if ((doc = FileUtilsFileBuffer.getDocFromPath(path = file.getFullPath())) == null) {
                    doc = (IDocument)FileUtils.getStreamContents((InputStream)file.getContents(true), null, null, IDocument.class);
                }
                return doc;
            }
            catch (CoreException coreException) {
                return null;
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        return null;
    }

    public static String getPythonFileEncoding(IDocument doc, String fileLocation) throws IllegalCharsetNameException {
        StringReader inputStreamReader = new StringReader(doc.get());
        return FileUtils.getPythonFileEncoding((Reader)inputStreamReader, (String)fileLocation);
    }
}

