/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitionerExtension2;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.docutils.PyDocIterator;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.shared_core.string.BaseParsingUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParsingUtils
extends BaseParsingUtils
implements IPythonPartitions {
    public ParsingUtils(boolean throwSyntaxError) {
        super(throwSyntaxError);
    }

    public static ParsingUtils create(Object cs) {
        return ParsingUtils.create(cs, false);
    }

    public static ParsingUtils create(Object cs, boolean throwSyntaxError, int len) {
        if (cs instanceof char[]) {
            char[] cs2 = (char[])cs;
            return new FixedLenCharArrayParsingUtils(cs2, throwSyntaxError, len);
        }
        if (cs instanceof FastStringBuffer) {
            FastStringBuffer cs2 = (FastStringBuffer)cs;
            return new FixedLenFastStringBufferParsingUtils(cs2, throwSyntaxError, len);
        }
        if (cs instanceof StringBuffer) {
            StringBuffer cs2 = (StringBuffer)cs;
            return new FixedLenStringBufferParsingUtils(cs2, throwSyntaxError, len);
        }
        if (cs instanceof String) {
            String cs2 = (String)cs;
            return new FixedLenStringParsingUtils(cs2, throwSyntaxError, len);
        }
        if (cs instanceof IDocument) {
            IDocument cs2 = (IDocument)cs;
            return new FixedLenIDocumentParsingUtils(cs2, throwSyntaxError, len);
        }
        throw new RuntimeException("Don't know how to create instance for: " + cs.getClass());
    }

    public static ParsingUtils create(Object cs, boolean throwSyntaxError) {
        if (cs instanceof char[]) {
            char[] cs2 = (char[])cs;
            return new FixedLenCharArrayParsingUtils(cs2, throwSyntaxError, cs2.length);
        }
        if (cs instanceof FastStringBuffer) {
            FastStringBuffer cs2 = (FastStringBuffer)cs;
            return new FastStringBufferParsingUtils(cs2, throwSyntaxError);
        }
        if (cs instanceof StringBuffer) {
            StringBuffer cs2 = (StringBuffer)cs;
            return new StringBufferParsingUtils(cs2, throwSyntaxError);
        }
        if (cs instanceof String) {
            String cs2 = (String)cs;
            return new FixedLenStringParsingUtils(cs2, throwSyntaxError, cs2.length());
        }
        if (cs instanceof IDocument) {
            IDocument cs2 = (IDocument)cs;
            return new IDocumentParsingUtils(cs2, throwSyntaxError);
        }
        throw new RuntimeException("Don't know how to create instance for: " + cs.getClass());
    }

    public int eatComments(FastStringBuffer buf, int i) {
        char c;
        int len = this.len();
        while (i < len && (c = this.charAt(i)) != '\n' && c != '\r') {
            if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        if (i < len && buf != null) {
            buf.append(this.charAt(i));
        }
        return i;
    }

    public int eatWhitespaces(FastStringBuffer buf, int i) {
        char c;
        int len = this.len();
        while (i < len && (c = this.charAt(i)) == ' ') {
            if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        return --i;
    }

    public int eatLiteralsBackwards(FastStringBuffer buf, int i) throws SyntaxErrorException {
        char curr = this.charAt(i);
        if (curr != '\"' && curr != '\'') {
            throw new RuntimeException("Wrong location to eat literals. Expecting ' or \" Found:" + curr);
        }
        int j = this.getLiteralStart(i, curr);
        if (buf != null) {
            int k = j;
            while (k <= i) {
                buf.append(this.charAt(k));
                ++k;
            }
        }
        return j;
    }

    public int eatLiterals(FastStringBuffer buf, int startPos) throws SyntaxErrorException {
        return this.eatLiterals(buf, startPos, false);
    }

    public int eatLiterals(FastStringBuffer buf, int startPos, boolean rightTrimMultiline) throws SyntaxErrorException {
        boolean rightTrim;
        char startChar = this.charAt(startPos);
        if (startChar != '\"' && startChar != '\'') {
            throw new RuntimeException("Wrong location to eat literals. Expecting ' or \" ");
        }
        int endPos = this.getLiteralEnd(startPos, startChar);
        boolean bl = rightTrim = rightTrimMultiline && this.isMultiLiteral(startPos, startChar);
        if (buf != null) {
            int lastPos = Math.min(endPos, this.len() - 1);
            int i = startPos;
            while (i <= lastPos) {
                char ch = this.charAt(i);
                if (rightTrim && (ch == '\r' || ch == '\n')) {
                    buf.rightTrim();
                }
                buf.append(ch);
                ++i;
            }
        }
        return endPos;
    }

    public int getLiteralStart(int i, char curr) throws SyntaxErrorException {
        boolean multi = this.isMultiLiteralBackwards(i, curr);
        int j = multi ? this.findPreviousMulti(i - 3, curr) : this.findPreviousSingle(i - 1, curr);
        return j;
    }

    public int getLiteralEnd(int i, char curr) throws SyntaxErrorException {
        boolean multi = this.isMultiLiteral(i, curr);
        int j = multi ? this.findNextMulti(i + 3, curr) : this.findNextSingle(i + 1, curr);
        return j;
    }

    public int eatPar(int i, FastStringBuffer buf) throws SyntaxErrorException {
        return this.eatPar(i, buf, '(');
    }

    public int getFullFlattenedLine(int i, FastStringBuffer buf) throws SyntaxErrorException {
        char c = this.charAt(i);
        int len = this.len();
        boolean ignoreNextNewLine = false;
        while (i < len) {
            c = this.charAt(i);
            ++i;
            if (c == '\'' || c == '\"') {
                i = this.eatLiterals(null, i - 1) + 1;
            } else {
                if (c == '#') {
                    i = this.eatComments(null, i - 1);
                    break;
                }
                if (c == '(' || c == '[' || c == '{') {
                    i = this.eatPar(i - 1, null, c) + 1;
                } else if (c == '\r' || c == '\n') {
                    if (!ignoreNextNewLine) {
                        --i;
                        break;
                    }
                } else {
                    if (c == '\\' || c == '\\') {
                        ignoreNextNewLine = true;
                        continue;
                    }
                    if (buf != null) {
                        buf.append(c);
                    }
                }
            }
            ignoreNextNewLine = false;
        }
        return --i;
    }

    /*
     * Unable to fully structure code
     */
    public int eatPar(int i, FastStringBuffer buf, char par) throws SyntaxErrorException {
        c = ' ';
        closingPar = org.python.pydev.shared_core.string.StringUtils.getPeer((char)par);
        j = i + 1;
        len = this.len();
        if (true) ** GOTO lbl20
        do {
            ++j;
            if (c == '\'' || c == '\"') {
                j = this.eatLiterals(null, j - 1) + 1;
            } else if (c == '#') {
                j = this.eatComments(null, j - 1) + 1;
            } else if (c == par) {
                j = this.eatPar(j - 1, null, par) + 1;
            } else if (buf != null) {
                buf.append(c);
            }
lbl20:
            // 7 sources

            if (j >= len) break;
            v0 = this.charAt(j);
            c = v0;
        } while (v0 != closingPar);
        if (this.throwSyntaxError && c != closingPar) {
            throw new SyntaxErrorException();
        }
        return j;
    }

    public int findNextSingle(int i, char curr) throws SyntaxErrorException {
        boolean ignoreNext = false;
        int len = this.len();
        while (i < len) {
            char c = this.charAt(i);
            if (!ignoreNext && c == curr) {
                return i;
            }
            if (!ignoreNext) {
                if (c == '\\') {
                    ignoreNext = true;
                }
            } else {
                ignoreNext = false;
            }
            ++i;
        }
        if (this.throwSyntaxError) {
            throw new SyntaxErrorException();
        }
        return i;
    }

    public int findPreviousSingle(int i, char curr) throws SyntaxErrorException {
        while (i >= 0) {
            char c = this.charAt(i);
            if (c == curr) {
                if (i > 0 && this.charAt(i - 1) == '\\') {
                    --i;
                    continue;
                }
                return i;
            }
            --i;
        }
        if (this.throwSyntaxError) {
            throw new SyntaxErrorException();
        }
        return i;
    }

    public int findNextMulti(int i, char curr) throws SyntaxErrorException {
        int len = this.len();
        while (i + 2 < len) {
            char c = this.charAt(i);
            if (c == curr && this.charAt(i + 1) == curr && this.charAt(i + 2) == curr) {
                return i + 2;
            }
            ++i;
            if (c != '\\') continue;
            ++i;
        }
        if (this.throwSyntaxError) {
            throw new SyntaxErrorException();
        }
        if (len < i + 2) {
            return len;
        }
        return i + 2;
    }

    public int findPreviousMulti(int i, char curr) throws SyntaxErrorException {
        while (i - 2 >= 0) {
            char c = this.charAt(i);
            if (c == curr && this.charAt(i - 1) == curr && this.charAt(i - 2) == curr) {
                return i - 2;
            }
            --i;
        }
        if (this.throwSyntaxError) {
            throw new SyntaxErrorException();
        }
        return 0;
    }

    public boolean isMultiLiteralBackwards(int i, char curr) {
        if (i - 2 < 0) {
            return false;
        }
        return this.charAt(i - 1) == curr && this.charAt(i - 2) == curr;
    }

    public boolean isMultiLiteral(int i, char curr) {
        int len = this.len();
        if (len <= i + 2) {
            return false;
        }
        return this.charAt(i + 1) == curr && this.charAt(i + 2) == curr;
    }

    public static void removeCommentsWhitespacesAndLiterals(FastStringBuffer buf, boolean throwSyntaxError) throws SyntaxErrorException {
        ParsingUtils.removeCommentsWhitespacesAndLiterals(buf, true, throwSyntaxError);
    }

    public static void removeCommentsWhitespacesAndLiterals(FastStringBuffer buf, boolean whitespacesToo, boolean throwSyntaxError) throws SyntaxErrorException {
        ParsingUtils parsingUtils = ParsingUtils.create(buf, throwSyntaxError);
        int i = 0;
        while (i < buf.length()) {
            int j;
            char ch = buf.charAt(i);
            if (ch == '#') {
                j = i;
                int len = buf.length();
                while (j < len && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(j);
                    ++j;
                }
                buf.delete(i, j);
                --i;
            } else if (ch == '\'' || ch == '\"') {
                j = parsingUtils.getLiteralEnd(i, ch);
                if (whitespacesToo) {
                    buf.delete(i, j + 1);
                } else {
                    int k = 0;
                    while (i + k < j + 1) {
                        buf.replace(i + k, i + k + 1, " ");
                        ++k;
                    }
                }
            }
            ++i;
        }
        if (whitespacesToo) {
            buf.removeWhitespaces();
        }
    }

    public static void removeLiterals(FastStringBuffer buf, boolean throwSyntaxError) throws SyntaxErrorException {
        ParsingUtils parsingUtils = ParsingUtils.create(buf, throwSyntaxError);
        int i = 0;
        while (i < buf.length()) {
            char ch = buf.charAt(i);
            if (ch == '#') {
                while (i < buf.length() && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(i);
                    ++i;
                }
            }
            if (ch == '\'' || ch == '\"') {
                int j = parsingUtils.getLiteralEnd(i, ch);
                int k = 0;
                while (i + k < j + 1) {
                    buf.replace(i + k, i + k + 1, " ");
                    ++k;
                }
            }
            ++i;
        }
    }

    public static Iterator<String> getNoLiteralsOrCommentsIterator(IDocument doc) {
        return new PyDocIterator(doc);
    }

    public static void removeCommentsAndWhitespaces(FastStringBuffer buf) {
        int i = 0;
        while (i < buf.length()) {
            char ch = buf.charAt(i);
            if (ch == '#') {
                int j = i;
                while (j < buf.length() - 1 && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(++j);
                }
                buf.delete(i, j);
            }
            ++i;
        }
        int length = buf.length();
        int i2 = length - 1;
        while (i2 >= 0) {
            char ch = buf.charAt(i2);
            if (Character.isWhitespace(ch)) {
                buf.deleteCharAt(i2);
            }
            --i2;
        }
    }

    public static String getContentType(String initial, int currPos) {
        FastStringBuffer buf = new FastStringBuffer(initial, 0);
        ParsingUtils parsingUtils = ParsingUtils.create(initial);
        String curr = "__dftl_partition_content_type";
        int i = 0;
        while (i < buf.length() && i < currPos) {
            char ch = buf.charAt(i);
            curr = "__dftl_partition_content_type";
            if (ch == '#') {
                curr = "__python_comment";
                int j = i;
                while (j < buf.length() - 1 && ch != '\n' && ch != '\r') {
                    ch = buf.charAt(++j);
                }
                i = j;
            }
            if (i >= currPos) {
                return curr;
            }
            if (ch == '\'' || ch == '\"') {
                boolean multi = parsingUtils.isMultiLiteral(i, ch);
                if (multi) {
                    curr = "__python_multiline_string1";
                    if (ch == '\"') {
                        curr = "__python_multiline_string2";
                    }
                } else {
                    curr = "__python_singleline_string1";
                    if (ch == '\"') {
                        curr = "__python_singleline_string2";
                    }
                }
                try {
                    i = multi ? parsingUtils.findNextMulti(i + 3, ch) : parsingUtils.findNextSingle(i + 1, ch);
                }
                catch (SyntaxErrorException e) {
                    throw new RuntimeException(e);
                }
                if (currPos < i) {
                    return curr;
                }
                if (currPos == i && ("__python_singleline_string1".equals(curr) || "__python_singleline_string2".equals(curr))) {
                    return curr;
                }
                curr = "__dftl_partition_content_type";
            }
            ++i;
        }
        return curr;
    }

    public static String getContentType(IDocument document, int i) {
        IDocumentExtension3 docExtension = (IDocumentExtension3)document;
        IDocumentPartitionerExtension2 partitioner = (IDocumentPartitionerExtension2)docExtension.getDocumentPartitioner("__PYTHON_PARTITION_TYPE");
        if (partitioner != null) {
            return partitioner.getContentType(i, true);
        }
        return ParsingUtils.getContentType(document.get(), i);
    }

    public static String makePythonParseable(String code, String delimiter) {
        return ParsingUtils.makePythonParseable(code, delimiter, new FastStringBuffer());
    }

    public static String makePythonParseable(String code, String delimiter, FastStringBuffer lastLine) {
        FastStringBuffer buffer = new FastStringBuffer();
        FastStringBuffer currLine = new FastStringBuffer();
        boolean foundNewLine = false;
        boolean lastWasNewLine = false;
        if (lastLine.length() > 0) {
            lastWasNewLine = true;
        }
        int i = 0;
        while (i < code.length()) {
            boolean foundNewLineAtChar = false;
            char c = code.charAt(i);
            if (c == '\r') {
                if (i + 1 < code.length() && code.charAt(i + 1) == '\n') {
                    ++i;
                }
                foundNewLineAtChar = true;
            } else if (c == '\n') {
                foundNewLineAtChar = true;
            }
            if (!foundNewLineAtChar) {
                if (lastWasNewLine && !Character.isWhitespace(c) && lastLine.length() > 0 && Character.isWhitespace(lastLine.charAt(0))) {
                    buffer.append(delimiter);
                }
                currLine.append(c);
                lastWasNewLine = false;
            } else {
                lastWasNewLine = true;
            }
            if (foundNewLineAtChar || i == code.length() - 1) {
                if (!PySelection.containsOnlyWhitespaces((String)currLine.toString())) {
                    buffer.append(currLine);
                    lastLine = currLine;
                    currLine = new FastStringBuffer();
                    buffer.append(delimiter);
                    foundNewLine = true;
                } else {
                    currLine = new FastStringBuffer();
                }
            }
            ++i;
        }
        if (!foundNewLine) {
            buffer.append(delimiter);
        } else {
            if (!StringUtils.endsWith(buffer, '\r') && !StringUtils.endsWith(buffer, '\n')) {
                buffer.append(delimiter);
            }
            if (lastLine.length() > 0 && Character.isWhitespace(lastLine.charAt(0)) && (code.indexOf(13) != -1 || code.indexOf(10) != -1)) {
                buffer.append(delimiter);
            }
        }
        return buffer.toString();
    }

    public static String removeComments(String line) {
        int i = line.indexOf(35);
        if (i != -1) {
            return line.substring(0, i);
        }
        return line;
    }

    public static boolean isStringPartition(IDocument document, int offset) {
        String contentType = ParsingUtils.getContentType(document, offset);
        return "__python_multiline_string1".equals(contentType) || "__python_multiline_string2".equals(contentType) || "__python_singleline_string1".equals(contentType) || "__python_singleline_string2".equals(contentType);
    }

    public static boolean isCommentPartition(IDocument document, int offset) {
        String contentType = ParsingUtils.getContentType(document, offset);
        return "__python_comment".equals(contentType);
    }

    public static /* bridge */ /* synthetic */ BaseParsingUtils create(Object object, boolean bl) {
        return ParsingUtils.create(object, bl);
    }

    public static /* bridge */ /* synthetic */ BaseParsingUtils create(Object object, boolean bl, int n) {
        return ParsingUtils.create(object, bl, n);
    }

    public static /* bridge */ /* synthetic */ BaseParsingUtils create(Object object) {
        return ParsingUtils.create(object);
    }

    private static final class FastStringBufferParsingUtils
    extends ParsingUtils {
        private final FastStringBuffer cs;

        public FastStringBufferParsingUtils(FastStringBuffer cs, boolean throwSyntaxError) {
            super(throwSyntaxError);
            this.cs = cs;
        }

        public int len() {
            return this.cs.length();
        }

        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static final class FixedLenCharArrayParsingUtils
    extends ParsingUtils {
        private final char[] cs;
        private final int len;

        public FixedLenCharArrayParsingUtils(char[] cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        public int len() {
            return this.len;
        }

        public char charAt(int i) {
            return this.cs[i];
        }
    }

    private static final class FixedLenFastStringBufferParsingUtils
    extends ParsingUtils {
        private final FastStringBuffer cs;
        private final int len;

        public FixedLenFastStringBufferParsingUtils(FastStringBuffer cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        public int len() {
            return this.len;
        }

        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static final class FixedLenIDocumentParsingUtils
    extends ParsingUtils {
        private final IDocument cs;
        private final int len;

        public FixedLenIDocumentParsingUtils(IDocument cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        public int len() {
            return this.len;
        }

        public char charAt(int i) {
            try {
                return this.cs.getChar(i);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class FixedLenStringBufferParsingUtils
    extends ParsingUtils {
        private final StringBuffer cs;
        private final int len;

        public FixedLenStringBufferParsingUtils(StringBuffer cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        public int len() {
            return this.len;
        }

        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static final class FixedLenStringParsingUtils
    extends ParsingUtils {
        private final String cs;
        private final int len;

        public FixedLenStringParsingUtils(String cs, boolean throwSyntaxError, int len) {
            super(throwSyntaxError);
            this.cs = cs;
            this.len = len;
        }

        public int len() {
            return this.len;
        }

        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }

    private static final class IDocumentParsingUtils
    extends ParsingUtils {
        private final IDocument cs;

        public IDocumentParsingUtils(IDocument cs, boolean throwSyntaxError) {
            super(throwSyntaxError);
            this.cs = cs;
        }

        public int len() {
            return this.cs.getLength();
        }

        public char charAt(int i) {
            try {
                return this.cs.getChar(i);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class StringBufferParsingUtils
    extends ParsingUtils {
        private final StringBuffer cs;

        public StringBufferParsingUtils(StringBuffer cs, boolean throwSyntaxError) {
            super(throwSyntaxError);
            this.cs = cs;
        }

        public int len() {
            return this.cs.length();
        }

        public char charAt(int i) {
            return this.cs.charAt(i);
        }
    }
}

