/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.python.pydev.core.docutils.PythonCodeReader;
import org.python.pydev.core.docutils.StringUtils;

public class PythonPairMatcher
implements ICharacterPairMatcher {
    protected char[] fPairs;
    protected IDocument fDocument;
    protected int fOffset;
    protected int fStartPos;
    protected int fEndPos;
    protected int fAnchor;
    protected PythonCodeReader fReader = new PythonCodeReader();

    public PythonPairMatcher() {
        this(StringUtils.BRACKETS);
    }

    public PythonPairMatcher(char[] pairs) {
        this.fPairs = pairs;
    }

    public IRegion match(IDocument document, int offset) {
        this.fOffset = offset;
        if (this.fOffset < 0) {
            return null;
        }
        this.fDocument = document;
        if (this.fDocument != null && this.matchPairsAt() && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
        this.fReader = null;
    }

    public void clear() {
        if (this.fReader != null) {
            try {
                this.fReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean matchPairsAt() {
        int pairIndex1 = this.fPairs.length;
        int pairIndex2 = this.fPairs.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            char prevChar = this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            int i = 0;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fStartPos = this.fOffset - 1;
                    pairIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < this.fPairs.length) {
                if (prevChar == this.fPairs[i]) {
                    this.fEndPos = this.fOffset - 1;
                    pairIndex2 = i;
                }
                i += 2;
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, this.fPairs[pairIndex2 - 1], this.fPairs[pairIndex2], this.fDocument);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
                return false;
            }
            if (this.fStartPos <= -1) return false;
            this.fAnchor = 1;
            this.fEndPos = this.searchForClosingPeer(this.fStartPos, this.fPairs[pairIndex1], this.fPairs[pairIndex1 + 1], this.fDocument);
            if (this.fEndPos > -1) {
                return true;
            }
            this.fStartPos = -1;
            return false;
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    public int searchForClosingPeer(int offset, char openingPeer, char closingPeer, IDocument document) {
        try {
            this.fReader.configureForwardReader(document, offset + 1, document.getLength(), true, true, true);
            int stack = 1;
            int c = this.fReader.read();
            while (c != -1) {
                if (c == openingPeer && c != closingPeer) {
                    ++stack;
                } else if (c == closingPeer) {
                    --stack;
                }
                if (stack <= 0) {
                    return this.fReader.getOffset();
                }
                c = this.fReader.read();
            }
            return -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int searchForOpeningPeer(int offset, char openingPeer, char closingPeer, IDocument document) {
        try {
            this.fReader.configureBackwardReader(document, offset, true, true, true);
            int stack = 1;
            int c = this.fReader.read();
            while (c != -1) {
                if (c == closingPeer && c != openingPeer) {
                    ++stack;
                } else if (c == openingPeer) {
                    --stack;
                }
                if (stack <= 0) {
                    return this.fReader.getOffset();
                }
                c = this.fReader.read();
            }
            return -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int searchForAnyOpeningPeer(int offset, IDocument document) {
        try {
            this.fReader.configureBackwardReader(document, offset, true, true, true);
            HashMap<Character, Integer> stack = new HashMap<Character, Integer>();
            HashSet<Character> closing = new HashSet<Character>();
            HashSet<Character> opening = new HashSet<Character>();
            int i = 0;
            while (i < this.fPairs.length) {
                stack.put(Character.valueOf(this.fPairs[i]), 1);
                if (i % 2 == 0) {
                    opening.add(Character.valueOf(this.fPairs[i]));
                } else {
                    closing.add(Character.valueOf(this.fPairs[i]));
                }
                ++i;
            }
            int c = this.fReader.read();
            while (c != -1) {
                if (closing.contains(Character.valueOf((char)c))) {
                    char peer = org.python.pydev.shared_core.string.StringUtils.getPeer((char)((char)c));
                    Integer iStack = (Integer)stack.get(Character.valueOf(peer));
                    iStack = iStack + 1;
                    stack.put(Character.valueOf(peer), iStack);
                } else if (opening.contains(Character.valueOf((char)c))) {
                    Integer iStack = (Integer)stack.get(Character.valueOf((char)c));
                    iStack = iStack - 1;
                    stack.put(Character.valueOf((char)c), iStack);
                    if (iStack == 0) {
                        return this.fReader.getOffset();
                    }
                }
                c = this.fReader.read();
            }
            return -1;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

