/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.path_watch;

import java.io.File;
import java.util.Map;
import java.util.Set;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.WatchKey;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.ListenerList;
import org.python.pydev.core.path_watch.IFilesystemChangesListener;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.OrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsStackerRunnable
implements Runnable {
    public static final int ADDED = 0;
    public static final int REMOVED = 1;
    volatile WatchKey key;
    public final ListenerList<IFilesystemChangesListener> list;
    public final Path watchedPath;
    private final Object lock = new Object();
    private Map<File, Integer> fileToEvent = new OrderedMap();
    private volatile File overflow = null;

    public EventsStackerRunnable(WatchKey key, Path watchedPath, ListenerList<IFilesystemChangesListener> list) {
        Assert.isNotNull(list);
        Assert.isNotNull((Object)watchedPath);
        this.list = list;
        this.key = key;
        this.watchedPath = watchedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File currentOverflow;
        Map<File, Integer> currentFileToEvent;
        Object object = this.lock;
        synchronized (object) {
            currentFileToEvent = this.fileToEvent;
            this.fileToEvent = new OrderedMap();
            currentOverflow = this.overflow;
            this.overflow = null;
        }
        IFilesystemChangesListener[] listeners = this.list.getListeners();
        if (listeners.length > 0) {
            if (currentOverflow != null) {
                IFilesystemChangesListener[] iFilesystemChangesListenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    IFilesystemChangesListener iFilesystemChangesListener = iFilesystemChangesListenerArray[n2];
                    File watched = new File(this.watchedPath.toString());
                    iFilesystemChangesListener.removed(watched);
                    if (watched.exists()) {
                        iFilesystemChangesListener.added(watched);
                    }
                    ++n2;
                }
                return;
            }
            Set<Map.Entry<File, Integer>> entrySet = currentFileToEvent.entrySet();
            block8: for (Map.Entry<File, Integer> entry : entrySet) {
                Integer value = entry.getValue();
                File currKey = entry.getKey();
                switch (value) {
                    case 0: {
                        IFilesystemChangesListener iFilesystemChangesListener;
                        IFilesystemChangesListener[] iFilesystemChangesListenerArray = listeners;
                        int n = listeners.length;
                        int n3 = 0;
                        while (n3 < n) {
                            iFilesystemChangesListener = iFilesystemChangesListenerArray[n3];
                            iFilesystemChangesListener.added(currKey);
                            ++n3;
                        }
                        continue block8;
                    }
                    case 1: {
                        IFilesystemChangesListener iFilesystemChangesListener;
                        IFilesystemChangesListener[] iFilesystemChangesListenerArray = listeners;
                        int n = listeners.length;
                        int n3 = 0;
                        while (n3 < n) {
                            iFilesystemChangesListener = iFilesystemChangesListenerArray[n3];
                            iFilesystemChangesListener.removed(currKey);
                            ++n3;
                        }
                        continue block8;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void overflow(File file) {
        Object object = this.lock;
        synchronized (object) {
            this.overflow = file;
            this.fileToEvent.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void added(File file) {
        Object object = this.lock;
        synchronized (object) {
            if (this.overflow == null) {
                this.fileToEvent.put(file, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(File file) {
        Object object = this.lock;
        synchronized (object) {
            if (this.overflow == null) {
                this.fileToEvent.put(file, 1);
            }
        }
    }

    public String toString() {
        return new FastStringBuffer().append("EventsStackerRunnable(key=").appendObject((Object)this.key).append(";watchedPath=").appendObject((Object)this.watchedPath).append(";overflow=").appendObject((Object)this.overflow).append(";fileToEvent=").appendObject(this.fileToEvent).append(";listeners=").appendObject((Object)this.list.getListeners()).append(")").toString();
    }
}

