/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.python.pydev.core.docutils.WrapAndCaseUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;

final class DialogNotifier
extends Dialog {
    private static final int BOLD_COLS = 120;

    public DialogNotifier(Shell shell) {
        super(shell);
        this.setShellStyle(3184);
        this.setBlockOnOpen(false);
    }

    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gridData = null;
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 1;
        String msg = "Help keeping PyDev alive";
        this.createLabel(composite, WrapAndCaseUtils.wrap((String)msg, (int)120), 1);
        try {
            ToolBar navBar = new ToolBar(composite, 0);
            final Browser browser = new Browser(composite, 2048);
            browser.setText("<html><head><base href=\"http://pydev.org\" ><title>Keeping PyDev alive</title></head><body>I'm reaching out for you today to ask for your help to keep PyDev properly supported, as well as improving some aspects of Eclipse itself (especially for those that like to work with a Dark theme).<br/><br/>A campaign was created at Indiegogo (<a href=\"http://igg.me/at/liclipse\">http://igg.me/at/liclipse</a>) for this purpose, and I'd really appreciate if you can take some time to take a look at it and share it (and if possible contribute) if you feel that those are worthy goals.<br/><br/>Without your help, it's possible that PyDev may become unsupported!<br/><br/>Thanks,<br/><br/>Fabio<br/><br/>p.s.: Sorry for the dialog. It won't be shown again in this workspace after you click the \"Read it\" button.</body></html>");
            gridData = new GridData(1808);
            browser.setLayoutData((Object)gridData);
            ToolItem back = new ToolItem(navBar, 8);
            back.setImage(PydevPlugin.getImageCache().get("icons/backward_nav.gif"));
            ToolItem forward = new ToolItem(navBar, 8);
            forward.setImage(PydevPlugin.getImageCache().get("icons/forward_nav.gif"));
            ToolItem stop = new ToolItem(navBar, 8);
            stop.setImage(PydevPlugin.getImageCache().get("icons/showerr_tsk.gif"));
            ToolItem refresh = new ToolItem(navBar, 8);
            refresh.setImage(PydevPlugin.getImageCache().get("icons/refresh_nav.gif"));
            ToolItem home = new ToolItem(navBar, 8);
            home.setImage(PydevPlugin.getImageCache().get("icons/home_nav.gif"));
            back.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.back();
                }
            });
            forward.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.forward();
                }
            });
            stop.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.stop();
                }
            });
            refresh.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.refresh();
                }
            });
            home.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    browser.setText("<html><head><base href=\"http://pydev.org\" ><title>Keeping PyDev alive</title></head><body>I'm reaching out for you today to ask for your help to keep PyDev properly supported, as well as improving some aspects of Eclipse itself (especially for those that like to work with a Dark theme).<br/><br/>A campaign was created at Indiegogo (<a href=\"http://igg.me/at/liclipse\">http://igg.me/at/liclipse</a>) for this purpose, and I'd really appreciate if you can take some time to take a look at it and share it (and if possible contribute) if you feel that those are worthy goals.<br/><br/>Without your help, it's possible that PyDev may become unsupported!<br/><br/>Thanks,<br/><br/>Fabio<br/><br/>p.s.: Sorry for the dialog. It won't be shown again in this workspace after you click the \"Read it\" button.</body></html>");
                }
            });
        }
        catch (Throwable throwable) {
            String msg2 = "I'm reaching out for you today to ask for your help to keep PyDev properly supported, as well as improving some aspects \nof Eclipse itself (especially for those that like to work with a Dark theme).\n\n\nA campaign was created at Indiegogo (http://igg.me/at/liclipse) for this purpose, and I'd really appreciate if you can take \nsome time to take a look at it and share it (and if possible contribute) if you feel that those are worthy goals.\n\n\nWithout your help, it's possible that PyDev may become unsupported!\n\n\nThanks,\n\n\nFabio\n\n\np.s.: Sorry for the dialog. It won't be shown again in this workspace after you click the \"Read it\" button.\n";
            this.createText(composite, msg2, 1);
        }
        return composite;
    }

    public boolean doClose() {
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 0, " Show later ", true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DialogNotifier.this.doClose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        button = this.createButton(parent, 1024, " Read it ", true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DialogNotifier.this.doClose();
                IPreferenceStore preferenceStore = PydevPrefs.getPreferenceStore();
                preferenceStore.setValue("PYDEV_FUNDING_SHOWN", true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Text createText(Composite composite, String labelMsg, int colSpan) {
        Text text = new Text(composite, 2058);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = colSpan;
        text.setLayoutData((Object)gridData);
        text.setText(labelMsg);
        return text;
    }

    private Label createLabel(Composite composite, String labelMsg, int colSpan) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = colSpan;
        label.setLayoutData((Object)gridData);
        label.setText(labelMsg);
        return label;
    }
}

