/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.contexts.IContextService;
import org.python.pydev.editor.ActionInfo;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.OfflineActionTarget;
import org.python.pydev.shared_ui.EditorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyAssistDialog
extends PopupDialog {
    private final List<ActionInfo> bindings = new ArrayList<ActionInfo>();
    private Table completionsTable = null;
    private SortedMap<String, ActionInfo> keybindingToActionInfo;
    private OfflineActionTarget offlineActionTarget;

    public KeyAssistDialog(PyEdit pyedit) {
        super(null, 540676, false, false, false, false, null, null);
        this.setInfoText("   Ctrl+2 actions   ");
    }

    public final boolean close() {
        return this.close(false);
    }

    public final boolean close(boolean rememberState) {
        return this.close(rememberState, true);
    }

    private final boolean close(boolean rememberState, boolean resetState) {
        if (rememberState) {
            this.completionsTable = null;
        }
        return super.close();
    }

    private final void configureLocation(Point size) {
        int yCoord;
        int xCoord;
        Shell shell = this.getShell();
        Shell workbenchWindowShell = EditorUtils.getShell();
        if (workbenchWindowShell != null) {
            Rectangle workbenchWindowBounds = workbenchWindowShell.getBounds();
            xCoord = workbenchWindowBounds.x + workbenchWindowBounds.width - size.x - 10;
            yCoord = workbenchWindowBounds.y + workbenchWindowBounds.height - size.y - 10;
        } else {
            xCoord = 0;
            yCoord = 0;
        }
        Rectangle bounds = new Rectangle(xCoord, yCoord, size.x, size.y);
        shell.setBounds(this.getConstrainedShellBounds(bounds));
    }

    private final Point configureSize() {
        Shell shell = this.getShell();
        shell.pack();
        Point size = shell.getSize();
        Shell workbenchWindowShell = EditorUtils.getShell();
        if (workbenchWindowShell != null) {
            Point workbenchWindowSize = workbenchWindowShell.getSize();
            int maxWidth = workbenchWindowSize.x * 2 / 5;
            int maxHeight = workbenchWindowSize.y / 2;
            if (size.x > maxWidth) {
                size.x = maxWidth;
            }
            if (size.y > maxHeight) {
                size.y = maxHeight;
            }
        }
        shell.setSize(size);
        return size;
    }

    protected final Control createDialogArea(Composite parent) {
        this.registerShellType();
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setBackground(parent.getBackground());
        if (this.keybindingToActionInfo.isEmpty()) {
            this.createEmptyDialogArea(composite);
        } else {
            this.createTableDialogArea(composite);
        }
        return composite;
    }

    private final void createEmptyDialogArea(Composite parent) {
        Label noMatchesLabel = new Label(parent, 0);
        noMatchesLabel.setText("No matches");
        noMatchesLabel.setLayoutData((Object)new GridData(1808));
        noMatchesLabel.setBackground(parent.getBackground());
    }

    private final void createTableDialogArea(Composite parent) {
        this.completionsTable = new Table(parent, 65540);
        GridData gridData = new GridData(1808);
        this.completionsTable.setLayoutData((Object)gridData);
        this.completionsTable.setBackground(parent.getBackground());
        this.completionsTable.setLinesVisible(true);
        this.bindings.clear();
        TableColumn columnCommandName = new TableColumn(this.completionsTable, 16384, 0);
        TableColumn columnKeySequence = new TableColumn(this.completionsTable, 16384, 1);
        for (Map.Entry<String, ActionInfo> entry : this.keybindingToActionInfo.entrySet()) {
            String sequence = entry.getKey();
            ActionInfo actionInfo = entry.getValue();
            String[] text = new String[]{sequence, actionInfo.description};
            TableItem item = new TableItem(this.completionsTable, 0);
            item.setText(text);
            item.setData("ACTION_INFO", (Object)actionInfo);
            this.bindings.add(actionInfo);
        }
        Dialog.applyDialogFont((Control)parent);
        columnKeySequence.pack();
        columnCommandName.pack();
        this.completionsTable.addListener(14, new Listener(){

            public final void handleEvent(Event event) {
                KeyAssistDialog.this.executeKeyBinding(event);
            }
        });
    }

    private final void executeKeyBinding(Event trigger) {
        int selectionIndex = this.completionsTable.getSelectionIndex();
        if (selectionIndex >= 0) {
            ActionInfo actionInfo = this.bindings.get(selectionIndex);
            actionInfo.action.run();
            this.offlineActionTarget.leave();
        }
    }

    public final int open(Collection<ActionInfo> bindings, OfflineActionTarget offlineActionTarget) {
        Shell shell = this.getShell();
        if (shell != null) {
            this.close(false, false);
        }
        this.offlineActionTarget = offlineActionTarget;
        this.keybindingToActionInfo = new TreeMap<String, ActionInfo>();
        for (ActionInfo a : bindings) {
            this.keybindingToActionInfo.put(a.binding, a);
        }
        this.create();
        Point size = this.configureSize();
        this.configureLocation(size);
        return super.open();
    }

    private final void registerShellType() {
        Shell shell = this.getShell();
        IContextService contextService = (IContextService)EditorUtils.getActiveWorkbenchWindow().getService(IContextService.class);
        contextService.registerShell(shell, contextService.getShellType((Shell)shell.getParent()));
    }

    public Table getCompletionsTable() {
        return this.completionsTable;
    }
}

