/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.io.File;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;
import org.python.pydev.editor.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.shared_core.string.FastStringBuffer;

public final class CompletionRequest
implements ICompletionRequest {
    public File editorFile;
    public IPythonNature nature;
    public final IDocument doc;
    public String activationToken;
    public final String qualifier;
    public final String fullQualifier;
    public final int documentOffset;
    public final int qlen;
    public final IPyCodeCompletion codeCompletion;
    public boolean isInCalltip;
    public boolean isInMethodKeywordParam;
    public final int offsetForKeywordParam;
    public final int calltipOffset;
    public final boolean alreadyHasParams;
    private PySelection ps;
    public boolean showTemplates = true;
    private String initialModule;
    private IModule module;

    public CompletionRequest(File editorFile, IPythonNature nature, IDocument doc, String activationToken, int documentOffset, int qlen, IPyCodeCompletion codeCompletion, String qualifier) {
        this.editorFile = editorFile;
        this.nature = nature;
        this.doc = doc;
        this.activationToken = activationToken;
        this.documentOffset = documentOffset;
        this.qlen = qlen;
        this.codeCompletion = codeCompletion;
        this.qualifier = qualifier;
        this.fullQualifier = null;
        this.calltipOffset = 0;
        this.alreadyHasParams = false;
        this.offsetForKeywordParam = 0;
    }

    public CompletionRequest(File editorFile, IPythonNature nature, IDocument doc, int documentOffset, IPyCodeCompletion codeCompletion) {
        this.doc = doc;
        this.documentOffset = documentOffset;
        PySelection.ActivationTokenAndQual act = this.getPySelection().getActivationTokenAndQual(false, true);
        this.activationToken = act.activationToken;
        this.qualifier = act.qualifier;
        this.isInCalltip = act.changedForCalltip;
        this.isInMethodKeywordParam = act.isInMethodKeywordParam;
        this.offsetForKeywordParam = act.offsetForKeywordParam;
        this.alreadyHasParams = act.alreadyHasParams;
        this.calltipOffset = act.calltipOffset;
        int qlen = this.qualifier.length();
        this.editorFile = editorFile;
        this.nature = nature;
        this.qlen = qlen;
        this.codeCompletion = codeCompletion;
        this.fullQualifier = this.getPySelection().getActivationTokenAndQual(true)[1];
    }

    public CompletionRequest createCopyForKeywordParamRequest() {
        CompletionRequest request = new CompletionRequest(this.editorFile, this.nature, this.doc, this.offsetForKeywordParam, this.codeCompletion);
        request.isInMethodKeywordParam = false;
        return request;
    }

    public File getEditorFile() {
        return this.editorFile;
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("CompletionRequest[");
        buffer.append(" editorFile:");
        buffer.appendObject((Object)this.editorFile);
        buffer.append(" activationToken:");
        buffer.append(this.activationToken);
        buffer.append(" qualifier:");
        buffer.append(this.qualifier);
        buffer.append(" isInCalltip:");
        buffer.append(this.isInCalltip);
        buffer.append(" alreadyHasParams:");
        buffer.append(this.alreadyHasParams);
        buffer.append("]");
        return buffer.toString();
    }

    public PySelection getPySelection() {
        if (this.ps == null) {
            this.ps = new PySelection(this.doc, this.documentOffset);
        }
        return this.ps;
    }

    public String resolveModule() throws MisconfigurationException {
        if (this.initialModule == null && this.editorFile != null) {
            this.initialModule = this.nature.resolveModule(this.editorFile);
        }
        return this.initialModule;
    }

    public IModule getModule() throws MisconfigurationException {
        if (this.module == null) {
            this.module = AbstractASTManager.createModule(this.editorFile, this.doc, this.nature);
        }
        return this.module;
    }
}

