/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.AbstractPyCodeCompletion;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.editor.codecompletion.OverrideMethodCompletionProposal;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PyStringCodeCompletion;
import org.python.pydev.editor.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.editor.codecompletion.revisited.AssignAnalysis;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codecompletion.revisited.visitors.FindScopeVisitor;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.editor.refactoring.PyRefactoringFindDefinition;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.parser.jython.ast.factory.PyAstFactory;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_core.structure.ImmutableTuple;
import org.python.pydev.shared_core.structure.OrderedMap;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyCodeCompletion
extends AbstractPyCodeCompletion {
    public static ICallback<Object, CompletionRecursionException> onCompletionRecursionException;

    public List getCodeCompletionProposals(ITextViewer viewer, CompletionRequest request) throws CoreException, BadLocationException, IOException, MisconfigurationException, PythonNatureWithoutProjectException {
        ArrayList<ICompletionProposal> ret;
        block37: {
            if (request.getPySelection().getCursorLineContents().trim().startsWith("#")) {
                return new PyStringCodeCompletion().getCodeCompletionProposals(viewer, request);
            }
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((Object)this, (String)"Starting getCodeCompletionProposals");
                Log.addLogLevel();
                Log.toLogFile((Object)this, (String)("Request:" + request));
            }
            ret = new ArrayList<ICompletionProposal>();
            PySelection ps = request.getPySelection();
            int lineCtx = ps.isInDeclarationLine();
            if (lineCtx != PySelection.DECLARATION_NONE) {
                if (lineCtx == PySelection.DECLARATION_METHOD) {
                    Tuple insideParensBaseClasses;
                    Image imageOverride = PydevPlugin.getImageCache().get("icons/new/method_obj.gif");
                    String lineContentsToCursor = ps.getLineContentsToCursor();
                    PySelection.LineStartingScope scopeStart = ps.getPreviousLineThatStartsScope(PySelection.CLASS_TOKEN, false, PySelection.getFirstCharPosition((String)lineContentsToCursor));
                    String className = null;
                    if (scopeStart != null && (className = PySelection.getClassNameInLine((String)scopeStart.lineStartingScope)) != null && className.length() > 0 && (insideParensBaseClasses = ps.getInsideParentesisToks(true, scopeStart.iLineStartingScope)) != null) {
                        OrderedMap map = new OrderedMap();
                        for (String baseClass : (List)insideParensBaseClasses.o1) {
                            try {
                                CompletionState state = new CompletionState(-1, -1, null, request.nature, baseClass);
                                state.setActivationToken(baseClass);
                                state.setIsInCalltip(false);
                                IPythonNature pythonNature = request.nature;
                                this.checkPythonNature(pythonNature);
                                ICodeCompletionASTManager astManager = pythonNature.getAstManager();
                                if (astManager == null) {
                                    return ret;
                                }
                                IModule module = request.getModule();
                                if (module == null) continue;
                                IToken[] comps = astManager.getCompletionsForModule(module, (ICompletionState)state, true, true);
                                int i = 0;
                                while (i < comps.length) {
                                    IToken iToken = comps[i];
                                    String representation = iToken.getRepresentation();
                                    ImmutableTuple curr = (ImmutableTuple)map.get((Object)representation);
                                    if (curr == null || !(curr.o1 instanceof SourceToken)) {
                                        int type = iToken.getType();
                                        if (iToken instanceof SourceToken && ((SourceToken)iToken).getAst() instanceof FunctionDef) {
                                            map.put((Object)representation, (Object)new ImmutableTuple((Object)iToken, (Object)baseClass));
                                        } else if (type == 2 || type == -1 || type == 4) {
                                            map.put((Object)representation, (Object)new ImmutableTuple((Object)iToken, (Object)baseClass));
                                        }
                                    }
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        }
                        for (ImmutableTuple tokenAndBaseClass : map.values()) {
                            FunctionDef functionDef = null;
                            if (tokenAndBaseClass.o1 instanceof SourceToken) {
                                SourceToken sourceToken = (SourceToken)tokenAndBaseClass.o1;
                                SimpleNode ast = sourceToken.getAst();
                                if (ast instanceof FunctionDef) {
                                    functionDef = (FunctionDef)ast;
                                } else {
                                    functionDef = sourceToken.getAliased().createCopy();
                                    NameTok t = (NameTok)functionDef.name;
                                    t.id = sourceToken.getRepresentation();
                                }
                            } else {
                                String representation = ((IToken)tokenAndBaseClass.o1).getRepresentation();
                                PyAstFactory factory = new PyAstFactory(new AdapterPrefs(ps.getEndLineDelim(), (IGrammarVersionProvider)request.nature));
                                functionDef = factory.createFunctionDef(representation);
                                functionDef.args = factory.createArguments(true, new String[0]);
                                functionDef.args.vararg = new NameTok("args", 5);
                                functionDef.args.kwarg = new NameTok("kwargs", 6);
                                if (!representation.equals("__init__")) {
                                    functionDef.body = new stmtType[]{new Return(null)};
                                }
                            }
                            if (functionDef == null) continue;
                            ret.add(new OverrideMethodCompletionProposal(ps.getAbsoluteCursorOffset(), 0, 0, imageOverride, functionDef, (String)tokenAndBaseClass.o2, className));
                        }
                    }
                }
                request.showTemplates = false;
                return ret;
            }
            try {
                IPythonNature pythonNature = request.nature;
                this.checkPythonNature(pythonNature);
                ICodeCompletionASTManager astManager = pythonNature.getAstManager();
                if (astManager == null) {
                    return ret;
                }
                ArrayList<Object> tokensList = new ArrayList<Object>();
                this.lazyStartShell(request);
                String trimmed = request.activationToken.replace('.', ' ').trim();
                ICodeCompletionASTManager.ImportInfo importsTipper = this.getImportsTipperStr(request);
                int line = request.doc.getLineOfOffset(request.documentOffset);
                IRegion region = request.doc.getLineInformation(line);
                CompletionState state = new CompletionState(line, request.documentOffset - region.getOffset(), null, request.nature, request.qualifier);
                state.setIsInCalltip(request.isInCalltip);
                HashMap<String, IToken> alreadyChecked = new HashMap<String, IToken>();
                boolean importsTip = false;
                if (importsTipper.importsTipperStr.length() != 0) {
                    request.isInCalltip = false;
                    request.isInMethodKeywordParam = false;
                    importsTip = this.doImportCompletion(request, astManager, tokensList, importsTipper);
                } else if (trimmed.length() > 0 && request.activationToken.indexOf(46) != -1) {
                    this.doTokenCompletion(request, astManager, tokensList, trimmed, state);
                    this.handleKeywordParam(request, line, alreadyChecked);
                } else {
                    this.doGlobalsCompletion(request, astManager, tokensList, state);
                    this.handleKeywordParam(request, line, alreadyChecked);
                }
                String lowerCaseQual = request.qualifier.toLowerCase();
                if (lowerCaseQual.length() >= PyCodeCompletionPreferencesPage.getArgumentsDeepAnalysisNChars()) {
                    state.pushFindResolveImportMemoryCtx();
                    try {
                        ListIterator it = tokensList.listIterator();
                        while (it.hasNext()) {
                            IToken initialToken;
                            Object o = it.next();
                            if (!(o instanceof IToken)) continue;
                            it.remove();
                            IToken token = initialToken = (IToken)o;
                            String strRep = token.getRepresentation();
                            IToken prev = (IToken)alreadyChecked.get(strRep);
                            if (prev != null && prev.getArgs().length() != 0 || !strRep.toLowerCase().startsWith(lowerCaseQual)) continue;
                            IModule current = request.getModule();
                            while (token.isImportFrom()) {
                                if (token.getArgs().length() > 0) break;
                                ICompletionState s = state.getCopyForResolveImportWithActTok(token.getRepresentation());
                                s.checkFindResolveImportMemory(token);
                                ImmutableTuple modTok = astManager.resolveImport(s, token, current);
                                IToken token2 = (IToken)modTok.o2;
                                current = (IModule)modTok.o1;
                                if (token2 == null || initialToken == token2) break;
                                String args = token2.getArgs();
                                if (args.length() > 0) {
                                    initialToken.setArgs(args);
                                    initialToken.setDocStr(token2.getDocStr());
                                    if (!(initialToken instanceof SourceToken) || !(token2 instanceof SourceToken)) break;
                                    SourceToken initialSourceToken = (SourceToken)initialToken;
                                    SourceToken token2SourceToken = (SourceToken)token2;
                                    initialSourceToken.setAst(token2SourceToken.getAst());
                                    break;
                                }
                                if (token2 == null || token2.equals(token) && token2.getArgs().equals(token.getArgs()) && token2.getParentPackage().equals(token.getParentPackage())) break;
                                token = token2;
                            }
                            alreadyChecked.put(strRep, initialToken);
                        }
                    }
                    finally {
                        state.popFindResolveImportMemoryCtx();
                    }
                }
                tokensList.addAll(alreadyChecked.values());
                this.changeItokenToCompletionPropostal(viewer, request, ret, tokensList, importsTip, state);
            }
            catch (CompletionRecursionException e) {
                if (onCompletionRecursionException != null) {
                    onCompletionRecursionException.call((Object)e);
                }
                if (!DebugSettings.DEBUG_CODE_COMPLETION) break block37;
                Log.toLogFile((Exception)((Object)e));
            }
        }
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.remLogLevel();
            Log.toLogFile((Object)this, (String)("Finished completion. Returned:" + ret.size() + " completions.\r\n"));
        }
        return ret;
    }

    private void handleKeywordParam(CompletionRequest request, int line, Map<String, IToken> alreadyChecked) throws BadLocationException, CompletionRecursionException {
        if (request.isInMethodKeywordParam) {
            PySelection ps = new PySelection(request.doc, request.offsetForKeywordParam);
            RefactoringRequest findRequest = new RefactoringRequest(request.editorFile, ps, (IProgressMonitor)new NullProgressMonitor(), request.nature, null);
            ArrayList<IDefinition> selected = new ArrayList<IDefinition>();
            PyRefactoringFindDefinition.findActualDefinition(findRequest, new CompletionCache(), selected);
            HashSet<String> ignore = new HashSet<String>();
            ignore.add("self");
            ignore.add("cls");
            for (IDefinition iDefinition : selected) {
                if (!(iDefinition instanceof Definition)) continue;
                Definition definition = (Definition)iDefinition;
                if (definition.ast == null) continue;
                String args = NodeUtils.getNodeArgs((SimpleNode)definition.ast);
                String fullArgs = NodeUtils.getFullArgs((SimpleNode)definition.ast);
                StringTokenizer tokenizer = new StringTokenizer(args, "(, )");
                while (tokenizer.hasMoreTokens()) {
                    String nextToken = tokenizer.nextToken();
                    if (ignore.contains(nextToken)) continue;
                    String kwParam = String.valueOf(nextToken) + "=";
                    NameTok node = new NameTok(kwParam, 6);
                    SourceToken sourceToken = new SourceToken((SimpleNode)node, kwParam, "", "", "", 9);
                    sourceToken.setDocStr(fullArgs);
                    alreadyChecked.put(kwParam, sourceToken);
                }
            }
        }
    }

    private void doGlobalsCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, List<Object> tokensList, ICompletionState state) throws CompletionRecursionException, MisconfigurationException {
        IModule module;
        state.setActivationToken(request.activationToken);
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.toLogFile((Object)this, (String)"astManager.getCompletionsForToken");
            Log.addLogLevel();
        }
        if ((module = request.getModule()) == null) {
            Log.remLogLevel();
            Log.toLogFile((Object)this, (String)"END astManager.getCompletionsForToken: null module");
            return;
        }
        IToken[] comps = astManager.getCompletionsForModule(module, state, true, true);
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.remLogLevel();
            Log.toLogFile((Object)this, (String)"END astManager.getCompletionsForToken");
        }
        int i = 0;
        while (i < comps.length) {
            tokensList.add(comps[i]);
            ++i;
        }
        tokensList.addAll(this.getGlobalsFromParticipants(request, state));
    }

    private void doTokenCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, List<Object> tokensList, String trimmed, ICompletionState state) throws CompletionRecursionException, MisconfigurationException {
        if (request.activationToken.endsWith(".")) {
            request.activationToken = request.activationToken.substring(0, request.activationToken.length() - 1);
        }
        String initialActivationToken = request.activationToken;
        int parI = request.activationToken.indexOf(40);
        if (parI != -1) {
            request.activationToken = request.activationToken.substring(0, parI);
        }
        char[] toks = new char[]{'.', ' '};
        boolean lookInGlobals = true;
        if (trimmed.equals("self") || FullRepIterable.getFirstPart((String)trimmed, (char[])toks).equals("self")) {
            lookInGlobals = !PyCodeCompletion.getSelfOrClsCompletions(request, tokensList, state, false, true, "self");
        } else if (trimmed.equals("cls") || FullRepIterable.getFirstPart((String)trimmed, (char[])toks).equals("cls")) {
            boolean bl = lookInGlobals = !PyCodeCompletion.getSelfOrClsCompletions(request, tokensList, state, false, true, "cls");
        }
        if (lookInGlobals) {
            state.setActivationToken(initialActivationToken);
            IModule module = request.getModule();
            if (module != null) {
                IToken[] comps = astManager.getCompletionsForModule(module, state, true, true);
                int i = 0;
                while (i < comps.length) {
                    tokensList.add(comps[i]);
                    ++i;
                }
            }
        }
    }

    private boolean doImportCompletion(CompletionRequest request, ICodeCompletionASTManager astManager, List<Object> tokensList, ICodeCompletionASTManager.ImportInfo importsTipper) throws CompletionRecursionException, MisconfigurationException {
        boolean importsTip = true;
        importsTipper.importsTipperStr = importsTipper.importsTipperStr.trim();
        IToken[] imports = astManager.getCompletionsForImport(importsTipper, (ICompletionRequest)request, false);
        int i = 0;
        while (i < imports.length) {
            tokensList.add(imports[i]);
            ++i;
        }
        return importsTip;
    }

    private void checkPythonNature(IPythonNature pythonNature) {
        if (pythonNature == null) {
            throw new RuntimeException("Unable to get python nature.");
        }
    }

    private void lazyStartShell(CompletionRequest request) throws IOException, CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.toLogFile((Object)this, (String)"AbstractShell.getServerShell");
        }
        if (CompiledModule.COMPILED_MODULES_ENABLED) {
            AbstractShell.getServerShell(request.nature, 1);
        }
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            Log.toLogFile((Object)this, (String)"END AbstractShell.getServerShell");
        }
    }

    private Collection<Object> getGlobalsFromParticipants(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        ArrayList<Object> ret = new ArrayList<Object>();
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_completion");
        for (IPyDevCompletionParticipant participant : participants) {
            ret.addAll(participant.getGlobalCompletions(request, state));
        }
        return ret;
    }

    public static boolean getSelfOrClsCompletions(CompletionRequest request, List theList, ICompletionState state, boolean getOnlySupers, boolean checkIfInCorrectScope, String lookForRep) throws MisconfigurationException {
        IModule module = request.getModule();
        SimpleNode s = null;
        if (module instanceof SourceModule) {
            SourceModule sourceModule = (SourceModule)module;
            s = sourceModule.getAst();
        }
        if (s != null) {
            FindScopeVisitor visitor;
            block8: {
                visitor = new FindScopeVisitor(state.getLine(), 0);
                s.accept((VisitorIF)visitor);
                if (!checkIfInCorrectScope) break block8;
                boolean scopeCorrect = false;
                FastStack scopeStack = visitor.scope.getScopeStack();
                Iterator it = scopeStack.topDownIterator();
                while (!scopeCorrect && it.hasNext()) {
                    String rep;
                    SimpleNode node = (SimpleNode)it.next();
                    if (!(node instanceof FunctionDef)) continue;
                    FunctionDef funcDef = (FunctionDef)node;
                    if (funcDef.args == null || funcDef.args.args == null || funcDef.args.args.length <= 0 || (rep = NodeUtils.getRepresentationString((SimpleNode)funcDef.args.args[0])) == null || !rep.equals("self") && !rep.equals("cls")) continue;
                    scopeCorrect = true;
                }
                if (scopeCorrect) break block8;
                return false;
            }
            try {
                if (lookForRep.equals("self")) {
                    state.setLookingFor(1);
                } else {
                    state.setLookingFor(3);
                }
                PyCodeCompletion.getSelfOrClsCompletions(visitor.scope, request, theList, state, getOnlySupers);
            }
            catch (Exception e1) {
                Log.log((Throwable)e1);
            }
            return true;
        }
        return false;
    }

    public static void getSelfOrClsCompletions(ILocalScope scope, CompletionRequest request, List theList, ICompletionState state, boolean getOnlySupers) throws BadLocationException, MisconfigurationException {
        for (SimpleNode node : scope) {
            if (!(node instanceof ClassDef)) continue;
            ClassDef d = (ClassDef)node;
            if (getOnlySupers) {
                int i = 0;
                while (i < d.bases.length) {
                    if (d.bases[i] instanceof Name) {
                        Name n = (Name)d.bases[i];
                        state.setActivationToken(n.id);
                        try {
                            ICodeCompletionASTManager astManager = request.nature.getAstManager();
                            IModule module = request.getModule();
                            if (module != null) {
                                IToken[] completions = astManager.getCompletionsForModule(module, state, true, true);
                                int j = 0;
                                while (j < completions.length) {
                                    theList.add(completions[j]);
                                    ++j;
                                }
                            }
                        }
                        catch (CompletionRecursionException completionRecursionException) {}
                    }
                    ++i;
                }
                continue;
            }
            String trimmed = request.activationToken.replace('.', ' ').trim();
            String[] actTokStrs = trimmed.split(" ");
            if (actTokStrs.length == 0 || !actTokStrs[0].equals("self") && !actTokStrs[0].equals("cls")) {
                throw new AssertionError((Object)"We need to have at least one token (self or cls) for doing completions in the class.");
            }
            if (actTokStrs.length == 1) {
                state.setActivationToken(NodeUtils.getNameFromNameTok((NameTok)((NameTok)d.name)));
                try {
                    ICodeCompletionASTManager astManager = request.nature.getAstManager();
                    IModule module = request.getModule();
                    IToken[] completions = astManager.getCompletionsForModule(module, state, true, true);
                    int j = 0;
                    while (j < completions.length) {
                        theList.add(completions[j]);
                        ++j;
                    }
                }
                catch (CompletionRecursionException completionRecursionException) {}
                continue;
            }
            int line = request.doc.getLineOfOffset(request.documentOffset);
            IRegion region = request.doc.getLineInformationOfOffset(request.documentOffset);
            int col = request.documentOffset - region.getOffset();
            IModule module = request.getModule();
            AbstractASTManager astMan = (AbstractASTManager)request.nature.getAstManager();
            theList.addAll(new AssignAnalysis().getAssignCompletions((ICodeCompletionASTManager)astMan, (IModule)module, (ICompletionState)new CompletionState((int)line, (int)col, (String)request.activationToken, (IPythonNature)request.nature, (String)request.qualifier)).completions);
        }
    }
}

