/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.templates;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class DocumentTemplateContextWithIndent
extends DocumentTemplateContext {
    private final String indentTo;
    private IIndentPrefs indentPrefs;

    DocumentTemplateContextWithIndent(TemplateContextType type, IDocument document, int offset, int length, String indentTo, IIndentPrefs indentPrefs) {
        super(type, document, offset, length);
        this.indentTo = indentTo;
        this.indentPrefs = indentPrefs;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        String spacesIndentString = StringUtils.createSpaceString((int)this.indentPrefs.getTabWidth());
        String pattern = template.getPattern();
        List splitted = StringUtils.splitInLines((String)pattern);
        boolean changed = false;
        if (this.indentPrefs.getUseSpaces(true)) {
            if (pattern.indexOf("\t") != -1) {
                template = this.createNewTemplate(template, org.python.pydev.shared_core.string.StringUtils.replaceAll((String)pattern, (String)"\t", (String)spacesIndentString));
                changed = true;
            }
        } else if (pattern.indexOf(spacesIndentString) != -1) {
            FastStringBuffer newPattern = new FastStringBuffer();
            FastStringBuffer newTabsIndent = new FastStringBuffer();
            int i = 0;
            while (i < splitted.size()) {
                String string = (String)splitted.get(i);
                int spacesFound = 0;
                while (string.length() > 0 && string.charAt(0) == ' ') {
                    string = string.substring(1);
                    ++spacesFound;
                }
                int tabsToAdd = 0;
                if (spacesFound > 0) {
                    tabsToAdd = spacesFound / spacesIndentString.length();
                    if (spacesFound % spacesIndentString.length() != 0) {
                        ++tabsToAdd;
                    }
                    newTabsIndent.clear();
                    int j = 0;
                    while (j < tabsToAdd) {
                        newTabsIndent.append("\t");
                        ++j;
                    }
                    newPattern.append(newTabsIndent);
                }
                newPattern.append(string);
                ++i;
            }
            template = this.createNewTemplate(template, newPattern.toString());
            changed = true;
        }
        if (changed) {
            pattern = template.getPattern();
            splitted = StringUtils.splitInLines((String)pattern);
        }
        String indentToStr = this.indentTo != null ? this.indentTo : "";
        String endLineDelim = PySelection.getDelimiter((IDocument)this.getDocument());
        int size = splitted.size();
        if (size > 0) {
            FastStringBuffer buffer = new FastStringBuffer("", pattern.length() + size * 2 + (size + 1) * indentToStr.length());
            int i = 0;
            while (i < size) {
                if (i != 0) {
                    buffer.append(indentToStr);
                }
                String str = (String)splitted.get(i);
                boolean hasNewLine = false;
                if (str.endsWith("\r") || str.endsWith("\n")) {
                    hasNewLine = true;
                    str = str.endsWith("\r\n") ? str.substring(0, str.length() - 2) : str.substring(0, str.length() - 1);
                }
                buffer.append(str);
                if (hasNewLine) {
                    buffer.append(endLineDelim);
                }
                ++i;
            }
            template = this.createNewTemplate(template, buffer.toString());
        }
        try {
            TemplateTranslator translator = new TemplateTranslator();
            TemplateBuffer templateBuffer = translator.translate(template);
            this.getContextType().resolve(templateBuffer, (TemplateContext)this);
            return templateBuffer;
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Template createNewTemplate(Template template, String newString) {
        return new Template(template.getName(), template.getDescription(), template.getContextTypeId(), newString, template.isAutoInsertable());
    }
}

